/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.immutables.value.Value;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.ImmutablePdbCompactFragment;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.pdb.analysis.ResidueTorsionAngles;
import pl.poznan.put.pdb.analysis.SingleTypedResidueCollection;
import pl.poznan.put.torsion.TorsionAngleType;
import pl.poznan.put.torsion.TorsionAngleValue;

@Value.Immutable
public abstract class PdbCompactFragment
implements SingleTypedResidueCollection {
    @Override
    @Value.Parameter(order=1)
    public abstract List<PdbResidue> residues();

    @Value.Default
    public String name() {
        if (this.residues().isEmpty()) {
            return "";
        }
        return this.residues().get(0) + ":" + this.residues().size();
    }

    public final PdbCompactFragment shifted(int shift, int size) {
        return ImmutablePdbCompactFragment.of(this.residues().subList(shift, shift + size));
    }

    public final ResidueTorsionAngles torsionAngles(PdbResidueIdentifier identifier) {
        return this.angleValues().stream().filter(angles -> Objects.equals(identifier, angles.identifier())).findFirst().orElseThrow(() -> new IllegalArgumentException("Failed to find torsion angles values for residue: " + identifier));
    }

    public final String toString() {
        PdbResidue first = this.residues().get(0);
        PdbResidue last = this.residues().get(this.residues().size() - 1);
        return first + " - " + last + " (count: " + this.residues().size() + ')';
    }

    @Value.Lazy
    protected Set<TorsionAngleType> angleTypes() {
        return this.angleValues().stream().map(ResidueTorsionAngles::values).flatMap(Collection::stream).map(TorsionAngleValue::angleType).collect(Collectors.toSet());
    }

    @Value.Lazy
    protected List<ResidueTorsionAngles> angleValues() {
        return IntStream.range(0, this.residues().size()).boxed().map(i -> ResidueTorsionAngles.calculate(this.residues(), i)).collect(Collectors.toList());
    }
}

