/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.biojava.nbio.structure.Chain;
import org.immutables.value.Value;
import pl.poznan.put.pdb.analysis.DefaultPdbResidue;
import pl.poznan.put.pdb.analysis.ImmutablePdbChain;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.pdb.analysis.SingleTypedResidueCollection;

@Value.Immutable
public abstract class PdbChain
implements Comparable<PdbChain>,
SingleTypedResidueCollection {
    public static PdbChain fromBioJavaChain(Chain chain) {
        List<PdbResidue> residues = chain.getAtomGroups().stream().map(DefaultPdbResidue::fromBioJavaGroup).collect(Collectors.toList());
        return ImmutablePdbChain.of(chain.getId(), residues);
    }

    @Value.Parameter(order=1)
    public abstract String identifier();

    @Override
    @Value.Parameter(order=2)
    public abstract List<PdbResidue> residues();

    @Override
    public final int compareTo(@Nonnull PdbChain t) {
        return this.identifier().compareTo(t.identifier());
    }
}

