/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.atom.AtomType;
import pl.poznan.put.atom.Bond;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.protein.AminoAcidTorsionAngle;
import pl.poznan.put.rna.NucleotideTorsionAngle;
import pl.poznan.put.torsion.AtomBasedTorsionAngleType;
import pl.poznan.put.torsion.MasterTorsionAngleType;

public enum MoleculeType {
    RNA,
    PROTEIN,
    UNKNOWN;


    private static boolean areNucleotidesConnected(PdbResidue r1, PdbResidue r2) {
        PdbAtomLine p;
        if (!r1.hasAtom(AtomName.O3p) || !r2.hasAtom(AtomName.P)) {
            return false;
        }
        PdbAtomLine o3p = r1.findAtom(AtomName.O3p);
        return o3p.distanceTo(p = r2.findAtom(AtomName.P)) <= Bond.length(AtomType.O, AtomType.P).max() * 1.5;
    }

    private static boolean areAminoAcidsConnected(PdbResidue r1, PdbResidue r2) {
        PdbAtomLine n;
        if (!r1.hasAtom(AtomName.C) || !r2.hasAtom(AtomName.N)) {
            return false;
        }
        PdbAtomLine c = r1.findAtom(AtomName.C);
        return c.distanceTo(n = r2.findAtom(AtomName.N)) <= Bond.length(AtomType.C, AtomType.N).max() * 1.5;
    }

    public boolean areConnected(PdbResidue r1, PdbResidue r2) {
        switch (this) {
            case RNA: {
                return MoleculeType.areNucleotidesConnected(r1, r2);
            }
            case PROTEIN: {
                return MoleculeType.areAminoAcidsConnected(r1, r2);
            }
        }
        return false;
    }

    public List<MasterTorsionAngleType> allAngleTypes() {
        switch (this) {
            case RNA: {
                return Arrays.stream(NucleotideTorsionAngle.values()).filter(masterType -> masterType.angleTypes().stream().allMatch(angleType -> angleType instanceof AtomBasedTorsionAngleType)).collect(Collectors.toList());
            }
            case PROTEIN: {
                return Arrays.stream(AminoAcidTorsionAngle.values()).filter(masterType -> masterType.angleTypes().stream().allMatch(angleType -> angleType instanceof AtomBasedTorsionAngleType)).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public List<MasterTorsionAngleType> mainAngleTypes() {
        switch (this) {
            case RNA: {
                return Stream.of(NucleotideTorsionAngle.ALPHA, NucleotideTorsionAngle.BETA, NucleotideTorsionAngle.GAMMA, NucleotideTorsionAngle.DELTA, NucleotideTorsionAngle.EPSILON, NucleotideTorsionAngle.ZETA, NucleotideTorsionAngle.CHI).collect(Collectors.toList());
            }
            case PROTEIN: {
                return Stream.of(AminoAcidTorsionAngle.PHI, AminoAcidTorsionAngle.PSI, AminoAcidTorsionAngle.OMEGA).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }
}

