/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.ResidueTorsionAngles;
import pl.poznan.put.torsion.TorsionAngleValue;

@ParametersAreNonnullByDefault
@Generated(from="ResidueTorsionAngles", generator="Immutables")
@Immutable
public final class ImmutableResidueTorsionAngles
extends ResidueTorsionAngles {
    private final PdbResidueIdentifier identifier;
    private final List<TorsionAngleValue> values;

    private ImmutableResidueTorsionAngles(PdbResidueIdentifier identifier, Iterable<? extends TorsionAngleValue> values) {
        this.identifier = Objects.requireNonNull(identifier, "identifier");
        this.values = ImmutableResidueTorsionAngles.createUnmodifiableList(false, ImmutableResidueTorsionAngles.createSafeList(values, true, false));
    }

    private ImmutableResidueTorsionAngles(ImmutableResidueTorsionAngles original, PdbResidueIdentifier identifier, List<TorsionAngleValue> values) {
        this.identifier = identifier;
        this.values = values;
    }

    @Override
    public PdbResidueIdentifier identifier() {
        return this.identifier;
    }

    @Override
    protected List<TorsionAngleValue> values() {
        return this.values;
    }

    public final ImmutableResidueTorsionAngles withIdentifier(PdbResidueIdentifier value) {
        if (this.identifier == value) {
            return this;
        }
        PdbResidueIdentifier newValue = Objects.requireNonNull(value, "identifier");
        return new ImmutableResidueTorsionAngles(this, newValue, this.values);
    }

    public final ImmutableResidueTorsionAngles withValues(TorsionAngleValue ... elements) {
        List<TorsionAngleValue> newValue = ImmutableResidueTorsionAngles.createUnmodifiableList(false, ImmutableResidueTorsionAngles.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableResidueTorsionAngles(this, this.identifier, newValue);
    }

    public final ImmutableResidueTorsionAngles withValues(Iterable<? extends TorsionAngleValue> elements) {
        if (this.values == elements) {
            return this;
        }
        List<TorsionAngleValue> newValue = ImmutableResidueTorsionAngles.createUnmodifiableList(false, ImmutableResidueTorsionAngles.createSafeList(elements, true, false));
        return new ImmutableResidueTorsionAngles(this, this.identifier, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResidueTorsionAngles && this.equalTo((ImmutableResidueTorsionAngles)another);
    }

    private boolean equalTo(ImmutableResidueTorsionAngles another) {
        return this.identifier.equals(another.identifier) && this.values.equals(another.values);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier.hashCode();
        h += (h << 5) + this.values.hashCode();
        return h;
    }

    public String toString() {
        return "ResidueTorsionAngles{identifier=" + this.identifier + ", values=" + this.values + "}";
    }

    public static ImmutableResidueTorsionAngles of(PdbResidueIdentifier identifier, List<TorsionAngleValue> values) {
        return ImmutableResidueTorsionAngles.of(identifier, values);
    }

    public static ImmutableResidueTorsionAngles of(PdbResidueIdentifier identifier, Iterable<? extends TorsionAngleValue> values) {
        return new ImmutableResidueTorsionAngles(identifier, values);
    }

    public static ImmutableResidueTorsionAngles copyOf(ResidueTorsionAngles instance) {
        if (instance instanceof ImmutableResidueTorsionAngles) {
            return (ImmutableResidueTorsionAngles)instance;
        }
        return ImmutableResidueTorsionAngles.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ResidueTorsionAngles", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        @Nullable
        private PdbResidueIdentifier identifier;
        private List<TorsionAngleValue> values = new ArrayList<TorsionAngleValue>();

        private Builder() {
        }

        public final Builder from(ResidueTorsionAngles instance) {
            Objects.requireNonNull(instance, "instance");
            this.identifier(instance.identifier());
            this.addAllValues(instance.values());
            return this;
        }

        public final Builder identifier(PdbResidueIdentifier identifier) {
            this.identifier = Objects.requireNonNull(identifier, "identifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addValues(TorsionAngleValue element) {
            this.values.add(Objects.requireNonNull(element, "values element"));
            return this;
        }

        public final Builder addValues(TorsionAngleValue ... elements) {
            for (TorsionAngleValue element : elements) {
                this.values.add(Objects.requireNonNull(element, "values element"));
            }
            return this;
        }

        public final Builder values(Iterable<? extends TorsionAngleValue> elements) {
            this.values.clear();
            return this.addAllValues(elements);
        }

        public final Builder addAllValues(Iterable<? extends TorsionAngleValue> elements) {
            for (TorsionAngleValue torsionAngleValue : elements) {
                this.values.add(Objects.requireNonNull(torsionAngleValue, "values element"));
            }
            return this;
        }

        public ImmutableResidueTorsionAngles build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableResidueTorsionAngles(null, this.identifier, ImmutableResidueTorsionAngles.createUnmodifiableList(true, this.values));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("identifier");
            }
            return "Cannot build ResidueTorsionAngles, some of required attributes are not set " + attributes;
        }
    }
}

