/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.analysis.PdbCompactFragment;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.pdb.analysis.ResidueCollection;
import pl.poznan.put.pdb.analysis.ResidueTorsionAngles;
import pl.poznan.put.torsion.TorsionAngleType;

@ParametersAreNonnullByDefault
@Generated(from="PdbCompactFragment", generator="Immutables")
@Immutable
public final class ImmutablePdbCompactFragment
extends PdbCompactFragment {
    private final List<PdbResidue> residues;
    private final String name;
    private volatile transient long lazyInitBitmap;
    private static final long ANGLE_TYPES_LAZY_INIT_BIT = 1L;
    private transient Set<TorsionAngleType> angleTypes;
    private static final long ANGLE_VALUES_LAZY_INIT_BIT = 2L;
    private transient List<ResidueTorsionAngles> angleValues;

    private ImmutablePdbCompactFragment(Iterable<? extends PdbResidue> residues) {
        this.residues = ImmutablePdbCompactFragment.createUnmodifiableList(false, ImmutablePdbCompactFragment.createSafeList(residues, true, false));
        this.name = Objects.requireNonNull(super.name(), "name");
    }

    private ImmutablePdbCompactFragment(Builder builder) {
        this.residues = ImmutablePdbCompactFragment.createUnmodifiableList(true, builder.residues);
        this.name = builder.name != null ? builder.name : Objects.requireNonNull(super.name(), "name");
    }

    private ImmutablePdbCompactFragment(List<PdbResidue> residues, String name) {
        this.residues = residues;
        this.name = name;
    }

    @Override
    public List<PdbResidue> residues() {
        return this.residues;
    }

    @Override
    public String name() {
        return this.name;
    }

    public final ImmutablePdbCompactFragment withResidues(PdbResidue ... elements) {
        List<PdbResidue> newValue = ImmutablePdbCompactFragment.createUnmodifiableList(false, ImmutablePdbCompactFragment.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePdbCompactFragment(newValue, this.name);
    }

    public final ImmutablePdbCompactFragment withResidues(Iterable<? extends PdbResidue> elements) {
        if (this.residues == elements) {
            return this;
        }
        List<PdbResidue> newValue = ImmutablePdbCompactFragment.createUnmodifiableList(false, ImmutablePdbCompactFragment.createSafeList(elements, true, false));
        return new ImmutablePdbCompactFragment(newValue, this.name);
    }

    public final ImmutablePdbCompactFragment withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbCompactFragment(this.residues, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePdbCompactFragment && this.equalTo((ImmutablePdbCompactFragment)another);
    }

    private boolean equalTo(ImmutablePdbCompactFragment another) {
        return this.residues.equals(another.residues) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.residues.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set<TorsionAngleType> angleTypes() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutablePdbCompactFragment immutablePdbCompactFragment = this;
            synchronized (immutablePdbCompactFragment) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.angleTypes = Objects.requireNonNull(super.angleTypes(), "angleTypes");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.angleTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<ResidueTorsionAngles> angleValues() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutablePdbCompactFragment immutablePdbCompactFragment = this;
            synchronized (immutablePdbCompactFragment) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.angleValues = Objects.requireNonNull(super.angleValues(), "angleValues");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.angleValues;
    }

    public static ImmutablePdbCompactFragment of(List<PdbResidue> residues) {
        return ImmutablePdbCompactFragment.of(residues);
    }

    public static ImmutablePdbCompactFragment of(Iterable<? extends PdbResidue> residues) {
        return new ImmutablePdbCompactFragment(residues);
    }

    public static ImmutablePdbCompactFragment copyOf(PdbCompactFragment instance) {
        if (instance instanceof ImmutablePdbCompactFragment) {
            return (ImmutablePdbCompactFragment)instance;
        }
        return ImmutablePdbCompactFragment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PdbCompactFragment", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<PdbResidue> residues = new ArrayList<PdbResidue>();
        @Nullable
        private String name;

        private Builder() {
        }

        public final Builder from(PdbCompactFragment instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ResidueCollection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ResidueCollection instance;
            long bits = 0L;
            if (object instanceof PdbCompactFragment) {
                instance = (PdbCompactFragment)object;
                this.name(((PdbCompactFragment)instance).name());
                if ((bits & 1L) == 0L) {
                    this.addAllResidues(((PdbCompactFragment)instance).residues());
                    bits |= 1L;
                }
            }
            if (object instanceof ResidueCollection) {
                instance = (ResidueCollection)object;
                if ((bits & 1L) == 0L) {
                    this.addAllResidues(instance.residues());
                    bits |= 1L;
                }
            }
        }

        public final Builder addResidues(PdbResidue element) {
            this.residues.add(Objects.requireNonNull(element, "residues element"));
            return this;
        }

        public final Builder addResidues(PdbResidue ... elements) {
            for (PdbResidue element : elements) {
                this.residues.add(Objects.requireNonNull(element, "residues element"));
            }
            return this;
        }

        public final Builder residues(Iterable<? extends PdbResidue> elements) {
            this.residues.clear();
            return this.addAllResidues(elements);
        }

        public final Builder addAllResidues(Iterable<? extends PdbResidue> elements) {
            for (PdbResidue pdbResidue : elements) {
                this.residues.add(Objects.requireNonNull(pdbResidue, "residues element"));
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        public ImmutablePdbCompactFragment build() {
            return new ImmutablePdbCompactFragment(this);
        }
    }
}

