/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.analysis.PdbChain;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.pdb.analysis.ResidueCollection;

@ParametersAreNonnullByDefault
@Generated(from="PdbChain", generator="Immutables")
@Immutable
public final class ImmutablePdbChain
extends PdbChain {
    private final String identifier;
    private final List<PdbResidue> residues;

    private ImmutablePdbChain(String identifier, Iterable<? extends PdbResidue> residues) {
        this.identifier = Objects.requireNonNull(identifier, "identifier");
        this.residues = ImmutablePdbChain.createUnmodifiableList(false, ImmutablePdbChain.createSafeList(residues, true, false));
    }

    private ImmutablePdbChain(ImmutablePdbChain original, String identifier, List<PdbResidue> residues) {
        this.identifier = identifier;
        this.residues = residues;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public List<PdbResidue> residues() {
        return this.residues;
    }

    public final ImmutablePdbChain withIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "identifier");
        if (this.identifier.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbChain(this, newValue, this.residues);
    }

    public final ImmutablePdbChain withResidues(PdbResidue ... elements) {
        List<PdbResidue> newValue = ImmutablePdbChain.createUnmodifiableList(false, ImmutablePdbChain.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePdbChain(this, this.identifier, newValue);
    }

    public final ImmutablePdbChain withResidues(Iterable<? extends PdbResidue> elements) {
        if (this.residues == elements) {
            return this;
        }
        List<PdbResidue> newValue = ImmutablePdbChain.createUnmodifiableList(false, ImmutablePdbChain.createSafeList(elements, true, false));
        return new ImmutablePdbChain(this, this.identifier, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePdbChain && this.equalTo((ImmutablePdbChain)another);
    }

    private boolean equalTo(ImmutablePdbChain another) {
        return this.identifier.equals(another.identifier) && this.residues.equals(another.residues);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier.hashCode();
        h += (h << 5) + this.residues.hashCode();
        return h;
    }

    public String toString() {
        return "PdbChain{identifier=" + this.identifier + ", residues=" + this.residues + "}";
    }

    public static ImmutablePdbChain of(String identifier, List<PdbResidue> residues) {
        return ImmutablePdbChain.of(identifier, residues);
    }

    public static ImmutablePdbChain of(String identifier, Iterable<? extends PdbResidue> residues) {
        return new ImmutablePdbChain(identifier, residues);
    }

    public static ImmutablePdbChain copyOf(PdbChain instance) {
        if (instance instanceof ImmutablePdbChain) {
            return (ImmutablePdbChain)instance;
        }
        return ImmutablePdbChain.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PdbChain", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        @Nullable
        private String identifier;
        private List<PdbResidue> residues = new ArrayList<PdbResidue>();

        private Builder() {
        }

        public final Builder from(PdbChain instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ResidueCollection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ResidueCollection instance;
            long bits = 0L;
            if (object instanceof PdbChain) {
                instance = (PdbChain)object;
                this.identifier(((PdbChain)instance).identifier());
                if ((bits & 1L) == 0L) {
                    this.addAllResidues(((PdbChain)instance).residues());
                    bits |= 1L;
                }
            }
            if (object instanceof ResidueCollection) {
                instance = (ResidueCollection)object;
                if ((bits & 1L) == 0L) {
                    this.addAllResidues(instance.residues());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(String identifier) {
            this.identifier = Objects.requireNonNull(identifier, "identifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addResidues(PdbResidue element) {
            this.residues.add(Objects.requireNonNull(element, "residues element"));
            return this;
        }

        public final Builder addResidues(PdbResidue ... elements) {
            for (PdbResidue element : elements) {
                this.residues.add(Objects.requireNonNull(element, "residues element"));
            }
            return this;
        }

        public final Builder residues(Iterable<? extends PdbResidue> elements) {
            this.residues.clear();
            return this.addAllResidues(elements);
        }

        public final Builder addAllResidues(Iterable<? extends PdbResidue> elements) {
            for (PdbResidue pdbResidue : elements) {
                this.residues.add(Objects.requireNonNull(pdbResidue, "residues element"));
            }
            return this;
        }

        public ImmutablePdbChain build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePdbChain(null, this.identifier, ImmutablePdbChain.createUnmodifiableList(true, this.residues));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("identifier");
            }
            return "Cannot build PdbChain, some of required attributes are not set " + attributes;
        }
    }
}

