/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.DefaultPdbResidue;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.pdb.analysis.ResidueInformationProvider;

@ParametersAreNonnullByDefault
@Generated(from="DefaultPdbResidue", generator="Immutables")
@Immutable
public final class ImmutableDefaultPdbResidue
extends DefaultPdbResidue {
    private final PdbResidueIdentifier identifier;
    private final String standardResidueName;
    private final String modifiedResidueName;
    private final List<PdbAtomLine> atoms;
    private volatile transient long lazyInitBitmap;
    private static final long RESIDUE_INFORMATION_PROVIDER_LAZY_INIT_BIT = 1L;
    private transient ResidueInformationProvider residueInformationProvider;
    private static final long ATOM_NAMES_LAZY_INIT_BIT = 2L;
    private transient Set<AtomName> atomNames;
    private static final long HAS_ALL_HEAVY_ATOMS_LAZY_INIT_BIT = 4L;
    private transient boolean hasAllHeavyAtoms;

    private ImmutableDefaultPdbResidue(PdbResidueIdentifier identifier, String standardResidueName, String modifiedResidueName, Iterable<? extends PdbAtomLine> atoms) {
        this.identifier = Objects.requireNonNull(identifier, "identifier");
        this.standardResidueName = Objects.requireNonNull(standardResidueName, "standardResidueName");
        this.modifiedResidueName = Objects.requireNonNull(modifiedResidueName, "modifiedResidueName");
        this.atoms = ImmutableDefaultPdbResidue.createUnmodifiableList(false, ImmutableDefaultPdbResidue.createSafeList(atoms, true, false));
    }

    private ImmutableDefaultPdbResidue(ImmutableDefaultPdbResidue original, PdbResidueIdentifier identifier, String standardResidueName, String modifiedResidueName, List<PdbAtomLine> atoms) {
        this.identifier = identifier;
        this.standardResidueName = standardResidueName;
        this.modifiedResidueName = modifiedResidueName;
        this.atoms = atoms;
    }

    @Override
    public PdbResidueIdentifier identifier() {
        return this.identifier;
    }

    @Override
    public String standardResidueName() {
        return this.standardResidueName;
    }

    @Override
    public String modifiedResidueName() {
        return this.modifiedResidueName;
    }

    @Override
    public List<PdbAtomLine> atoms() {
        return this.atoms;
    }

    public final ImmutableDefaultPdbResidue withIdentifier(PdbResidueIdentifier value) {
        if (this.identifier == value) {
            return this;
        }
        PdbResidueIdentifier newValue = Objects.requireNonNull(value, "identifier");
        return new ImmutableDefaultPdbResidue(this, newValue, this.standardResidueName, this.modifiedResidueName, this.atoms);
    }

    public final ImmutableDefaultPdbResidue withStandardResidueName(String value) {
        String newValue = Objects.requireNonNull(value, "standardResidueName");
        if (this.standardResidueName.equals(newValue)) {
            return this;
        }
        return new ImmutableDefaultPdbResidue(this, this.identifier, newValue, this.modifiedResidueName, this.atoms);
    }

    public final ImmutableDefaultPdbResidue withModifiedResidueName(String value) {
        String newValue = Objects.requireNonNull(value, "modifiedResidueName");
        if (this.modifiedResidueName.equals(newValue)) {
            return this;
        }
        return new ImmutableDefaultPdbResidue(this, this.identifier, this.standardResidueName, newValue, this.atoms);
    }

    public final ImmutableDefaultPdbResidue withAtoms(PdbAtomLine ... elements) {
        List<PdbAtomLine> newValue = ImmutableDefaultPdbResidue.createUnmodifiableList(false, ImmutableDefaultPdbResidue.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDefaultPdbResidue(this, this.identifier, this.standardResidueName, this.modifiedResidueName, newValue);
    }

    public final ImmutableDefaultPdbResidue withAtoms(Iterable<? extends PdbAtomLine> elements) {
        if (this.atoms == elements) {
            return this;
        }
        List<PdbAtomLine> newValue = ImmutableDefaultPdbResidue.createUnmodifiableList(false, ImmutableDefaultPdbResidue.createSafeList(elements, true, false));
        return new ImmutableDefaultPdbResidue(this, this.identifier, this.standardResidueName, this.modifiedResidueName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultPdbResidue && this.equalTo((ImmutableDefaultPdbResidue)another);
    }

    private boolean equalTo(ImmutableDefaultPdbResidue another) {
        return this.identifier.equals(another.identifier) && this.standardResidueName.equals(another.standardResidueName) && this.modifiedResidueName.equals(another.modifiedResidueName) && this.atoms.equals(another.atoms);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier.hashCode();
        h += (h << 5) + this.standardResidueName.hashCode();
        h += (h << 5) + this.modifiedResidueName.hashCode();
        h += (h << 5) + this.atoms.hashCode();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResidueInformationProvider residueInformationProvider() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableDefaultPdbResidue immutableDefaultPdbResidue = this;
            synchronized (immutableDefaultPdbResidue) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.residueInformationProvider = Objects.requireNonNull(super.residueInformationProvider(), "residueInformationProvider");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.residueInformationProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<AtomName> atomNames() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableDefaultPdbResidue immutableDefaultPdbResidue = this;
            synchronized (immutableDefaultPdbResidue) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.atomNames = Objects.requireNonNull(super.atomNames(), "atomNames");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.atomNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAllHeavyAtoms() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableDefaultPdbResidue immutableDefaultPdbResidue = this;
            synchronized (immutableDefaultPdbResidue) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.hasAllHeavyAtoms = super.hasAllHeavyAtoms();
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.hasAllHeavyAtoms;
    }

    public static ImmutableDefaultPdbResidue of(PdbResidueIdentifier identifier, String standardResidueName, String modifiedResidueName, List<PdbAtomLine> atoms) {
        return ImmutableDefaultPdbResidue.of(identifier, standardResidueName, modifiedResidueName, atoms);
    }

    public static ImmutableDefaultPdbResidue of(PdbResidueIdentifier identifier, String standardResidueName, String modifiedResidueName, Iterable<? extends PdbAtomLine> atoms) {
        return new ImmutableDefaultPdbResidue(identifier, standardResidueName, modifiedResidueName, atoms);
    }

    public static ImmutableDefaultPdbResidue copyOf(DefaultPdbResidue instance) {
        if (instance instanceof ImmutableDefaultPdbResidue) {
            return (ImmutableDefaultPdbResidue)instance;
        }
        return ImmutableDefaultPdbResidue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="DefaultPdbResidue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IDENTIFIER = 1L;
        private static final long INIT_BIT_STANDARD_RESIDUE_NAME = 2L;
        private static final long INIT_BIT_MODIFIED_RESIDUE_NAME = 4L;
        private long initBits = 7L;
        @Nullable
        private PdbResidueIdentifier identifier;
        @Nullable
        private String standardResidueName;
        @Nullable
        private String modifiedResidueName;
        private List<PdbAtomLine> atoms = new ArrayList<PdbAtomLine>();

        private Builder() {
        }

        public final Builder from(PdbResidue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DefaultPdbResidue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PdbResidue instance;
            long bits = 0L;
            if (object instanceof PdbResidue) {
                instance = (PdbResidue)object;
                if ((bits & 1L) == 0L) {
                    this.standardResidueName(instance.standardResidueName());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.modifiedResidueName(instance.modifiedResidueName());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllAtoms(instance.atoms());
                    bits |= 8L;
                }
            }
            if (object instanceof DefaultPdbResidue) {
                instance = (DefaultPdbResidue)object;
                if ((bits & 1L) == 0L) {
                    this.standardResidueName(((DefaultPdbResidue)instance).standardResidueName());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(((DefaultPdbResidue)instance).identifier());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.modifiedResidueName(((DefaultPdbResidue)instance).modifiedResidueName());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllAtoms(((DefaultPdbResidue)instance).atoms());
                    bits |= 8L;
                }
            }
        }

        public final Builder identifier(PdbResidueIdentifier identifier) {
            this.identifier = Objects.requireNonNull(identifier, "identifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder standardResidueName(String standardResidueName) {
            this.standardResidueName = Objects.requireNonNull(standardResidueName, "standardResidueName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder modifiedResidueName(String modifiedResidueName) {
            this.modifiedResidueName = Objects.requireNonNull(modifiedResidueName, "modifiedResidueName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addAtoms(PdbAtomLine element) {
            this.atoms.add(Objects.requireNonNull(element, "atoms element"));
            return this;
        }

        public final Builder addAtoms(PdbAtomLine ... elements) {
            for (PdbAtomLine element : elements) {
                this.atoms.add(Objects.requireNonNull(element, "atoms element"));
            }
            return this;
        }

        public final Builder atoms(Iterable<? extends PdbAtomLine> elements) {
            this.atoms.clear();
            return this.addAllAtoms(elements);
        }

        public final Builder addAllAtoms(Iterable<? extends PdbAtomLine> elements) {
            for (PdbAtomLine pdbAtomLine : elements) {
                this.atoms.add(Objects.requireNonNull(pdbAtomLine, "atoms element"));
            }
            return this;
        }

        public ImmutableDefaultPdbResidue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDefaultPdbResidue(null, this.identifier, this.standardResidueName, this.modifiedResidueName, ImmutableDefaultPdbResidue.createUnmodifiableList(true, this.atoms));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("identifier");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("standardResidueName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("modifiedResidueName");
            }
            return "Cannot build DefaultPdbResidue, some of required attributes are not set " + attributes;
        }
    }
}

