/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbExpdtaLine;
import pl.poznan.put.pdb.PdbHeaderLine;
import pl.poznan.put.pdb.PdbModresLine;
import pl.poznan.put.pdb.PdbRemark2Line;
import pl.poznan.put.pdb.PdbRemark465Line;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.DefaultPdbModel;
import pl.poznan.put.pdb.analysis.PdbChain;
import pl.poznan.put.pdb.analysis.PdbModel;
import pl.poznan.put.pdb.analysis.PdbResidue;

@ParametersAreNonnullByDefault
@Generated(from="DefaultPdbModel", generator="Immutables")
@Immutable
public final class ImmutableDefaultPdbModel
extends DefaultPdbModel {
    private final PdbHeaderLine header;
    private final PdbExpdtaLine experimentalData;
    private final PdbRemark2Line resolution;
    private final int modelNumber;
    private final List<PdbAtomLine> atoms;
    private final List<PdbModresLine> modifiedResidues;
    private final List<PdbRemark465Line> missingResidues;
    private final String title;
    private final Set<PdbResidueIdentifier> chainTerminatedAfter;
    private volatile transient long lazyInitBitmap;
    private static final long CHAINS_LAZY_INIT_BIT = 1L;
    private transient List<PdbChain> chains;
    private static final long RESIDUES_LAZY_INIT_BIT = 2L;
    private transient List<PdbResidue> residues;

    private ImmutableDefaultPdbModel(PdbHeaderLine header, PdbExpdtaLine experimentalData, PdbRemark2Line resolution, int modelNumber, Iterable<? extends PdbAtomLine> atoms, Iterable<? extends PdbModresLine> modifiedResidues, Iterable<? extends PdbRemark465Line> missingResidues, String title, Iterable<? extends PdbResidueIdentifier> chainTerminatedAfter) {
        this.header = Objects.requireNonNull(header, "header");
        this.experimentalData = Objects.requireNonNull(experimentalData, "experimentalData");
        this.resolution = Objects.requireNonNull(resolution, "resolution");
        this.modelNumber = modelNumber;
        this.atoms = ImmutableDefaultPdbModel.createUnmodifiableList(false, ImmutableDefaultPdbModel.createSafeList(atoms, true, false));
        this.modifiedResidues = ImmutableDefaultPdbModel.createUnmodifiableList(false, ImmutableDefaultPdbModel.createSafeList(modifiedResidues, true, false));
        this.missingResidues = ImmutableDefaultPdbModel.createUnmodifiableList(false, ImmutableDefaultPdbModel.createSafeList(missingResidues, true, false));
        this.title = Objects.requireNonNull(title, "title");
        this.chainTerminatedAfter = ImmutableDefaultPdbModel.createUnmodifiableSet(ImmutableDefaultPdbModel.createSafeList(chainTerminatedAfter, true, false));
    }

    private ImmutableDefaultPdbModel(ImmutableDefaultPdbModel original, PdbHeaderLine header, PdbExpdtaLine experimentalData, PdbRemark2Line resolution, int modelNumber, List<PdbAtomLine> atoms, List<PdbModresLine> modifiedResidues, List<PdbRemark465Line> missingResidues, String title, Set<PdbResidueIdentifier> chainTerminatedAfter) {
        this.header = header;
        this.experimentalData = experimentalData;
        this.resolution = resolution;
        this.modelNumber = modelNumber;
        this.atoms = atoms;
        this.modifiedResidues = modifiedResidues;
        this.missingResidues = missingResidues;
        this.title = title;
        this.chainTerminatedAfter = chainTerminatedAfter;
    }

    @Override
    public PdbHeaderLine header() {
        return this.header;
    }

    @Override
    public PdbExpdtaLine experimentalData() {
        return this.experimentalData;
    }

    @Override
    public PdbRemark2Line resolution() {
        return this.resolution;
    }

    @Override
    public int modelNumber() {
        return this.modelNumber;
    }

    @Override
    public List<PdbAtomLine> atoms() {
        return this.atoms;
    }

    @Override
    public List<PdbModresLine> modifiedResidues() {
        return this.modifiedResidues;
    }

    @Override
    public List<PdbRemark465Line> missingResidues() {
        return this.missingResidues;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public Set<PdbResidueIdentifier> chainTerminatedAfter() {
        return this.chainTerminatedAfter;
    }

    public final ImmutableDefaultPdbModel withHeader(PdbHeaderLine value) {
        if (this.header == value) {
            return this;
        }
        PdbHeaderLine newValue = Objects.requireNonNull(value, "header");
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(this, newValue, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter));
    }

    public final ImmutableDefaultPdbModel withExperimentalData(PdbExpdtaLine value) {
        if (this.experimentalData == value) {
            return this;
        }
        PdbExpdtaLine newValue = Objects.requireNonNull(value, "experimentalData");
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(this, this.header, newValue, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter));
    }

    public final ImmutableDefaultPdbModel withResolution(PdbRemark2Line value) {
        if (this.resolution == value) {
            return this;
        }
        PdbRemark2Line newValue = Objects.requireNonNull(value, "resolution");
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(this, this.header, this.experimentalData, newValue, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter));
    }

    public final ImmutableDefaultPdbModel withModelNumber(int value) {
        if (this.modelNumber == value) {
            return this;
        }
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(this, this.header, this.experimentalData, this.resolution, value, this.atoms, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter));
    }

    public final ImmutableDefaultPdbModel withAtoms(PdbAtomLine ... elements) {
        List<PdbAtomLine> newValue = ImmutableDefaultPdbModel.createUnmodifiableList(false, ImmutableDefaultPdbModel.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, newValue, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter));
    }

    public final ImmutableDefaultPdbModel withAtoms(Iterable<? extends PdbAtomLine> elements) {
        if (this.atoms == elements) {
            return this;
        }
        List<PdbAtomLine> newValue = ImmutableDefaultPdbModel.createUnmodifiableList(false, ImmutableDefaultPdbModel.createSafeList(elements, true, false));
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, newValue, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter));
    }

    public final ImmutableDefaultPdbModel withModifiedResidues(PdbModresLine ... elements) {
        List<PdbModresLine> newValue = ImmutableDefaultPdbModel.createUnmodifiableList(false, ImmutableDefaultPdbModel.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, newValue, this.missingResidues, this.title, this.chainTerminatedAfter));
    }

    public final ImmutableDefaultPdbModel withModifiedResidues(Iterable<? extends PdbModresLine> elements) {
        if (this.modifiedResidues == elements) {
            return this;
        }
        List<PdbModresLine> newValue = ImmutableDefaultPdbModel.createUnmodifiableList(false, ImmutableDefaultPdbModel.createSafeList(elements, true, false));
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, newValue, this.missingResidues, this.title, this.chainTerminatedAfter));
    }

    public final ImmutableDefaultPdbModel withMissingResidues(PdbRemark465Line ... elements) {
        List<PdbRemark465Line> newValue = ImmutableDefaultPdbModel.createUnmodifiableList(false, ImmutableDefaultPdbModel.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, newValue, this.title, this.chainTerminatedAfter));
    }

    public final ImmutableDefaultPdbModel withMissingResidues(Iterable<? extends PdbRemark465Line> elements) {
        if (this.missingResidues == elements) {
            return this;
        }
        List<PdbRemark465Line> newValue = ImmutableDefaultPdbModel.createUnmodifiableList(false, ImmutableDefaultPdbModel.createSafeList(elements, true, false));
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, newValue, this.title, this.chainTerminatedAfter));
    }

    public final ImmutableDefaultPdbModel withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, newValue, this.chainTerminatedAfter));
    }

    public final ImmutableDefaultPdbModel withChainTerminatedAfter(PdbResidueIdentifier ... elements) {
        Set<PdbResidueIdentifier> newValue = ImmutableDefaultPdbModel.createUnmodifiableSet(ImmutableDefaultPdbModel.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, this.title, newValue));
    }

    public final ImmutableDefaultPdbModel withChainTerminatedAfter(Iterable<? extends PdbResidueIdentifier> elements) {
        if (this.chainTerminatedAfter == elements) {
            return this;
        }
        Set<PdbResidueIdentifier> newValue = ImmutableDefaultPdbModel.createUnmodifiableSet(ImmutableDefaultPdbModel.createSafeList(elements, true, false));
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, this.title, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultPdbModel && this.equalTo((ImmutableDefaultPdbModel)another);
    }

    private boolean equalTo(ImmutableDefaultPdbModel another) {
        return this.atoms.equals(another.atoms);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.atoms.hashCode();
        return h;
    }

    public String toString() {
        return "DefaultPdbModel{atoms=" + this.atoms + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PdbChain> chains() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableDefaultPdbModel immutableDefaultPdbModel = this;
            synchronized (immutableDefaultPdbModel) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.chains = Objects.requireNonNull(super.chains(), "chains");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.chains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PdbResidue> residues() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableDefaultPdbModel immutableDefaultPdbModel = this;
            synchronized (immutableDefaultPdbModel) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.residues = Objects.requireNonNull(super.residues(), "residues");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.residues;
    }

    public static ImmutableDefaultPdbModel of(PdbHeaderLine header, PdbExpdtaLine experimentalData, PdbRemark2Line resolution, int modelNumber, List<PdbAtomLine> atoms, List<PdbModresLine> modifiedResidues, List<PdbRemark465Line> missingResidues, String title, Set<PdbResidueIdentifier> chainTerminatedAfter) {
        return ImmutableDefaultPdbModel.of(header, experimentalData, resolution, modelNumber, atoms, modifiedResidues, missingResidues, title, chainTerminatedAfter);
    }

    public static ImmutableDefaultPdbModel of(PdbHeaderLine header, PdbExpdtaLine experimentalData, PdbRemark2Line resolution, int modelNumber, Iterable<? extends PdbAtomLine> atoms, Iterable<? extends PdbModresLine> modifiedResidues, Iterable<? extends PdbRemark465Line> missingResidues, String title, Iterable<? extends PdbResidueIdentifier> chainTerminatedAfter) {
        return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(header, experimentalData, resolution, modelNumber, atoms, modifiedResidues, missingResidues, title, chainTerminatedAfter));
    }

    private static ImmutableDefaultPdbModel validate(ImmutableDefaultPdbModel instance) {
        instance.check();
        return instance;
    }

    public static ImmutableDefaultPdbModel copyOf(DefaultPdbModel instance) {
        if (instance instanceof ImmutableDefaultPdbModel) {
            return (ImmutableDefaultPdbModel)instance;
        }
        return ImmutableDefaultPdbModel.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableDefaultPdbModel.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="DefaultPdbModel", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HEADER = 1L;
        private static final long INIT_BIT_EXPERIMENTAL_DATA = 2L;
        private static final long INIT_BIT_RESOLUTION = 4L;
        private static final long INIT_BIT_MODEL_NUMBER = 8L;
        private static final long INIT_BIT_TITLE = 16L;
        private long initBits = 31L;
        @Nullable
        private PdbHeaderLine header;
        @Nullable
        private PdbExpdtaLine experimentalData;
        @Nullable
        private PdbRemark2Line resolution;
        private int modelNumber;
        private List<PdbAtomLine> atoms = new ArrayList<PdbAtomLine>();
        private List<PdbModresLine> modifiedResidues = new ArrayList<PdbModresLine>();
        private List<PdbRemark465Line> missingResidues = new ArrayList<PdbRemark465Line>();
        @Nullable
        private String title;
        private List<PdbResidueIdentifier> chainTerminatedAfter = new ArrayList<PdbResidueIdentifier>();

        private Builder() {
        }

        public final Builder from(PdbModel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DefaultPdbModel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PdbModel instance;
            long bits = 0L;
            if (object instanceof PdbModel) {
                instance = (PdbModel)object;
                if ((bits & 1L) == 0L) {
                    this.addAllChainTerminatedAfter(instance.chainTerminatedAfter());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllModifiedResidues(instance.modifiedResidues());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllMissingResidues(instance.missingResidues());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.experimentalData(instance.experimentalData());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.header(instance.header());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.modelNumber(instance.modelNumber());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.title(instance.title());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.resolution(instance.resolution());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.addAllAtoms(instance.atoms());
                    bits |= 0x100L;
                }
            }
            if (object instanceof DefaultPdbModel) {
                instance = (DefaultPdbModel)object;
                if ((bits & 1L) == 0L) {
                    this.addAllChainTerminatedAfter(((DefaultPdbModel)instance).chainTerminatedAfter());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllModifiedResidues(((DefaultPdbModel)instance).modifiedResidues());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllMissingResidues(((DefaultPdbModel)instance).missingResidues());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.experimentalData(((DefaultPdbModel)instance).experimentalData());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.header(((DefaultPdbModel)instance).header());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.modelNumber(((DefaultPdbModel)instance).modelNumber());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.title(((DefaultPdbModel)instance).title());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.resolution(((DefaultPdbModel)instance).resolution());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.addAllAtoms(((DefaultPdbModel)instance).atoms());
                    bits |= 0x100L;
                }
            }
        }

        public final Builder header(PdbHeaderLine header) {
            this.header = Objects.requireNonNull(header, "header");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder experimentalData(PdbExpdtaLine experimentalData) {
            this.experimentalData = Objects.requireNonNull(experimentalData, "experimentalData");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder resolution(PdbRemark2Line resolution) {
            this.resolution = Objects.requireNonNull(resolution, "resolution");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder modelNumber(int modelNumber) {
            this.modelNumber = modelNumber;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder addAtoms(PdbAtomLine element) {
            this.atoms.add(Objects.requireNonNull(element, "atoms element"));
            return this;
        }

        public final Builder addAtoms(PdbAtomLine ... elements) {
            for (PdbAtomLine element : elements) {
                this.atoms.add(Objects.requireNonNull(element, "atoms element"));
            }
            return this;
        }

        public final Builder atoms(Iterable<? extends PdbAtomLine> elements) {
            this.atoms.clear();
            return this.addAllAtoms(elements);
        }

        public final Builder addAllAtoms(Iterable<? extends PdbAtomLine> elements) {
            for (PdbAtomLine pdbAtomLine : elements) {
                this.atoms.add(Objects.requireNonNull(pdbAtomLine, "atoms element"));
            }
            return this;
        }

        public final Builder addModifiedResidues(PdbModresLine element) {
            this.modifiedResidues.add(Objects.requireNonNull(element, "modifiedResidues element"));
            return this;
        }

        public final Builder addModifiedResidues(PdbModresLine ... elements) {
            for (PdbModresLine element : elements) {
                this.modifiedResidues.add(Objects.requireNonNull(element, "modifiedResidues element"));
            }
            return this;
        }

        public final Builder modifiedResidues(Iterable<? extends PdbModresLine> elements) {
            this.modifiedResidues.clear();
            return this.addAllModifiedResidues(elements);
        }

        public final Builder addAllModifiedResidues(Iterable<? extends PdbModresLine> elements) {
            for (PdbModresLine pdbModresLine : elements) {
                this.modifiedResidues.add(Objects.requireNonNull(pdbModresLine, "modifiedResidues element"));
            }
            return this;
        }

        public final Builder addMissingResidues(PdbRemark465Line element) {
            this.missingResidues.add(Objects.requireNonNull(element, "missingResidues element"));
            return this;
        }

        public final Builder addMissingResidues(PdbRemark465Line ... elements) {
            for (PdbRemark465Line element : elements) {
                this.missingResidues.add(Objects.requireNonNull(element, "missingResidues element"));
            }
            return this;
        }

        public final Builder missingResidues(Iterable<? extends PdbRemark465Line> elements) {
            this.missingResidues.clear();
            return this.addAllMissingResidues(elements);
        }

        public final Builder addAllMissingResidues(Iterable<? extends PdbRemark465Line> elements) {
            for (PdbRemark465Line pdbRemark465Line : elements) {
                this.missingResidues.add(Objects.requireNonNull(pdbRemark465Line, "missingResidues element"));
            }
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addChainTerminatedAfter(PdbResidueIdentifier element) {
            this.chainTerminatedAfter.add(Objects.requireNonNull(element, "chainTerminatedAfter element"));
            return this;
        }

        public final Builder addChainTerminatedAfter(PdbResidueIdentifier ... elements) {
            for (PdbResidueIdentifier element : elements) {
                this.chainTerminatedAfter.add(Objects.requireNonNull(element, "chainTerminatedAfter element"));
            }
            return this;
        }

        public final Builder chainTerminatedAfter(Iterable<? extends PdbResidueIdentifier> elements) {
            this.chainTerminatedAfter.clear();
            return this.addAllChainTerminatedAfter(elements);
        }

        public final Builder addAllChainTerminatedAfter(Iterable<? extends PdbResidueIdentifier> elements) {
            for (PdbResidueIdentifier pdbResidueIdentifier : elements) {
                this.chainTerminatedAfter.add(Objects.requireNonNull(pdbResidueIdentifier, "chainTerminatedAfter element"));
            }
            return this;
        }

        public ImmutableDefaultPdbModel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableDefaultPdbModel.validate(new ImmutableDefaultPdbModel(null, this.header, this.experimentalData, this.resolution, this.modelNumber, ImmutableDefaultPdbModel.createUnmodifiableList(true, this.atoms), ImmutableDefaultPdbModel.createUnmodifiableList(true, this.modifiedResidues), ImmutableDefaultPdbModel.createUnmodifiableList(true, this.missingResidues), this.title, ImmutableDefaultPdbModel.createUnmodifiableSet(this.chainTerminatedAfter)));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("header");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("experimentalData");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("resolution");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("modelNumber");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build DefaultPdbModel, some of required attributes are not set " + attributes;
        }
    }
}

