/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbExpdtaLine;
import pl.poznan.put.pdb.PdbHeaderLine;
import pl.poznan.put.pdb.PdbModresLine;
import pl.poznan.put.pdb.PdbRemark2Line;
import pl.poznan.put.pdb.PdbRemark465Line;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.CifModel;
import pl.poznan.put.pdb.analysis.DefaultCifModel;
import pl.poznan.put.pdb.analysis.PdbChain;
import pl.poznan.put.pdb.analysis.PdbModel;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.structure.QuantifiedBasePair;

@ParametersAreNonnullByDefault
@Generated(from="DefaultCifModel", generator="Immutables")
@Immutable
public final class ImmutableDefaultCifModel
extends DefaultCifModel {
    private final PdbHeaderLine header;
    private final PdbExpdtaLine experimentalData;
    private final PdbRemark2Line resolution;
    private final int modelNumber;
    private final List<PdbAtomLine> atoms;
    private final List<PdbModresLine> modifiedResidues;
    private final List<PdbRemark465Line> missingResidues;
    private final String title;
    private final Set<PdbResidueIdentifier> chainTerminatedAfter;
    private final List<QuantifiedBasePair> basePairs;
    private volatile transient long lazyInitBitmap;
    private static final long CHAINS_LAZY_INIT_BIT = 1L;
    private transient List<PdbChain> chains;
    private static final long RESIDUES_LAZY_INIT_BIT = 2L;
    private transient List<PdbResidue> residues;

    private ImmutableDefaultCifModel(PdbHeaderLine header, PdbExpdtaLine experimentalData, PdbRemark2Line resolution, int modelNumber, Iterable<? extends PdbAtomLine> atoms, Iterable<? extends PdbModresLine> modifiedResidues, Iterable<? extends PdbRemark465Line> missingResidues, String title, Iterable<? extends PdbResidueIdentifier> chainTerminatedAfter, Iterable<? extends QuantifiedBasePair> basePairs) {
        this.header = Objects.requireNonNull(header, "header");
        this.experimentalData = Objects.requireNonNull(experimentalData, "experimentalData");
        this.resolution = Objects.requireNonNull(resolution, "resolution");
        this.modelNumber = modelNumber;
        this.atoms = ImmutableDefaultCifModel.createUnmodifiableList(false, ImmutableDefaultCifModel.createSafeList(atoms, true, false));
        this.modifiedResidues = ImmutableDefaultCifModel.createUnmodifiableList(false, ImmutableDefaultCifModel.createSafeList(modifiedResidues, true, false));
        this.missingResidues = ImmutableDefaultCifModel.createUnmodifiableList(false, ImmutableDefaultCifModel.createSafeList(missingResidues, true, false));
        this.title = Objects.requireNonNull(title, "title");
        this.chainTerminatedAfter = ImmutableDefaultCifModel.createUnmodifiableSet(ImmutableDefaultCifModel.createSafeList(chainTerminatedAfter, true, false));
        this.basePairs = ImmutableDefaultCifModel.createUnmodifiableList(false, ImmutableDefaultCifModel.createSafeList(basePairs, true, false));
    }

    private ImmutableDefaultCifModel(ImmutableDefaultCifModel original, PdbHeaderLine header, PdbExpdtaLine experimentalData, PdbRemark2Line resolution, int modelNumber, List<PdbAtomLine> atoms, List<PdbModresLine> modifiedResidues, List<PdbRemark465Line> missingResidues, String title, Set<PdbResidueIdentifier> chainTerminatedAfter, List<QuantifiedBasePair> basePairs) {
        this.header = header;
        this.experimentalData = experimentalData;
        this.resolution = resolution;
        this.modelNumber = modelNumber;
        this.atoms = atoms;
        this.modifiedResidues = modifiedResidues;
        this.missingResidues = missingResidues;
        this.title = title;
        this.chainTerminatedAfter = chainTerminatedAfter;
        this.basePairs = basePairs;
    }

    @Override
    public PdbHeaderLine header() {
        return this.header;
    }

    @Override
    public PdbExpdtaLine experimentalData() {
        return this.experimentalData;
    }

    @Override
    public PdbRemark2Line resolution() {
        return this.resolution;
    }

    @Override
    public int modelNumber() {
        return this.modelNumber;
    }

    @Override
    public List<PdbAtomLine> atoms() {
        return this.atoms;
    }

    @Override
    public List<PdbModresLine> modifiedResidues() {
        return this.modifiedResidues;
    }

    @Override
    public List<PdbRemark465Line> missingResidues() {
        return this.missingResidues;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public Set<PdbResidueIdentifier> chainTerminatedAfter() {
        return this.chainTerminatedAfter;
    }

    @Override
    public List<QuantifiedBasePair> basePairs() {
        return this.basePairs;
    }

    public final ImmutableDefaultCifModel withHeader(PdbHeaderLine value) {
        if (this.header == value) {
            return this;
        }
        PdbHeaderLine newValue = Objects.requireNonNull(value, "header");
        return new ImmutableDefaultCifModel(this, newValue, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter, this.basePairs);
    }

    public final ImmutableDefaultCifModel withExperimentalData(PdbExpdtaLine value) {
        if (this.experimentalData == value) {
            return this;
        }
        PdbExpdtaLine newValue = Objects.requireNonNull(value, "experimentalData");
        return new ImmutableDefaultCifModel(this, this.header, newValue, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter, this.basePairs);
    }

    public final ImmutableDefaultCifModel withResolution(PdbRemark2Line value) {
        if (this.resolution == value) {
            return this;
        }
        PdbRemark2Line newValue = Objects.requireNonNull(value, "resolution");
        return new ImmutableDefaultCifModel(this, this.header, this.experimentalData, newValue, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter, this.basePairs);
    }

    public final ImmutableDefaultCifModel withModelNumber(int value) {
        if (this.modelNumber == value) {
            return this;
        }
        return new ImmutableDefaultCifModel(this, this.header, this.experimentalData, this.resolution, value, this.atoms, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter, this.basePairs);
    }

    public final ImmutableDefaultCifModel withAtoms(PdbAtomLine ... elements) {
        List<PdbAtomLine> newValue = ImmutableDefaultCifModel.createUnmodifiableList(false, ImmutableDefaultCifModel.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDefaultCifModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, newValue, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter, this.basePairs);
    }

    public final ImmutableDefaultCifModel withAtoms(Iterable<? extends PdbAtomLine> elements) {
        if (this.atoms == elements) {
            return this;
        }
        List<PdbAtomLine> newValue = ImmutableDefaultCifModel.createUnmodifiableList(false, ImmutableDefaultCifModel.createSafeList(elements, true, false));
        return new ImmutableDefaultCifModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, newValue, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter, this.basePairs);
    }

    public final ImmutableDefaultCifModel withModifiedResidues(PdbModresLine ... elements) {
        List<PdbModresLine> newValue = ImmutableDefaultCifModel.createUnmodifiableList(false, ImmutableDefaultCifModel.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDefaultCifModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, newValue, this.missingResidues, this.title, this.chainTerminatedAfter, this.basePairs);
    }

    public final ImmutableDefaultCifModel withModifiedResidues(Iterable<? extends PdbModresLine> elements) {
        if (this.modifiedResidues == elements) {
            return this;
        }
        List<PdbModresLine> newValue = ImmutableDefaultCifModel.createUnmodifiableList(false, ImmutableDefaultCifModel.createSafeList(elements, true, false));
        return new ImmutableDefaultCifModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, newValue, this.missingResidues, this.title, this.chainTerminatedAfter, this.basePairs);
    }

    public final ImmutableDefaultCifModel withMissingResidues(PdbRemark465Line ... elements) {
        List<PdbRemark465Line> newValue = ImmutableDefaultCifModel.createUnmodifiableList(false, ImmutableDefaultCifModel.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDefaultCifModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, newValue, this.title, this.chainTerminatedAfter, this.basePairs);
    }

    public final ImmutableDefaultCifModel withMissingResidues(Iterable<? extends PdbRemark465Line> elements) {
        if (this.missingResidues == elements) {
            return this;
        }
        List<PdbRemark465Line> newValue = ImmutableDefaultCifModel.createUnmodifiableList(false, ImmutableDefaultCifModel.createSafeList(elements, true, false));
        return new ImmutableDefaultCifModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, newValue, this.title, this.chainTerminatedAfter, this.basePairs);
    }

    public final ImmutableDefaultCifModel withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableDefaultCifModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, newValue, this.chainTerminatedAfter, this.basePairs);
    }

    public final ImmutableDefaultCifModel withChainTerminatedAfter(PdbResidueIdentifier ... elements) {
        Set<PdbResidueIdentifier> newValue = ImmutableDefaultCifModel.createUnmodifiableSet(ImmutableDefaultCifModel.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDefaultCifModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, this.title, newValue, this.basePairs);
    }

    public final ImmutableDefaultCifModel withChainTerminatedAfter(Iterable<? extends PdbResidueIdentifier> elements) {
        if (this.chainTerminatedAfter == elements) {
            return this;
        }
        Set<PdbResidueIdentifier> newValue = ImmutableDefaultCifModel.createUnmodifiableSet(ImmutableDefaultCifModel.createSafeList(elements, true, false));
        return new ImmutableDefaultCifModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, this.title, newValue, this.basePairs);
    }

    public final ImmutableDefaultCifModel withBasePairs(QuantifiedBasePair ... elements) {
        List<QuantifiedBasePair> newValue = ImmutableDefaultCifModel.createUnmodifiableList(false, ImmutableDefaultCifModel.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDefaultCifModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter, newValue);
    }

    public final ImmutableDefaultCifModel withBasePairs(Iterable<? extends QuantifiedBasePair> elements) {
        if (this.basePairs == elements) {
            return this;
        }
        List<QuantifiedBasePair> newValue = ImmutableDefaultCifModel.createUnmodifiableList(false, ImmutableDefaultCifModel.createSafeList(elements, true, false));
        return new ImmutableDefaultCifModel(this, this.header, this.experimentalData, this.resolution, this.modelNumber, this.atoms, this.modifiedResidues, this.missingResidues, this.title, this.chainTerminatedAfter, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultCifModel && this.equalTo((ImmutableDefaultCifModel)another);
    }

    private boolean equalTo(ImmutableDefaultCifModel another) {
        return this.atoms.equals(another.atoms);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.atoms.hashCode();
        return h;
    }

    public String toString() {
        return "DefaultCifModel{atoms=" + this.atoms + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PdbChain> chains() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableDefaultCifModel immutableDefaultCifModel = this;
            synchronized (immutableDefaultCifModel) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.chains = Objects.requireNonNull(super.chains(), "chains");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.chains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PdbResidue> residues() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableDefaultCifModel immutableDefaultCifModel = this;
            synchronized (immutableDefaultCifModel) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.residues = Objects.requireNonNull(super.residues(), "residues");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.residues;
    }

    public static ImmutableDefaultCifModel of(PdbHeaderLine header, PdbExpdtaLine experimentalData, PdbRemark2Line resolution, int modelNumber, List<PdbAtomLine> atoms, List<PdbModresLine> modifiedResidues, List<PdbRemark465Line> missingResidues, String title, Set<PdbResidueIdentifier> chainTerminatedAfter, List<QuantifiedBasePair> basePairs) {
        return ImmutableDefaultCifModel.of(header, experimentalData, resolution, modelNumber, atoms, modifiedResidues, missingResidues, title, chainTerminatedAfter, basePairs);
    }

    public static ImmutableDefaultCifModel of(PdbHeaderLine header, PdbExpdtaLine experimentalData, PdbRemark2Line resolution, int modelNumber, Iterable<? extends PdbAtomLine> atoms, Iterable<? extends PdbModresLine> modifiedResidues, Iterable<? extends PdbRemark465Line> missingResidues, String title, Iterable<? extends PdbResidueIdentifier> chainTerminatedAfter, Iterable<? extends QuantifiedBasePair> basePairs) {
        return new ImmutableDefaultCifModel(header, experimentalData, resolution, modelNumber, atoms, modifiedResidues, missingResidues, title, chainTerminatedAfter, basePairs);
    }

    public static ImmutableDefaultCifModel copyOf(DefaultCifModel instance) {
        if (instance instanceof ImmutableDefaultCifModel) {
            return (ImmutableDefaultCifModel)instance;
        }
        return ImmutableDefaultCifModel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="DefaultCifModel", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HEADER = 1L;
        private static final long INIT_BIT_EXPERIMENTAL_DATA = 2L;
        private static final long INIT_BIT_RESOLUTION = 4L;
        private static final long INIT_BIT_MODEL_NUMBER = 8L;
        private static final long INIT_BIT_TITLE = 16L;
        private long initBits = 31L;
        @Nullable
        private PdbHeaderLine header;
        @Nullable
        private PdbExpdtaLine experimentalData;
        @Nullable
        private PdbRemark2Line resolution;
        private int modelNumber;
        private List<PdbAtomLine> atoms = new ArrayList<PdbAtomLine>();
        private List<PdbModresLine> modifiedResidues = new ArrayList<PdbModresLine>();
        private List<PdbRemark465Line> missingResidues = new ArrayList<PdbRemark465Line>();
        @Nullable
        private String title;
        private List<PdbResidueIdentifier> chainTerminatedAfter = new ArrayList<PdbResidueIdentifier>();
        private List<QuantifiedBasePair> basePairs = new ArrayList<QuantifiedBasePair>();

        private Builder() {
        }

        public final Builder from(PdbModel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CifModel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DefaultCifModel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PdbModel instance;
            long bits = 0L;
            if (object instanceof PdbModel) {
                instance = (PdbModel)object;
                if ((bits & 1L) == 0L) {
                    this.addAllChainTerminatedAfter(instance.chainTerminatedAfter());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllModifiedResidues(instance.modifiedResidues());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllMissingResidues(instance.missingResidues());
                    bits |= 4L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.experimentalData(instance.experimentalData());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.header(instance.header());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.modelNumber(instance.modelNumber());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.title(instance.title());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.resolution(instance.resolution());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.addAllAtoms(instance.atoms());
                    bits |= 0x200L;
                }
            }
            if (object instanceof CifModel) {
                instance = (CifModel)object;
                if ((bits & 8L) == 0L) {
                    this.addAllBasePairs(instance.basePairs());
                    bits |= 8L;
                }
            }
            if (object instanceof DefaultCifModel) {
                instance = (DefaultCifModel)object;
                if ((bits & 1L) == 0L) {
                    this.addAllChainTerminatedAfter(((DefaultCifModel)instance).chainTerminatedAfter());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllModifiedResidues(((DefaultCifModel)instance).modifiedResidues());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllMissingResidues(((DefaultCifModel)instance).missingResidues());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllBasePairs(((DefaultCifModel)instance).basePairs());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.experimentalData(((DefaultCifModel)instance).experimentalData());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.header(((DefaultCifModel)instance).header());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.modelNumber(((DefaultCifModel)instance).modelNumber());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.title(((DefaultCifModel)instance).title());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.resolution(((DefaultCifModel)instance).resolution());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.addAllAtoms(((DefaultCifModel)instance).atoms());
                    bits |= 0x200L;
                }
            }
        }

        public final Builder header(PdbHeaderLine header) {
            this.header = Objects.requireNonNull(header, "header");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder experimentalData(PdbExpdtaLine experimentalData) {
            this.experimentalData = Objects.requireNonNull(experimentalData, "experimentalData");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder resolution(PdbRemark2Line resolution) {
            this.resolution = Objects.requireNonNull(resolution, "resolution");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder modelNumber(int modelNumber) {
            this.modelNumber = modelNumber;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder addAtoms(PdbAtomLine element) {
            this.atoms.add(Objects.requireNonNull(element, "atoms element"));
            return this;
        }

        public final Builder addAtoms(PdbAtomLine ... elements) {
            for (PdbAtomLine element : elements) {
                this.atoms.add(Objects.requireNonNull(element, "atoms element"));
            }
            return this;
        }

        public final Builder atoms(Iterable<? extends PdbAtomLine> elements) {
            this.atoms.clear();
            return this.addAllAtoms(elements);
        }

        public final Builder addAllAtoms(Iterable<? extends PdbAtomLine> elements) {
            for (PdbAtomLine pdbAtomLine : elements) {
                this.atoms.add(Objects.requireNonNull(pdbAtomLine, "atoms element"));
            }
            return this;
        }

        public final Builder addModifiedResidues(PdbModresLine element) {
            this.modifiedResidues.add(Objects.requireNonNull(element, "modifiedResidues element"));
            return this;
        }

        public final Builder addModifiedResidues(PdbModresLine ... elements) {
            for (PdbModresLine element : elements) {
                this.modifiedResidues.add(Objects.requireNonNull(element, "modifiedResidues element"));
            }
            return this;
        }

        public final Builder modifiedResidues(Iterable<? extends PdbModresLine> elements) {
            this.modifiedResidues.clear();
            return this.addAllModifiedResidues(elements);
        }

        public final Builder addAllModifiedResidues(Iterable<? extends PdbModresLine> elements) {
            for (PdbModresLine pdbModresLine : elements) {
                this.modifiedResidues.add(Objects.requireNonNull(pdbModresLine, "modifiedResidues element"));
            }
            return this;
        }

        public final Builder addMissingResidues(PdbRemark465Line element) {
            this.missingResidues.add(Objects.requireNonNull(element, "missingResidues element"));
            return this;
        }

        public final Builder addMissingResidues(PdbRemark465Line ... elements) {
            for (PdbRemark465Line element : elements) {
                this.missingResidues.add(Objects.requireNonNull(element, "missingResidues element"));
            }
            return this;
        }

        public final Builder missingResidues(Iterable<? extends PdbRemark465Line> elements) {
            this.missingResidues.clear();
            return this.addAllMissingResidues(elements);
        }

        public final Builder addAllMissingResidues(Iterable<? extends PdbRemark465Line> elements) {
            for (PdbRemark465Line pdbRemark465Line : elements) {
                this.missingResidues.add(Objects.requireNonNull(pdbRemark465Line, "missingResidues element"));
            }
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addChainTerminatedAfter(PdbResidueIdentifier element) {
            this.chainTerminatedAfter.add(Objects.requireNonNull(element, "chainTerminatedAfter element"));
            return this;
        }

        public final Builder addChainTerminatedAfter(PdbResidueIdentifier ... elements) {
            for (PdbResidueIdentifier element : elements) {
                this.chainTerminatedAfter.add(Objects.requireNonNull(element, "chainTerminatedAfter element"));
            }
            return this;
        }

        public final Builder chainTerminatedAfter(Iterable<? extends PdbResidueIdentifier> elements) {
            this.chainTerminatedAfter.clear();
            return this.addAllChainTerminatedAfter(elements);
        }

        public final Builder addAllChainTerminatedAfter(Iterable<? extends PdbResidueIdentifier> elements) {
            for (PdbResidueIdentifier pdbResidueIdentifier : elements) {
                this.chainTerminatedAfter.add(Objects.requireNonNull(pdbResidueIdentifier, "chainTerminatedAfter element"));
            }
            return this;
        }

        public final Builder addBasePairs(QuantifiedBasePair element) {
            this.basePairs.add(Objects.requireNonNull(element, "basePairs element"));
            return this;
        }

        public final Builder addBasePairs(QuantifiedBasePair ... elements) {
            for (QuantifiedBasePair element : elements) {
                this.basePairs.add(Objects.requireNonNull(element, "basePairs element"));
            }
            return this;
        }

        public final Builder basePairs(Iterable<? extends QuantifiedBasePair> elements) {
            this.basePairs.clear();
            return this.addAllBasePairs(elements);
        }

        public final Builder addAllBasePairs(Iterable<? extends QuantifiedBasePair> elements) {
            for (QuantifiedBasePair quantifiedBasePair : elements) {
                this.basePairs.add(Objects.requireNonNull(quantifiedBasePair, "basePairs element"));
            }
            return this;
        }

        public ImmutableDefaultCifModel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDefaultCifModel(null, this.header, this.experimentalData, this.resolution, this.modelNumber, ImmutableDefaultCifModel.createUnmodifiableList(true, this.atoms), ImmutableDefaultCifModel.createUnmodifiableList(true, this.modifiedResidues), ImmutableDefaultCifModel.createUnmodifiableList(true, this.missingResidues), this.title, ImmutableDefaultCifModel.createUnmodifiableSet(this.chainTerminatedAfter), ImmutableDefaultCifModel.createUnmodifiableList(true, this.basePairs));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("header");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("experimentalData");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("resolution");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("modelNumber");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build DefaultCifModel, some of required attributes are not set " + attributes;
        }
    }
}

