/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.collections4.BidiMap;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.analysis.CifContainer;

@ParametersAreNonnullByDefault
@Generated(from="CifContainer", generator="Immutables")
@Immutable
public final class ImmutableCifContainer
extends CifContainer {
    private final Map<File, BidiMap<String, String>> fileChainMap;
    private final File cifFile;

    private ImmutableCifContainer(File cifFile, Map<? extends File, ? extends BidiMap<String, String>> fileChainMap) {
        this.cifFile = Objects.requireNonNull(cifFile, "cifFile");
        this.fileChainMap = ImmutableCifContainer.createUnmodifiableMap(true, false, fileChainMap);
    }

    private ImmutableCifContainer(ImmutableCifContainer original, Map<File, BidiMap<String, String>> fileChainMap, File cifFile) {
        this.fileChainMap = fileChainMap;
        this.cifFile = cifFile;
    }

    @Override
    public Map<File, BidiMap<String, String>> fileChainMap() {
        return this.fileChainMap;
    }

    @Override
    public File cifFile() {
        return this.cifFile;
    }

    public final ImmutableCifContainer withFileChainMap(Map<? extends File, ? extends BidiMap<String, String>> entries) {
        if (this.fileChainMap == entries) {
            return this;
        }
        Map<? extends File, ? extends BidiMap<String, String>> newValue = ImmutableCifContainer.createUnmodifiableMap(true, false, entries);
        return new ImmutableCifContainer(this, newValue, this.cifFile);
    }

    public final ImmutableCifContainer withCifFile(File value) {
        if (this.cifFile == value) {
            return this;
        }
        File newValue = Objects.requireNonNull(value, "cifFile");
        return new ImmutableCifContainer(this, this.fileChainMap, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCifContainer && this.equalTo((ImmutableCifContainer)another);
    }

    private boolean equalTo(ImmutableCifContainer another) {
        return this.fileChainMap.equals(another.fileChainMap) && this.cifFile.equals(another.cifFile);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.fileChainMap.hashCode();
        h += (h << 5) + this.cifFile.hashCode();
        return h;
    }

    public String toString() {
        return "CifContainer{fileChainMap=" + this.fileChainMap + ", cifFile=" + this.cifFile + "}";
    }

    public static ImmutableCifContainer of(File cifFile, Map<? extends File, ? extends BidiMap<String, String>> fileChainMap) {
        return new ImmutableCifContainer(cifFile, fileChainMap);
    }

    public static ImmutableCifContainer copyOf(CifContainer instance) {
        if (instance instanceof ImmutableCifContainer) {
            return (ImmutableCifContainer)instance;
        }
        return ImmutableCifContainer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="CifContainer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CIF_FILE = 1L;
        private long initBits = 1L;
        private Map<File, BidiMap<String, String>> fileChainMap = new LinkedHashMap<File, BidiMap<String, String>>();
        @Nullable
        private File cifFile;

        private Builder() {
        }

        public final Builder from(CifContainer instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllFileChainMap(instance.fileChainMap());
            this.cifFile(instance.cifFile());
            return this;
        }

        public final Builder putFileChainMap(File key, BidiMap<String, String> value) {
            this.fileChainMap.put(Objects.requireNonNull(key, "fileChainMap key"), Objects.requireNonNull(value, "fileChainMap value"));
            return this;
        }

        public final Builder putFileChainMap(Map.Entry<? extends File, ? extends BidiMap<String, String>> entry) {
            File k = entry.getKey();
            BidiMap<String, String> v = entry.getValue();
            this.fileChainMap.put(Objects.requireNonNull(k, "fileChainMap key"), Objects.requireNonNull(v, "fileChainMap value"));
            return this;
        }

        public final Builder fileChainMap(Map<? extends File, ? extends BidiMap<String, String>> entries) {
            this.fileChainMap.clear();
            return this.putAllFileChainMap(entries);
        }

        public final Builder putAllFileChainMap(Map<? extends File, ? extends BidiMap<String, String>> entries) {
            for (Map.Entry<? extends File, ? extends BidiMap<String, String>> e : entries.entrySet()) {
                File k = e.getKey();
                BidiMap<String, String> v = e.getValue();
                this.fileChainMap.put(Objects.requireNonNull(k, "fileChainMap key"), Objects.requireNonNull(v, "fileChainMap value"));
            }
            return this;
        }

        public final Builder cifFile(File cifFile) {
            this.cifFile = Objects.requireNonNull(cifFile, "cifFile");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCifContainer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCifContainer(null, ImmutableCifContainer.createUnmodifiableMap(false, false, this.fileChainMap), this.cifFile);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("cifFile");
            }
            return "Cannot build CifContainer, some of required attributes are not set " + attributes;
        }
    }
}

