/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.ResidueNumber;
import org.immutables.value.Value;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.pdb.ImmutablePdbResidueIdentifier;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.ImmutableDefaultPdbResidue;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.pdb.analysis.ResidueInformationProvider;

@Value.Immutable
public abstract class DefaultPdbResidue
implements PdbResidue {
    public static PdbResidue fromBioJavaGroup(Group group) {
        ResidueNumber residueNumberObject = group.getResidueNumber();
        String chainIdentifier = residueNumberObject.getChainName();
        int residueNumber = residueNumberObject.getSeqNum();
        String insertionCode = residueNumberObject.getInsCode() == null ? " " : Character.toString(residueNumberObject.getInsCode().charValue());
        ImmutablePdbResidueIdentifier residueIdentifier = ImmutablePdbResidueIdentifier.of(chainIdentifier, residueNumber, insertionCode);
        List<PdbAtomLine> atoms = group.getAtoms().stream().map(PdbAtomLine::fromBioJavaAtom).collect(Collectors.toList());
        String residueName = group.getPDBName();
        return ImmutableDefaultPdbResidue.of((PdbResidueIdentifier)residueIdentifier, residueName, residueName, atoms);
    }

    @Override
    @Value.Parameter(order=1)
    public abstract PdbResidueIdentifier identifier();

    @Override
    @Value.Parameter(order=2)
    public abstract String standardResidueName();

    @Override
    @Value.Parameter(order=3)
    public abstract String modifiedResidueName();

    @Override
    @Value.Parameter(order=4)
    public abstract List<PdbAtomLine> atoms();

    @Override
    @Value.Lazy
    public ResidueInformationProvider residueInformationProvider() {
        return PdbResidue.super.residueInformationProvider();
    }

    @Override
    @Value.Lazy
    public Set<AtomName> atomNames() {
        return PdbResidue.super.atomNames();
    }

    @Override
    @Value.Lazy
    public boolean hasAllHeavyAtoms() {
        return PdbResidue.super.hasAllHeavyAtoms();
    }

    public final String toString() {
        String chainIdentifier = this.identifier().chainIdentifier();
        int residueNumber = this.identifier().residueNumber();
        String insertionCode = this.identifier().insertionCode();
        return chainIdentifier + '.' + this.modifiedResidueName() + residueNumber + (Objects.equals(" ", insertionCode) ? "" : insertionCode);
    }
}

