/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.poznan.put.pdb.ImmutablePdbAtomLine;
import pl.poznan.put.pdb.ImmutablePdbRemark465Line;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbModresLine;
import pl.poznan.put.pdb.PdbRemark465Line;
import pl.poznan.put.pdb.analysis.CifContainer;
import pl.poznan.put.pdb.analysis.CifModel;
import pl.poznan.put.pdb.analysis.CifParser;
import pl.poznan.put.pdb.analysis.DefaultCifModel;
import pl.poznan.put.pdb.analysis.ImmutableCifContainer;
import pl.poznan.put.pdb.analysis.ModelContainer;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.PdbChain;
import pl.poznan.put.pdb.analysis.PdbModel;
import pl.poznan.put.pdb.analysis.PdbResidue;
import pl.poznan.put.pdb.analysis.SingleTypedResidueCollection;
import pl.poznan.put.structure.BasePair;
import pl.poznan.put.structure.QuantifiedBasePair;

public final class CifConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CifConverter.class);
    private static final int MAX_RESIDUE_NUMBER = 9999;
    private static final int MAX_ATOM_SERIAL_NUMBER = 99999;
    private static final List<String> PRINTABLE_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".chars().mapToObj(i -> Character.valueOf((char)i)).map(String::valueOf).collect(Collectors.toList());

    private CifConverter() {
    }

    public static ModelContainer convert(File cifFile) throws IOException {
        String cifContents = FileUtils.readFileToString((File)cifFile, (Charset)Charset.defaultCharset());
        List<CifModel> models = CifParser.parse(cifContents);
        return CifConverter.convert(cifFile, models);
    }

    public static ModelContainer convert(DefaultCifModel model) throws IOException {
        File cifFile = File.createTempFile("cif2pdb", ".cif");
        FileUtils.write((File)cifFile, (CharSequence)model.toCif(), (Charset)Charset.defaultCharset());
        if (!CifConverter.isConversionPossible(model)) {
            return CifContainer.emptyInstance(cifFile);
        }
        List<Set<String>> chainGroups = CifConverter.groupContactingChains(model);
        chainGroups = CifConverter.packGroups(chainGroups);
        HashMap<File, TreeBidiMap> fileChainMap = new HashMap<File, TreeBidiMap>();
        for (Set<String> chainGroup : chainGroups) {
            File pdbFile = File.createTempFile("cif2pdb", ".pdb");
            TreeBidiMap chainMap = new TreeBidiMap();
            fileChainMap.put(pdbFile, chainMap);
            StringBuilder pdbBuilder = new StringBuilder();
            CifConverter.writeHeader(model, (BidiMap<String, String>)chainMap, pdbBuilder);
            CifConverter.writeModel(model, chainGroup, (BidiMap<String, String>)chainMap, pdbBuilder);
            String pdbData = pdbBuilder.toString();
            FileUtils.write((File)pdbFile, (CharSequence)pdbData, (Charset)Charset.defaultCharset());
        }
        return ImmutableCifContainer.of(cifFile, fileChainMap);
    }

    private static ModelContainer convert(File cifFile, List<CifModel> models) throws IOException {
        ArrayList<CifModel> rnaModels = new ArrayList<CifModel>();
        for (PdbModel model : models) {
            if (!model.containsAny(MoleculeType.RNA)) continue;
            CifModel rnaModel = (CifModel)model.filteredNewInstance(MoleculeType.RNA);
            rnaModels.add(rnaModel);
        }
        if (rnaModels.isEmpty()) {
            LOGGER.info("Neither model contain any RNA chain");
            return CifContainer.emptyInstance(cifFile);
        }
        for (PdbModel model : rnaModels) {
            if (CifConverter.isConversionPossible(model)) continue;
            return CifContainer.emptyInstance(cifFile);
        }
        CifModel firstModel = (CifModel)rnaModels.get(0);
        List<Set<String>> chainGroups = CifConverter.groupContactingChains(firstModel);
        chainGroups = CifConverter.packGroups(chainGroups);
        HashMap<File, TreeBidiMap> fileChainMap = new HashMap<File, TreeBidiMap>();
        for (Set<String> chainGroup : chainGroups) {
            File pdbFile = File.createTempFile("cif2pdb", ".pdb");
            TreeBidiMap chainMap = new TreeBidiMap();
            fileChainMap.put(pdbFile, chainMap);
            StringBuilder pdbBuilder = new StringBuilder();
            CifConverter.writeHeader(firstModel, (BidiMap<String, String>)chainMap, pdbBuilder);
            for (PdbModel pdbModel : rnaModels) {
                CifConverter.writeModel(pdbModel, chainGroup, (BidiMap<String, String>)chainMap, pdbBuilder);
            }
            String pdbData = pdbBuilder.toString();
            FileUtils.write((File)pdbFile, (CharSequence)pdbData, (Charset)Charset.defaultCharset());
        }
        return ImmutableCifContainer.of(cifFile, fileChainMap);
    }

    private static boolean isConversionPossible(PdbModel model) {
        for (PdbChain chain : model.chains()) {
            for (PdbResidue residue : chain.residues()) {
                if (residue.residueNumber() <= 9999) continue;
                LOGGER.error("Cannot continue. Chain {} has residue of index > 9999", (Object)chain.identifier());
                return false;
            }
        }
        return true;
    }

    private static List<Set<String>> groupContactingChains(CifModel model) {
        List<Set<String>> chainGroups = CifConverter.initializeChainGroups(model);
        Map<String, Set<String>> chainContacts = CifConverter.initializeChainContactMap(model);
        int i = 0;
        while (chainGroups.size() > 1 && i < chainGroups.size()) {
            Set<String> groupL = chainGroups.get(i);
            int toMerge = -1;
            for (int j = i + 1; toMerge == -1 && j < chainGroups.size(); ++j) {
                Set<String> groupR = chainGroups.get(j);
                if (!groupL.stream().filter(chainContacts::containsKey).map(chainContacts::get).anyMatch(contactsL -> CollectionUtils.containsAny((Collection)contactsL, (Collection)groupR))) continue;
                toMerge = j;
            }
            if (toMerge == -1) {
                ++i;
                continue;
            }
            Set<String> groupToMerge = chainGroups.get(toMerge);
            groupL.addAll(groupToMerge);
            chainGroups.remove(toMerge);
            i = 0;
        }
        return chainGroups;
    }

    private static List<Set<String>> initializeChainGroups(PdbModel model) {
        return model.chains().stream().map(chain -> new HashSet<String>(Collections.singleton(chain.identifier()))).collect(Collectors.toList());
    }

    private static Map<String, Set<String>> initializeChainContactMap(CifModel model) {
        HashMap<String, Set<String>> chainContacts = new HashMap<String, Set<String>>();
        for (QuantifiedBasePair quantifiedBasePair : model.basePairs()) {
            BasePair basePair = quantifiedBasePair.basePair();
            String left = basePair.left().chainIdentifier();
            String right = basePair.right().chainIdentifier();
            if (!chainContacts.containsKey(left)) {
                chainContacts.put(left, new HashSet());
            }
            ((Set)chainContacts.get(left)).add(right);
            if (!chainContacts.containsKey(right)) {
                chainContacts.put(right, new HashSet());
            }
            ((Set)chainContacts.get(right)).add(left);
        }
        return chainContacts;
    }

    private static List<Set<String>> packGroups(List<Set<String>> chainGroups) {
        chainGroups.sort((t, t1) -> -Integer.compare(t.size(), t1.size()));
        ArrayList<Set<String>> packed = new ArrayList<Set<String>>();
        for (Set<String> group : chainGroups) {
            boolean flag = true;
            for (Set set : packed) {
                if (set.size() + group.size() > PRINTABLE_CHARS.size()) continue;
                set.addAll(group);
                flag = false;
                break;
            }
            if (!flag) continue;
            HashSet<String> bin = new HashSet<String>(group);
            packed.add(bin);
        }
        return packed;
    }

    private static void writeHeader(PdbModel firstModel, BidiMap<String, String> chainMap, StringBuilder pdbBuilder) {
        pdbBuilder.append(firstModel.header()).append(System.lineSeparator());
        if (!firstModel.experimentalData().experimentalTechniques().isEmpty()) {
            pdbBuilder.append(firstModel.experimentalData()).append(System.lineSeparator());
        }
        pdbBuilder.append("REMARK   2                                                                      ").append(System.lineSeparator());
        pdbBuilder.append(firstModel.resolution()).append(System.lineSeparator());
        List<PdbRemark465Line> missingResidues = firstModel.missingResidues();
        if (!missingResidues.isEmpty()) {
            pdbBuilder.append("REMARK 465                                                                      \nREMARK 465 MISSING RESIDUES                                                     \nREMARK 465 THE FOLLOWING RESIDUES WERE NOT LOCATED IN THE                       \nREMARK 465 EXPERIMENT. (M=MODEL NUMBER; RES=RESIDUE NAME; C=CHAIN               \nREMARK 465 IDENTIFIER; SSSEQ=SEQUENCE NUMBER; I=INSERTION CODE.)                \nREMARK 465                                                                      \nREMARK 465   M RES C SSSEQI                                                     ").append(System.lineSeparator());
            for (PdbRemark465Line missingResidue : missingResidues) {
                String chainIdentifier = missingResidue.chainIdentifier();
                MoleculeType moleculeType = CifConverter.getChainType(firstModel, chainIdentifier);
                if (moleculeType != MoleculeType.RNA) continue;
                chainIdentifier = CifConverter.mapChain(chainMap, chainIdentifier);
                missingResidue = ImmutablePdbRemark465Line.copyOf(missingResidue).withChainIdentifier(chainIdentifier);
                pdbBuilder.append(missingResidue).append(System.lineSeparator());
            }
        }
        for (PdbModresLine modifiedResidue : firstModel.modifiedResidues()) {
            pdbBuilder.append(modifiedResidue).append(System.lineSeparator());
        }
    }

    private static MoleculeType getChainType(PdbModel firstModel, String chainIdentifier) {
        return firstModel.chains().stream().filter(chain -> Objects.equals(chain.identifier(), chainIdentifier)).findFirst().map(SingleTypedResidueCollection::moleculeType).orElse(MoleculeType.UNKNOWN);
    }

    private static String mapChain(BidiMap<String, String> chainMap, String chainIdentifier) {
        if (!chainMap.containsKey((Object)chainIdentifier)) {
            chainMap.put((Object)chainIdentifier, (Object)PRINTABLE_CHARS.get(chainMap.size()));
        }
        return (String)chainMap.get((Object)chainIdentifier);
    }

    private static void writeModel(PdbModel rnaModel, Collection<String> allowedChains, BidiMap<String, String> chainMap, StringBuilder pdbBuilder) {
        pdbBuilder.append("MODEL ").append(rnaModel.modelNumber()).append(System.lineSeparator());
        int serialNumber = 1;
        for (PdbChain chain : rnaModel.chains()) {
            if (!allowedChains.contains(chain.identifier())) continue;
            for (PdbResidue residue : chain.residues()) {
                for (PdbAtomLine atom : residue.atoms()) {
                    String chainIdentifier = CifConverter.mapChain(chainMap, atom.chainIdentifier());
                    ImmutablePdbAtomLine atomLine = ((ImmutablePdbAtomLine)atom).withSerialNumber(serialNumber).withChainIdentifier(chainIdentifier);
                    serialNumber = serialNumber < 99999 ? serialNumber + 1 : 1;
                    pdbBuilder.append(atomLine).append(System.lineSeparator());
                }
            }
        }
        pdbBuilder.append("ENDMDL");
        pdbBuilder.append(System.lineSeparator());
    }
}

