/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.io.FileUtils;
import org.immutables.value.Value;
import pl.poznan.put.pdb.analysis.ImmutableCifContainer;
import pl.poznan.put.pdb.analysis.ModelContainer;

@Value.Immutable
public abstract class CifContainer
implements ModelContainer {
    public static ModelContainer emptyInstance(File cifFile) {
        return ImmutableCifContainer.of(cifFile, Collections.emptyMap());
    }

    @Value.Parameter(order=2)
    public abstract Map<File, BidiMap<String, String>> fileChainMap();

    @Value.Parameter(order=1)
    public abstract File cifFile();

    @Override
    public final List<File> pdbFiles() {
        return new ArrayList<File>(this.fileChainMap().keySet());
    }

    @Override
    public final String originalCifChainName(File pdbFile, String pdbChain) {
        if (!this.fileChainMap().containsKey(pdbFile)) {
            throw new IllegalArgumentException("Failed to find PDBx/mmCIF chain name, missing data for file: " + pdbFile);
        }
        return (String)this.fileChainMap().get(pdbFile).getKey((Object)pdbChain);
    }

    @Override
    public final String convertedPdbChainName(File pdbFile, String cifChain) {
        if (!this.fileChainMap().containsKey(pdbFile)) {
            throw new IllegalArgumentException("Failed to find PDB chain name, missing data for file: " + pdbFile);
        }
        return (String)this.fileChainMap().get(pdbFile).get((Object)cifChain);
    }

    @Override
    public final void close() {
        FileUtils.deleteQuietly((File)this.cifFile());
        for (File file : this.fileChainMap().keySet()) {
            FileUtils.deleteQuietly((File)file);
        }
    }
}

