/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.mmcif.MMcifConsumer;
import org.biojava.nbio.structure.io.mmcif.model.AtomSite;
import org.biojava.nbio.structure.io.mmcif.model.AtomSites;
import org.biojava.nbio.structure.io.mmcif.model.AuditAuthor;
import org.biojava.nbio.structure.io.mmcif.model.Cell;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompAtom;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompBond;
import org.biojava.nbio.structure.io.mmcif.model.ChemCompDescriptor;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePDBremark;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePDBrev;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePdbrevRecord;
import org.biojava.nbio.structure.io.mmcif.model.Entity;
import org.biojava.nbio.structure.io.mmcif.model.EntityPoly;
import org.biojava.nbio.structure.io.mmcif.model.EntityPolySeq;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcGen;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcNat;
import org.biojava.nbio.structure.io.mmcif.model.EntitySrcSyn;
import org.biojava.nbio.structure.io.mmcif.model.Exptl;
import org.biojava.nbio.structure.io.mmcif.model.PdbxAuditRevisionHistory;
import org.biojava.nbio.structure.io.mmcif.model.PdbxChemCompDescriptor;
import org.biojava.nbio.structure.io.mmcif.model.PdbxChemCompIdentifier;
import org.biojava.nbio.structure.io.mmcif.model.PdbxDatabaseStatus;
import org.biojava.nbio.structure.io.mmcif.model.PdbxEntityNonPoly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxNonPolyScheme;
import org.biojava.nbio.structure.io.mmcif.model.PdbxPolySeqScheme;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssembly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssemblyGen;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructOperList;
import org.biojava.nbio.structure.io.mmcif.model.Refine;
import org.biojava.nbio.structure.io.mmcif.model.Struct;
import org.biojava.nbio.structure.io.mmcif.model.StructAsym;
import org.biojava.nbio.structure.io.mmcif.model.StructConn;
import org.biojava.nbio.structure.io.mmcif.model.StructKeywords;
import org.biojava.nbio.structure.io.mmcif.model.StructNcsOper;
import org.biojava.nbio.structure.io.mmcif.model.StructRef;
import org.biojava.nbio.structure.io.mmcif.model.StructRefSeq;
import org.biojava.nbio.structure.io.mmcif.model.StructRefSeqDif;
import org.biojava.nbio.structure.io.mmcif.model.StructSite;
import org.biojava.nbio.structure.io.mmcif.model.StructSiteGen;
import org.biojava.nbio.structure.io.mmcif.model.Symmetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.poznan.put.notation.LeontisWesthof;
import pl.poznan.put.notation.Saenger;
import pl.poznan.put.pdb.ExperimentalTechnique;
import pl.poznan.put.pdb.ImmutablePdbAtomLine;
import pl.poznan.put.pdb.ImmutablePdbExpdtaLine;
import pl.poznan.put.pdb.ImmutablePdbHeaderLine;
import pl.poznan.put.pdb.ImmutablePdbModresLine;
import pl.poznan.put.pdb.ImmutablePdbNamedResidueIdentifier;
import pl.poznan.put.pdb.ImmutablePdbRemark2Line;
import pl.poznan.put.pdb.ImmutablePdbRemark465Line;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbExpdtaLine;
import pl.poznan.put.pdb.PdbHeaderLine;
import pl.poznan.put.pdb.PdbModresLine;
import pl.poznan.put.pdb.PdbRemark2Line;
import pl.poznan.put.pdb.PdbRemark465Line;
import pl.poznan.put.pdb.analysis.CifModel;
import pl.poznan.put.pdb.analysis.ImmutableDefaultCifModel;
import pl.poznan.put.pdb.analysis.ResidueTypeDetector;
import pl.poznan.put.structure.ImmutableBasePair;
import pl.poznan.put.structure.ImmutableQuantifiedBasePair;
import pl.poznan.put.structure.QuantifiedBasePair;

class CifConsumer
implements MMcifConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CifConsumer.class);
    private static final String PDBX_STRUCT_MOD_RESIDUE = "_pdbx_struct_mod_residue";
    private static final String PDBX_UNOBS_OR_ZERO_OCC_RESIDUES = "_pdbx_unobs_or_zero_occ_residues";
    private static final String NDB_STRUCT_NA_BASE_PAIR = "_ndb_struct_na_base_pair";
    private static final String SHEAR = "shear";
    private static final String STRETCH = "stretch";
    private static final String STAGGER = "stagger";
    private static final String BUCKLE = "buckle";
    private static final String PROPELLER = "propeller";
    private static final String OPENING = "opening";
    private final Map<Integer, List<PdbAtomLine>> modelAtoms = new TreeMap<Integer, List<PdbAtomLine>>();
    private final Collection<PdbRemark465Line> missingResidues = new ArrayList<PdbRemark465Line>();
    private final Collection<PdbModresLine> modifiedResidues = new ArrayList<PdbModresLine>();
    private final List<ExperimentalTechnique> experimentalTechniques = new ArrayList<ExperimentalTechnique>();
    private final Collection<QuantifiedBasePair> basePairs = new ArrayList<QuantifiedBasePair>();
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    @Nullable
    private Date depositionDate;
    @Nullable
    private String classification;
    @Nullable
    private String idCode;
    @Nullable
    private String title;
    private double resolution = Double.NaN;
    private FileParsingParameters parameters = new FileParsingParameters();

    private CifConsumer(FileParsingParameters parameters) {
        this.parameters = parameters;
    }

    CifConsumer() {
    }

    private static Map<String, String> convertToMap(List<String> loopFields, List<String> lineData) {
        return IntStream.range(0, loopFields.size()).boxed().collect(Collectors.toMap(loopFields::get, lineData::get, (a, b) -> b));
    }

    private static double getDoubleWithDefaultNaN(Map<String, String> map, String key) {
        return map.containsKey(key) ? Double.parseDouble(map.get(key)) : Double.NaN;
    }

    public final void documentStart() {
        this.modelAtoms.clear();
        this.missingResidues.clear();
        this.modifiedResidues.clear();
        this.experimentalTechniques.clear();
        this.basePairs.clear();
        this.depositionDate = null;
        this.classification = null;
        this.idCode = null;
        this.resolution = Double.NaN;
    }

    public void documentEnd() {
    }

    public final void newAtomSite(AtomSite atomSite) {
        try {
            int serialNumber = Integer.parseInt(atomSite.getId());
            String atomName = atomSite.getAuth_atom_id() != null ? atomSite.getAuth_atom_id() : atomSite.getLabel_atom_id();
            String alternateLocation = atomSite.getLabel_alt_id();
            String residueName = atomSite.getAuth_comp_id() != null ? atomSite.getAuth_comp_id() : atomSite.getLabel_comp_id();
            String chainIdentifier = atomSite.getAuth_asym_id() != null ? atomSite.getAuth_asym_id() : atomSite.getLabel_asym_id();
            int residueNumber = Integer.parseInt(atomSite.getAuth_seq_id() != null ? atomSite.getAuth_seq_id() : atomSite.getLabel_seq_id());
            String insertionCode = atomSite.getPdbx_PDB_ins_code();
            double x = Double.parseDouble(atomSite.getCartn_x());
            double y = Double.parseDouble(atomSite.getCartn_y());
            double z = Double.parseDouble(atomSite.getCartn_z());
            double occupancy = Objects.equals(".", atomSite.getOccupancy()) ? Double.NaN : Double.parseDouble(atomSite.getOccupancy());
            double temperatureFactor = Objects.equals(".", atomSite.getB_iso_or_equiv()) ? Double.NaN : Double.parseDouble(atomSite.getB_iso_or_equiv());
            String elementSymbol = atomSite.getType_symbol();
            String charge = atomSite.getPdbx_formal_charge();
            if (Objects.equals("?", insertionCode)) {
                insertionCode = " ";
            }
            if (Objects.equals(".", alternateLocation)) {
                alternateLocation = " ";
            }
            if (Objects.equals("?", charge)) {
                charge = " ";
            }
            ImmutablePdbAtomLine atomLine = ImmutablePdbAtomLine.of(serialNumber, atomName, alternateLocation, residueName, chainIdentifier, residueNumber, insertionCode, x, y, z, occupancy, temperatureFactor, elementSymbol, charge);
            String modelNumberString = atomSite.getPdbx_PDB_model_num();
            int modelNumber = 1;
            if (StringUtils.isNotBlank((CharSequence)modelNumberString)) {
                modelNumber = Integer.parseInt(modelNumberString);
            }
            if (!this.modelAtoms.containsKey(modelNumber)) {
                this.modelAtoms.put(modelNumber, new ArrayList());
            }
            List<PdbAtomLine> atomLines = this.modelAtoms.get(modelNumber);
            atomLines.add(atomLine);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Failed to parse _atom_site", (Throwable)e);
        }
    }

    public void newEntity(Entity entity) {
    }

    public void newEntityPoly(EntityPoly entityPoly) {
    }

    public void newEntityPolySeq(EntityPolySeq entityPolySeq) {
    }

    public void newStructAsym(StructAsym structAsym) {
    }

    public final void setStruct(Struct struct) {
        this.title = StringUtils.upperCase((String)struct.getTitle());
    }

    public final void newDatabasePDBrev(DatabasePDBrev databasePDBrev) {
        try {
            if (this.depositionDate == null) {
                this.depositionDate = this.dateFormat.parse(databasePDBrev.getDate_original());
            }
        }
        catch (ParseException e) {
            LOGGER.warn("Failed to parse _database_PDB_rev.date_original as yyyy-MM-dd: {}", (Object)databasePDBrev.getDate_original(), (Object)e);
        }
    }

    public void newDatabasePDBrevRecord(DatabasePdbrevRecord databasePdbrevRecord) {
    }

    public void newDatabasePDBremark(DatabasePDBremark databasePDBremark) {
    }

    public final void newExptl(Exptl exptl) {
        ExperimentalTechnique technique = ExperimentalTechnique.fromFullName(exptl.getMethod());
        if (technique == ExperimentalTechnique.UNKNOWN) {
            LOGGER.warn("Failed to parse _exptl.method: {}", (Object)exptl.getMethod());
        } else {
            this.experimentalTechniques.add(technique);
        }
    }

    public void newCell(Cell cell) {
    }

    public void newSymmetry(Symmetry symmetry) {
    }

    public void newStructNcsOper(StructNcsOper structNcsOper) {
    }

    public void newAtomSites(AtomSites atomSites) {
    }

    public void newStructRef(StructRef structRef) {
    }

    public void newStructRefSeq(StructRefSeq structRefSeq) {
    }

    public void newStructRefSeqDif(StructRefSeqDif structRefSeqDif) {
    }

    public void newStructSite(StructSite structSite) {
    }

    public void newStructSiteGen(StructSiteGen structSiteGen) {
    }

    public void newPdbxAuditRevisionHistory(PdbxAuditRevisionHistory pdbxAuditRevisionHistory) {
    }

    public void newPdbxDatabaseStatus(PdbxDatabaseStatus pdbxDatabaseStatus) {
    }

    public void newPdbxPolySeqScheme(PdbxPolySeqScheme pdbxPolySeqScheme) {
    }

    public void newPdbxNonPolyScheme(PdbxNonPolyScheme pdbxNonPolyScheme) {
    }

    public void newPdbxEntityNonPoly(PdbxEntityNonPoly pdbxEntityNonPoly) {
    }

    public final void newStructKeywords(StructKeywords structKeywords) {
        this.idCode = structKeywords.getEntry_id();
        this.classification = structKeywords.getPdbx_keywords();
    }

    public final void newRefine(Refine refine) {
        try {
            this.resolution = Double.parseDouble(refine.getLs_d_res_high());
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Failed to parse _refine.ls_d_res_high: {}", (Object)refine.getLs_d_res_high(), (Object)e);
        }
    }

    public void newChemComp(ChemComp chemComp) {
    }

    public void newChemCompDescriptor(ChemCompDescriptor chemCompDescriptor) {
    }

    public void newPdbxStructOperList(PdbxStructOperList pdbxStructOperList) {
    }

    public void newPdbxStrucAssembly(PdbxStructAssembly pdbxStructAssembly) {
    }

    public void newPdbxStrucAssemblyGen(PdbxStructAssemblyGen pdbxStructAssemblyGen) {
    }

    public void newChemCompAtom(ChemCompAtom chemCompAtom) {
    }

    public void newPdbxChemCompIndentifier(PdbxChemCompIdentifier pdbxChemCompIdentifier) {
    }

    public void newChemCompBond(ChemCompBond chemCompBond) {
    }

    public void newPdbxChemCompDescriptor(PdbxChemCompDescriptor pdbxChemCompDescriptor) {
    }

    public void newEntitySrcGen(EntitySrcGen entitySrcGen) {
    }

    public void newEntitySrcNat(EntitySrcNat entitySrcNat) {
    }

    public void newEntitySrcSyn(EntitySrcSyn entitySrcSyn) {
    }

    public void newStructConn(StructConn structConn) {
    }

    public void newAuditAuthor(AuditAuthor auditAuthor) {
    }

    public final void newGenericData(String s, List<String> list, List<String> list1) {
        if (Objects.equals(PDBX_STRUCT_MOD_RESIDUE, s)) {
            Map<String, String> map = CifConsumer.convertToMap(list, list1);
            String residueName = map.get("auth_comp_id");
            String chainIdentifier = map.get("auth_asym_id");
            int residueNumber = Integer.parseInt(map.get("auth_seq_id"));
            String insertionCode = map.get("PDB_ins_code");
            String standardResidueName = map.get("parent_comp_id");
            String comment = map.get("details");
            if (Objects.equals("?", insertionCode)) {
                insertionCode = " ";
            }
            ImmutablePdbModresLine modresLine = ImmutablePdbModresLine.of(this.idCode, residueName, chainIdentifier, residueNumber, insertionCode, standardResidueName, comment);
            this.modifiedResidues.add(modresLine);
        } else if (Objects.equals(PDBX_UNOBS_OR_ZERO_OCC_RESIDUES, s)) {
            Map<String, String> map = CifConsumer.convertToMap(list, list1);
            int modelNumber = Integer.parseInt(map.get("PDB_model_num"));
            String residueName = map.get("auth_comp_id");
            String chainIdentifier = map.get("auth_asym_id");
            int residueNumber = Integer.parseInt(map.get("auth_seq_id"));
            String insertionCode = map.get("PDB_ins_code");
            if (Objects.equals("?", insertionCode)) {
                insertionCode = " ";
            }
            ImmutablePdbRemark465Line remark465Line = ImmutablePdbRemark465Line.of(modelNumber, residueName, chainIdentifier, residueNumber, insertionCode);
            this.missingResidues.add(remark465Line);
        } else if (Objects.equals(NDB_STRUCT_NA_BASE_PAIR, s)) {
            String leontisWesthofString;
            Map<String, String> map = CifConsumer.convertToMap(list, list1);
            String chainL = map.get("i_auth_asym_id");
            int resiL = Integer.parseInt(map.get("i_auth_seq_id"));
            String icodeL = map.get("i_PDB_ins_code");
            if (Objects.equals("?", icodeL)) {
                icodeL = " ";
            }
            String resnL = map.get("i_label_comp_id");
            char oneLetterL = ResidueTypeDetector.detectResidueType(resnL, Collections.emptySet()).oneLetterName();
            ImmutablePdbNamedResidueIdentifier left = ImmutablePdbNamedResidueIdentifier.of(chainL, resiL, icodeL, oneLetterL);
            String chainR = map.get("j_auth_asym_id");
            int resiR = Integer.parseInt(map.get("j_auth_seq_id"));
            String icodeR = map.get("j_PDB_ins_code");
            if (Objects.equals("?", icodeR)) {
                icodeR = " ";
            }
            String resnR = map.get("j_label_comp_id");
            char oneLetterR = ResidueTypeDetector.detectResidueType(resnR, Collections.emptySet()).oneLetterName();
            ImmutablePdbNamedResidueIdentifier right = ImmutablePdbNamedResidueIdentifier.of(chainR, resiR, icodeR, oneLetterR);
            ImmutableBasePair basePair = ImmutableBasePair.of(left, right);
            String saengerString = map.get("hbond_type_28");
            Saenger saenger = Saenger.UNKNOWN;
            if (!Objects.equals("?", saengerString)) {
                saenger = Saenger.fromNumber(Integer.parseInt(saengerString));
            }
            LeontisWesthof leontisWesthof = Objects.equals("?", leontisWesthofString = map.get("hbond_type_12")) ? LeontisWesthof.UNKNOWN : LeontisWesthof.fromNumber(Integer.parseInt(leontisWesthofString));
            double shear = CifConsumer.getDoubleWithDefaultNaN(map, SHEAR);
            double stretch = CifConsumer.getDoubleWithDefaultNaN(map, STRETCH);
            double stagger = CifConsumer.getDoubleWithDefaultNaN(map, STAGGER);
            double buckle = CifConsumer.getDoubleWithDefaultNaN(map, BUCKLE);
            double propeller = CifConsumer.getDoubleWithDefaultNaN(map, PROPELLER);
            double opening = CifConsumer.getDoubleWithDefaultNaN(map, OPENING);
            ImmutableQuantifiedBasePair quantifiedBasePair = ImmutableQuantifiedBasePair.of(basePair, shear, stretch, stagger, buckle, propeller, opening).withSaenger(saenger).withLeontisWesthof(leontisWesthof);
            this.basePairs.add(quantifiedBasePair);
        }
    }

    public final void setFileParsingParameters(FileParsingParameters fileParsingParameters) {
        this.parameters = fileParsingParameters;
    }

    public final FileParsingParameters getFileParsingParameters() {
        return this.parameters;
    }

    public final List<CifModel> getModels() {
        ImmutablePdbHeaderLine headerLine = ImmutablePdbHeaderLine.of(this.classification != null ? this.classification : "", this.depositionDate != null ? this.depositionDate : new Date(0L), this.idCode != null ? this.idCode : "");
        List<ExperimentalTechnique> techniques = this.experimentalTechniques.isEmpty() ? Collections.singletonList(ExperimentalTechnique.UNKNOWN) : this.experimentalTechniques;
        ImmutablePdbExpdtaLine experimentalDataLine = ImmutablePdbExpdtaLine.of(techniques);
        ImmutablePdbRemark2Line resolutionLine = ImmutablePdbRemark2Line.of(this.resolution);
        ArrayList<CifModel> result = new ArrayList<CifModel>();
        for (Map.Entry<Integer, List<PdbAtomLine>> entry : this.modelAtoms.entrySet()) {
            int modelNumber = entry.getKey();
            List<PdbAtomLine> atoms = entry.getValue();
            ImmutableDefaultCifModel pdbModel = ImmutableDefaultCifModel.of((PdbHeaderLine)headerLine, (PdbExpdtaLine)experimentalDataLine, (PdbRemark2Line)resolutionLine, modelNumber, atoms, this.modifiedResidues, this.missingResidues, this.title != null ? this.title : "", Collections.emptyList(), this.basePairs);
            result.add(pdbModel);
        }
        return result;
    }
}

