/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb.analysis;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import pl.poznan.put.pdb.ChainNumberICode;
import pl.poznan.put.pdb.PdbAtomLine;
import pl.poznan.put.pdb.PdbRemark465Line;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.ImmutableDefaultPdbResidue;
import pl.poznan.put.pdb.analysis.ImmutablePdbChain;
import pl.poznan.put.pdb.analysis.MoleculeType;
import pl.poznan.put.pdb.analysis.PdbChain;
import pl.poznan.put.pdb.analysis.PdbModel;
import pl.poznan.put.pdb.analysis.PdbResidue;

public abstract class AbstractPdbModel
implements PdbModel {
    @Override
    public List<PdbChain> chains() {
        LinkedHashMap chainResidues = new LinkedHashMap();
        this.residues().forEach(residue -> {
            chainResidues.putIfAbsent(residue.chainIdentifier(), new ArrayList());
            ((List)chainResidues.get(residue.chainIdentifier())).add(residue);
        });
        return chainResidues.values().stream().flatMap(residueGroup -> this.residueGroupToChains((List<PdbResidue>)residueGroup).stream()).collect(Collectors.toList());
    }

    @Override
    public List<PdbResidue> residues() {
        LinkedHashMap atomGroups = new LinkedHashMap();
        this.atoms().forEach(atom -> {
            atomGroups.putIfAbsent(PdbResidueIdentifier.from(atom), new ArrayList());
            ((List)atomGroups.get(PdbResidueIdentifier.from(atom))).add(atom);
        });
        Stream<PdbResidue> existingResidueStream = atomGroups.values().stream().map(this::atomGroupToResidue).filter(residue -> residue.residueInformationProvider().moleculeType() != MoleculeType.UNKNOWN);
        Stream<PdbResidue> missingResidueStream = this.missingResidues().stream().map(PdbRemark465Line::toResidue);
        List order = this.atoms().stream().map(PdbAtomLine::chainIdentifier).distinct().collect(Collectors.toList());
        return Stream.concat(existingResidueStream, missingResidueStream).sorted((t, t1) -> {
            if (t.chainIdentifier().equals(t1.chainIdentifier())) {
                return t.compareTo((ChainNumberICode)t1);
            }
            return Integer.compare(order.indexOf(t.chainIdentifier()), order.indexOf(t1.chainIdentifier()));
        }).collect(Collectors.toList());
    }

    private PdbResidue atomGroupToResidue(List<PdbAtomLine> residueAtoms) {
        PdbResidueIdentifier residueIdentifier = PdbResidueIdentifier.from(residueAtoms.get(0));
        boolean isModified = this.isModified(residueIdentifier);
        String residueName = residueAtoms.get(0).residueName();
        String modifiedResidueName = isModified ? this.modificationDetails(residueIdentifier).standardResidueName() : residueName;
        return ImmutableDefaultPdbResidue.of(residueIdentifier, residueName, modifiedResidueName, residueAtoms);
    }

    private List<PdbChain> residueGroupToChains(List<PdbResidue> residueGroup) {
        ArrayList<PdbChain> chains = new ArrayList<PdbChain>();
        List branchingPoints = IntStream.range(0, residueGroup.size()).filter(i -> this.chainTerminatedAfter().contains(PdbResidueIdentifier.from((ChainNumberICode)residueGroup.get(i)))).boxed().collect(Collectors.toList());
        int begin = 0;
        Iterator iterator = branchingPoints.iterator();
        while (iterator.hasNext()) {
            int end;
            int branchingPoint = (Integer)iterator.next();
            for (end = branchingPoint + 1; end < residueGroup.size() && residueGroup.get(end).isMissing(); ++end) {
            }
            chains.add(ImmutablePdbChain.of(residueGroup.get(0).chainIdentifier(), residueGroup.subList(begin, end)));
            begin = end;
        }
        if (begin < residueGroup.size()) {
            chains.add(ImmutablePdbChain.of(residueGroup.get(0).chainIdentifier(), residueGroup.subList(begin, residueGroup.size())));
        }
        return chains;
    }
}

