/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import org.immutables.value.Value;
import pl.poznan.put.pdb.ImmutablePdbTitleLine;
import pl.poznan.put.pdb.PdbParsingException;

@Value.Immutable
public abstract class PdbTitleLine
implements Serializable {
    private static final String FORMAT = "TITLE   %2s%70s";
    private static final String RECORD_NAME = "TITLE";

    public static PdbTitleLine parse(String line) {
        if (line.length() < 80) {
            throw new PdbParsingException(String.format("PDB %s line is not shorter than %d characters", RECORD_NAME, 80));
        }
        String recordName = line.substring(0, 6).trim();
        if (!Objects.equals(RECORD_NAME, recordName)) {
            throw new PdbParsingException(String.format("PDB line does not start with %s", RECORD_NAME));
        }
        String continuation = line.substring(8, 10).trim();
        String title = line.substring(10, 80).trim();
        return ImmutablePdbTitleLine.of(continuation, title);
    }

    @Value.Parameter(order=1)
    public abstract String continuation();

    @Value.Parameter(order=2)
    public abstract String title();

    public final String toString() {
        return this.toPdb();
    }

    public final String toPdb() {
        return String.format(Locale.US, FORMAT, this.continuation(), this.title());
    }
}

