/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb;

import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;
import pl.poznan.put.pdb.ChainNumberICode;
import pl.poznan.put.pdb.ImmutablePdbResidueIdentifier;

@Value.Immutable
public abstract class PdbResidueIdentifier
implements ChainNumberICode {
    public static PdbResidueIdentifier from(ChainNumberICode chainNumberICode) {
        return ImmutablePdbResidueIdentifier.of(chainNumberICode.chainIdentifier(), chainNumberICode.residueNumber(), chainNumberICode.insertionCode());
    }

    @Override
    @Value.Parameter(order=1)
    public abstract String chainIdentifier();

    @Override
    @Value.Parameter(order=2)
    public abstract int residueNumber();

    @Override
    @Value.Parameter(order=3)
    public abstract String insertionCode();

    public final String toString() {
        String chain = StringUtils.isBlank((CharSequence)this.chainIdentifier()) ? "" : this.chainIdentifier() + '.';
        String icode = StringUtils.isBlank((CharSequence)this.insertionCode()) ? "" : this.insertionCode();
        return chain + this.residueNumber() + icode;
    }
}

