/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.poznan.put.pdb.ChainNumberICode;
import pl.poznan.put.pdb.ImmutablePdbRemark465Line;
import pl.poznan.put.pdb.PdbParsingException;
import pl.poznan.put.pdb.PdbResidueIdentifier;
import pl.poznan.put.pdb.analysis.ImmutableDefaultPdbResidue;
import pl.poznan.put.pdb.analysis.PdbResidue;

@Value.Immutable
public abstract class PdbRemark465Line
implements ChainNumberICode {
    public static final String PROLOGUE = "REMARK 465                                                                      \nREMARK 465 MISSING RESIDUES                                                     \nREMARK 465 THE FOLLOWING RESIDUES WERE NOT LOCATED IN THE                       \nREMARK 465 EXPERIMENT. (M=MODEL NUMBER; RES=RESIDUE NAME; C=CHAIN               \nREMARK 465 IDENTIFIER; SSSEQ=SEQUENCE NUMBER; I=INSERTION CODE.)                \nREMARK 465                                                                      \nREMARK 465   M RES C SSSEQI                                                     ";
    private static final String[] COMMENT_LINES = new String[]{"REMARK 465", "REMARK 465 MISSING RESIDUES", "REMARK 465 THE FOLLOWING RESIDUES WERE NOT LOCATED IN THE", "REMARK 465 EXPERIMENT. (M=MODEL NUMBER; RES=RESIDUE NAME; C=CHAIN", "REMARK 465 IDENTIFIER; SSSEQ=SEQUENCE NUMBER; I=INSERTION CODE.)", "REMARK 465 M RES C SSSEQI", "REMARK 465 EXPERIMENT. (RES=RESIDUE NAME; C=CHAIN IDENTIFIER;", "REMARK 465 SSSEQ=SEQUENCE NUMBER; I=INSERTION CODE.)", "REMARK 465 RES C SSSEQI"};
    private static final String REMARK_FORMAT = "  %1s %3s %c %5d%c                                                     ";
    private static final String FORMAT = "REMARK 465   %1s %3s %c %5d%c                                                     ";
    private static final Logger LOGGER = LoggerFactory.getLogger(PdbRemark465Line.class);

    public static boolean isCommentLine(String line) {
        String lineTrimmed = StringUtils.normalizeSpace((String)line);
        return Arrays.stream(COMMENT_LINES).anyMatch(comment -> Objects.equals(lineTrimmed, StringUtils.normalizeSpace((String)comment))) || lineTrimmed.startsWith("REMARK 465   MODELS");
    }

    public static PdbRemark465Line parse(String line) {
        if (line.length() < 79) {
            throw new PdbParsingException("PDB REMARK line is not at least 79 character long");
        }
        try {
            String recordName = line.substring(0, 6).trim();
            if (!Objects.equals("REMARK", recordName)) {
                throw new PdbParsingException("PDB line does not start with REMARK");
            }
            int remarkNumber = Integer.parseInt(line.substring(7, 10).trim());
            if (remarkNumber != 465) {
                throw new PdbParsingException("Unsupported REMARK line occurred");
            }
            String remarkContent = StringUtils.stripEnd((String)line.substring(11, 79), null);
            int modelNumber = remarkContent.charAt(2) == ' ' ? 0 : Integer.parseInt(remarkContent.substring(2, 3));
            String residueName = remarkContent.substring(4, 7).trim();
            String chainIdentifier = Character.toString(remarkContent.charAt(8));
            int residueNumber = Integer.parseInt(remarkContent.substring(10, 15).trim());
            String insertionCode = remarkContent.length() == 15 ? " " : Character.toString(remarkContent.charAt(15));
            return ImmutablePdbRemark465Line.of(modelNumber, residueName, chainIdentifier, residueNumber, insertionCode);
        }
        catch (NumberFormatException e) {
            throw new PdbParsingException("Failed to parse PDB REMARK 465 line", e);
        }
    }

    @Value.Parameter(order=1)
    public abstract int modelNumber();

    @Value.Parameter(order=2)
    public abstract String residueName();

    @Override
    @Value.Parameter(order=3)
    public abstract String chainIdentifier();

    @Override
    @Value.Parameter(order=4)
    public abstract int residueNumber();

    @Override
    @Value.Parameter(order=5)
    public abstract String insertionCode();

    public final String toString() {
        return this.toPdb();
    }

    public final String toPdb() {
        if (this.chainIdentifier().length() != 1) {
            LOGGER.error("Field 'chainIdentifier' is longer than 1 char. Only first letter will be taken");
        }
        if (this.insertionCode().length() != 1) {
            LOGGER.error("Field 'insertionCode' is longer than 1 char. Only first letter will be taken");
        }
        String modelNumberString = this.modelNumber() == 0 ? " " : String.valueOf(this.modelNumber());
        char chain = this.chainIdentifier().charAt(0);
        char icode = this.insertionCode().charAt(0);
        return String.format(Locale.US, FORMAT, modelNumberString, this.residueName(), Character.valueOf(chain), this.residueNumber(), Character.valueOf(icode));
    }

    public final PdbResidue toResidue() {
        return ImmutableDefaultPdbResidue.of(PdbResidueIdentifier.from(this), this.residueName(), this.residueName(), Collections.emptyList());
    }
}

