/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import org.immutables.value.Value;
import pl.poznan.put.pdb.ImmutablePdbRemark2Line;
import pl.poznan.put.pdb.PdbParsingException;

@Value.Immutable
public abstract class PdbRemark2Line
implements Serializable {
    public static final String PROLOGUE = "REMARK   2                                                                      ";
    private static final String FORMAT = "REMARK   2 RESOLUTION. %7.2f ANGSTROMS.                                       ";
    private static final String NOT_APPLICABLE = "REMARK   2 RESOLUTION. NOT APPLICABLE.                                          ";

    public static PdbRemark2Line parse(String line) {
        if (!line.startsWith("REMARK   2 RESOLUTION.")) {
            throw new PdbParsingException("Failed to parse REMARK   2 RESOLUTION. line: " + line);
        }
        try {
            String resolutionString = line.substring(23).trim();
            double resolution = Double.NaN;
            if (!Objects.equals("NOT APPLICABLE.", resolutionString)) {
                resolution = Double.parseDouble(line.substring(23, 30).trim());
            }
            return ImmutablePdbRemark2Line.of(resolution);
        }
        catch (NumberFormatException e) {
            throw new PdbParsingException("Failed to parse REMARK   2 RESOLUTION. line", e);
        }
    }

    @Value.Parameter(order=1)
    public abstract double resolution();

    public final String toString() {
        return this.toPdb();
    }

    public final String toPdb() {
        return Double.isNaN(this.resolution()) ? NOT_APPLICABLE : String.format(Locale.US, FORMAT, this.resolution());
    }
}

