/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.poznan.put.pdb.ChainNumberICode;
import pl.poznan.put.pdb.ImmutablePdbModresLine;
import pl.poznan.put.pdb.PdbParsingException;

@Value.Immutable
public abstract class PdbModresLine
implements ChainNumberICode,
Serializable {
    private static final String FORMAT = "MODRES %4s %3s %c %4d%c %3s  %41s          ";
    private static final String RECORD_NAME = "MODRES";
    private static final Logger LOGGER = LoggerFactory.getLogger(PdbModresLine.class);

    public static PdbModresLine parse(String line) {
        if (line.length() < 70) {
            throw new PdbParsingException("PDB MODRES line is not at least 70 character long");
        }
        try {
            String recordName = line.substring(0, 6).trim();
            if (!Objects.equals(RECORD_NAME, recordName)) {
                throw new PdbParsingException("PDB line does not start with MODRES");
            }
            String idCode = line.substring(7, 11).trim();
            String residueName = line.substring(12, 15).trim();
            String chainIdentifier = Character.toString(line.charAt(16));
            int residueNumber = Integer.parseInt(line.substring(18, 22).trim());
            String insertionCode = Character.toString(line.charAt(22));
            String standardResidueName = line.substring(24, 27).trim();
            String comment = line.substring(29, 70);
            return ImmutablePdbModresLine.of(idCode, residueName, chainIdentifier, residueNumber, insertionCode, standardResidueName, comment);
        }
        catch (NumberFormatException e) {
            throw new PdbParsingException("Failed to parse PDB MODRES line", e);
        }
    }

    @Value.Parameter(order=1)
    public abstract String idCode();

    @Value.Parameter(order=2)
    public abstract String residueName();

    @Override
    @Value.Parameter(order=3)
    public abstract String chainIdentifier();

    @Override
    @Value.Parameter(order=4)
    public abstract int residueNumber();

    @Override
    @Value.Parameter(order=5)
    public abstract String insertionCode();

    @Value.Parameter(order=6)
    public abstract String standardResidueName();

    @Value.Parameter(order=7)
    public abstract String comment();

    public final String toString() {
        return this.toPdb();
    }

    public final String toPdb() {
        if (this.chainIdentifier().length() != 1) {
            LOGGER.error("Field 'chainIdentifier' is longer than 1 char. Only first letter will be taken");
        }
        if (this.insertionCode().length() != 1) {
            LOGGER.error("Field 'insertionCode' is longer than 1 char. Only first letter will be taken");
        }
        return String.format(Locale.US, FORMAT, this.idCode(), this.residueName(), Character.valueOf(this.chainIdentifier().charAt(0)), this.residueNumber(), Character.valueOf(this.insertionCode().charAt(0)), this.standardResidueName(), this.comment());
    }
}

