/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.immutables.value.Value;
import pl.poznan.put.pdb.ImmutablePdbHeaderLine;
import pl.poznan.put.pdb.PdbParsingException;

@Value.Immutable
public abstract class PdbHeaderLine
implements Serializable {
    private static final String FORMAT = "HEADER    %-40s%9s   %4s              ";
    private static final String RECORD_NAME = "HEADER";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd-MMM-yy", Locale.US);

    public static PdbHeaderLine parse(String line) {
        if (line.length() < 66) {
            throw new PdbParsingException("PDB HEADER line is not at least 66 characters long");
        }
        String recordName = line.substring(0, 6).trim();
        if (!Objects.equals(RECORD_NAME, recordName)) {
            throw new PdbParsingException("PDB line does not start with HEADER");
        }
        try {
            String classification = line.substring(10, 50).trim();
            Date depositionDate = DATE_FORMAT.parse(line.substring(50, 59).trim());
            String idCode = line.substring(62, 66).trim();
            return ImmutablePdbHeaderLine.of(classification, depositionDate, idCode);
        }
        catch (ParseException e) {
            throw new PdbParsingException("Failed to parse date in line: " + line, e);
        }
    }

    @Value.Parameter(order=1)
    public abstract String classification();

    @Value.Parameter(order=2)
    public abstract Date depositionDate();

    @Value.Parameter(order=3)
    public abstract String idCode();

    public final String toString() {
        return this.toPdb();
    }

    public final String toPdb() {
        return String.format(Locale.US, FORMAT, this.classification(), DATE_FORMAT.format(this.depositionDate()).toUpperCase(Locale.US), this.idCode());
    }
}

