/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.immutables.value.Value;
import pl.poznan.put.pdb.ExperimentalTechnique;
import pl.poznan.put.pdb.ImmutablePdbExpdtaLine;
import pl.poznan.put.pdb.PdbParsingException;

@Value.Immutable
public abstract class PdbExpdtaLine
implements Serializable {
    private static final String FORMAT = "EXPDTA    %-70s";
    private static final String RECORD_NAME = "EXPDTA";

    public static PdbExpdtaLine parse(String line) {
        String recordName = line.substring(0, 6).trim();
        if (!Objects.equals(RECORD_NAME, recordName)) {
            throw new PdbParsingException("PDB line does not start with EXPDTA");
        }
        ArrayList<ExperimentalTechnique> experimentalTechniques = new ArrayList<ExperimentalTechnique>();
        for (String techniqueFullName : line.substring(10).trim().split(";")) {
            ExperimentalTechnique technique = ExperimentalTechnique.fromFullName(techniqueFullName.trim());
            if (technique == ExperimentalTechnique.UNKNOWN) {
                throw new PdbParsingException("Failed to parse line: " + line);
            }
            experimentalTechniques.add(technique);
        }
        return ImmutablePdbExpdtaLine.of(experimentalTechniques);
    }

    @Value.Parameter(order=1)
    public abstract List<ExperimentalTechnique> experimentalTechniques();

    public final String toString() {
        return this.toPdb();
    }

    public final String toPdb() {
        StringBuilder builder = new StringBuilder();
        if (this.experimentalTechniques().isEmpty()) {
            builder.append((Object)ExperimentalTechnique.UNKNOWN);
        } else {
            builder.append(this.experimentalTechniques().get(0).getPdbName());
            for (int i = 1; i < this.experimentalTechniques().size(); ++i) {
                builder.append("; ");
                builder.append(this.experimentalTechniques().get(i).getPdbName());
            }
        }
        return String.format(Locale.US, FORMAT, builder);
    }
}

