/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb;

import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.HetatomImpl;
import org.biojava.nbio.structure.ResidueNumber;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.poznan.put.atom.AtomName;
import pl.poznan.put.pdb.ChainNumberICode;
import pl.poznan.put.pdb.CifPdbIncompatibilityException;
import pl.poznan.put.pdb.ImmutablePdbAtomLine;
import pl.poznan.put.pdb.PdbParsingException;

@Value.Immutable
public abstract class PdbAtomLine
implements Serializable,
ChainNumberICode {
    public static final String CIF_LOOP = "loop_\n_atom_site.group_PDB\n_atom_site.id\n_atom_site.auth_atom_id\n_atom_site.label_alt_id\n_atom_site.auth_comp_id\n_atom_site.auth_asym_id\n_atom_site.auth_seq_id\n_atom_site.pdbx_PDB_ins_code\n_atom_site.Cartn_x\n_atom_site.Cartn_y\n_atom_site.Cartn_z\n_atom_site.occupancy\n_atom_site.B_iso_or_equiv\n_atom_site.type_symbol\n_atom_site.pdbx_formal_charge";
    private static final String FORMAT_ATOM_4_CHARACTER = "ATOM  %5d %-4s%c%3s %c%4d%c   %8.3f%8.3f%8.3f%6.2f%6.2f          %2s%2s";
    private static final String FORMAT = "ATOM  %5d  %-3s%c%3s %c%4d%c   %8.3f%8.3f%8.3f%6.2f%6.2f          %2s%2s";
    private static final String RECORD_NAME = "ATOM";
    private static final Logger LOGGER = LoggerFactory.getLogger(PdbAtomLine.class);

    public static PdbAtomLine fromBioJavaAtom(Atom atom) {
        Group group = atom.getGroup();
        String residueName = group.getPDBName();
        ResidueNumber residueNumberObject = group.getResidueNumber();
        String chainIdentifier = residueNumberObject.getChainName();
        int residueNumber = residueNumberObject.getSeqNum();
        String insertionCode = residueNumberObject.getInsCode() == null ? " " : Character.toString(residueNumberObject.getInsCode().charValue());
        int serialNumber = atom.getPDBserial();
        String atomName = atom.getName();
        String alternateLocation = atom.getAltLoc() == null ? " " : Character.toString(atom.getAltLoc().charValue());
        double x = atom.getX();
        double y = atom.getY();
        double z = atom.getZ();
        double occupancy = atom.getOccupancy();
        double temperatureFactor = atom.getTempFactor();
        String elementSymbol = atom.getElement().name();
        String charge = "";
        return ImmutablePdbAtomLine.of(serialNumber, atomName, alternateLocation, residueName, chainIdentifier, residueNumber, insertionCode, x, y, z, occupancy, temperatureFactor, elementSymbol, "");
    }

    public static PdbAtomLine parse(String line) {
        return PdbAtomLine.parse(line, true);
    }

    public static PdbAtomLine parse(String line, boolean strictMode) {
        int minLineLenth;
        int n = minLineLenth = strictMode ? 80 : 54;
        if (line.length() < minLineLenth) {
            throw new PdbParsingException("PDB ATOM line is too short");
        }
        try {
            String recordName = line.substring(0, 6).trim();
            if (!Objects.equals(RECORD_NAME, recordName) && !Objects.equals("HETATM", recordName)) {
                throw new PdbParsingException("PDB line does not start with ATOM or HETATM");
            }
            int serialNumber = Integer.parseInt(line.substring(6, 11).trim());
            String atomName = line.substring(12, 16).trim();
            String alternateLocation = Character.toString(line.charAt(16));
            String residueName = line.substring(17, 20).trim();
            String chainIdentifier = Character.toString(line.charAt(21));
            int residueNumber = Integer.parseInt(line.substring(22, 26).trim());
            String insertionCode = Character.toString(line.charAt(26));
            double x = Double.parseDouble(line.substring(30, 38).trim());
            double y = Double.parseDouble(line.substring(38, 46).trim());
            double z = Double.parseDouble(line.substring(46, 54).trim());
            double occupancy = line.length() >= 60 && StringUtils.isNotBlank((CharSequence)line.substring(54, 60)) ? Double.parseDouble(line.substring(54, 60).trim()) : 0.0;
            double temperatureFactor = line.length() >= 66 && StringUtils.isNotBlank((CharSequence)line.substring(60, 66)) ? Double.parseDouble(line.substring(60, 66).trim()) : 0.0;
            String elementSymbol = line.length() >= 78 ? line.substring(76, 78).trim() : "";
            String charge = line.length() >= 80 ? line.substring(78, 80).trim() : "";
            return ImmutablePdbAtomLine.of(serialNumber, atomName, alternateLocation, residueName, chainIdentifier, residueNumber, insertionCode, x, y, z, occupancy, temperatureFactor, elementSymbol, charge);
        }
        catch (NumberFormatException e) {
            throw new PdbParsingException("Failed to parse PDB ATOM line", e);
        }
    }

    @Value.Parameter(order=1)
    @Value.Auxiliary
    public abstract int serialNumber();

    @Value.Parameter(order=2)
    public abstract String atomName();

    @Value.Parameter(order=3)
    @Value.Auxiliary
    public abstract String alternateLocation();

    @Value.Parameter(order=4)
    public abstract String residueName();

    @Override
    @Value.Parameter(order=5)
    public abstract String chainIdentifier();

    @Override
    @Value.Parameter(order=6)
    public abstract int residueNumber();

    @Override
    @Value.Parameter(order=7)
    public abstract String insertionCode();

    @Value.Parameter(order=8)
    public abstract double x();

    @Value.Parameter(order=9)
    public abstract double y();

    @Value.Parameter(order=10)
    public abstract double z();

    @Value.Parameter(order=11)
    @Value.Auxiliary
    public abstract double occupancy();

    @Value.Parameter(order=12)
    @Value.Auxiliary
    public abstract double temperatureFactor();

    @Value.Parameter(order=13)
    @Value.Auxiliary
    public abstract String elementSymbol();

    @Value.Parameter(order=14)
    @Value.Auxiliary
    public abstract String charge();

    public final String toString() {
        return this.toPdb();
    }

    public final AtomName detectAtomName() {
        return AtomName.fromString(this.atomName());
    }

    public final double distanceTo(PdbAtomLine other) {
        return this.toVector3D().distance((Vector)other.toVector3D());
    }

    public final Atom toBioJavaAtom() {
        if (this.alternateLocation().length() != 1) {
            throw new CifPdbIncompatibilityException("Cannot convert to PDB. Field 'alternateLocation' is longer than 1 char");
        }
        if (this.insertionCode().length() != 1) {
            throw new CifPdbIncompatibilityException("Cannot convert to PDB. Field 'insertionCode' is longer than 1 char");
        }
        HetatomImpl group = new HetatomImpl();
        Character icode = Objects.equals(" ", this.insertionCode()) ? null : Character.valueOf(this.insertionCode().charAt(0));
        group.setResidueNumber(String.valueOf(this.chainIdentifier()), Integer.valueOf(this.residueNumber()), icode);
        group.setPDBName(this.residueName());
        String name = this.atomName().length() == 4 ? this.atomName() : String.format(" %-3s", this.atomName());
        AtomImpl atom = new AtomImpl();
        atom.setPDBserial(this.serialNumber());
        atom.setName(name);
        atom.setAltLoc(Character.valueOf(this.alternateLocation().charAt(0)));
        atom.setX(this.x());
        atom.setY(this.y());
        atom.setZ(this.z());
        atom.setOccupancy((float)this.occupancy());
        atom.setTempFactor((float)this.temperatureFactor());
        atom.setElement(Element.valueOfIgnoreCase((String)this.elementSymbol()));
        atom.setGroup((Group)group);
        return atom;
    }

    public final String toCif() {
        StringBuilder builder = new StringBuilder();
        builder.append("ATOM ");
        builder.append(this.serialNumber()).append(' ');
        if (this.atomName().contains("'")) {
            builder.append('\"').append(this.atomName()).append("\" ");
        } else {
            builder.append(this.atomName()).append(' ');
        }
        if (StringUtils.isNotBlank((CharSequence)this.alternateLocation())) {
            builder.append(this.alternateLocation()).append(' ');
        } else {
            builder.append(". ");
        }
        builder.append(this.residueName()).append(' ');
        builder.append(this.chainIdentifier()).append(' ');
        builder.append(this.residueNumber()).append(' ');
        if (StringUtils.isNotBlank((CharSequence)this.insertionCode())) {
            builder.append(this.insertionCode()).append(' ');
        } else {
            builder.append("? ");
        }
        builder.append(this.x()).append(' ');
        builder.append(this.y()).append(' ');
        builder.append(this.z()).append(' ');
        builder.append(this.occupancy()).append(' ');
        builder.append(this.temperatureFactor()).append(' ');
        builder.append(this.elementSymbol()).append(' ');
        if (StringUtils.isNotBlank((CharSequence)this.charge())) {
            builder.append(this.charge()).append(' ');
        } else {
            builder.append('?');
        }
        return builder.toString();
    }

    public final String toPdb() {
        if (this.alternateLocation().length() != 1) {
            LOGGER.error("Field 'alternateLocation' is longer than 1 char. Only first letter will be taken");
        }
        if (this.chainIdentifier().length() != 1) {
            LOGGER.error("Field 'chainIdentifier' is longer than 1 char. Only first letter will be taken");
        }
        if (this.insertionCode().length() != 1) {
            LOGGER.error("Field 'insertionCode' is longer than 1 char. Only first letter will be taken");
        }
        String format = this.atomName().length() == 4 ? FORMAT_ATOM_4_CHARACTER : FORMAT;
        return String.format(Locale.US, format, this.serialNumber(), this.atomName(), Character.valueOf(this.alternateLocation().charAt(0)), this.residueName(), Character.valueOf(this.chainIdentifier().charAt(0)), this.residueNumber(), Character.valueOf(this.insertionCode().charAt(0)), this.x(), this.y(), this.z(), this.occupancy(), this.temperatureFactor(), this.elementSymbol(), this.charge());
    }

    public final Vector3D toVector3D() {
        return new Vector3D(this.x(), this.y(), this.z());
    }
}

