/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.ChainNumberICode;
import pl.poznan.put.pdb.PdbResidueIdentifier;

@ParametersAreNonnullByDefault
@Generated(from="PdbResidueIdentifier", generator="Immutables")
@Immutable
public final class ImmutablePdbResidueIdentifier
extends PdbResidueIdentifier {
    private final String chainIdentifier;
    private final int residueNumber;
    private final String insertionCode;

    private ImmutablePdbResidueIdentifier(String chainIdentifier, int residueNumber, String insertionCode) {
        this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
        this.residueNumber = residueNumber;
        this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
    }

    private ImmutablePdbResidueIdentifier(ImmutablePdbResidueIdentifier original, String chainIdentifier, int residueNumber, String insertionCode) {
        this.chainIdentifier = chainIdentifier;
        this.residueNumber = residueNumber;
        this.insertionCode = insertionCode;
    }

    @Override
    public String chainIdentifier() {
        return this.chainIdentifier;
    }

    @Override
    public int residueNumber() {
        return this.residueNumber;
    }

    @Override
    public String insertionCode() {
        return this.insertionCode;
    }

    public final ImmutablePdbResidueIdentifier withChainIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "chainIdentifier");
        if (this.chainIdentifier.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbResidueIdentifier(this, newValue, this.residueNumber, this.insertionCode);
    }

    public final ImmutablePdbResidueIdentifier withResidueNumber(int value) {
        if (this.residueNumber == value) {
            return this;
        }
        return new ImmutablePdbResidueIdentifier(this, this.chainIdentifier, value, this.insertionCode);
    }

    public final ImmutablePdbResidueIdentifier withInsertionCode(String value) {
        String newValue = Objects.requireNonNull(value, "insertionCode");
        if (this.insertionCode.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbResidueIdentifier(this, this.chainIdentifier, this.residueNumber, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePdbResidueIdentifier && this.equalTo((ImmutablePdbResidueIdentifier)another);
    }

    private boolean equalTo(ImmutablePdbResidueIdentifier another) {
        return this.chainIdentifier.equals(another.chainIdentifier) && this.residueNumber == another.residueNumber && this.insertionCode.equals(another.insertionCode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.chainIdentifier.hashCode();
        h += (h << 5) + this.residueNumber;
        h += (h << 5) + this.insertionCode.hashCode();
        return h;
    }

    public static ImmutablePdbResidueIdentifier of(String chainIdentifier, int residueNumber, String insertionCode) {
        return new ImmutablePdbResidueIdentifier(chainIdentifier, residueNumber, insertionCode);
    }

    public static ImmutablePdbResidueIdentifier copyOf(PdbResidueIdentifier instance) {
        if (instance instanceof ImmutablePdbResidueIdentifier) {
            return (ImmutablePdbResidueIdentifier)instance;
        }
        return ImmutablePdbResidueIdentifier.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PdbResidueIdentifier", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHAIN_IDENTIFIER = 1L;
        private static final long INIT_BIT_RESIDUE_NUMBER = 2L;
        private static final long INIT_BIT_INSERTION_CODE = 4L;
        private long initBits = 7L;
        @Nullable
        private String chainIdentifier;
        private int residueNumber;
        @Nullable
        private String insertionCode;

        private Builder() {
        }

        public final Builder from(PdbResidueIdentifier instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChainNumberICode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChainNumberICode instance;
            long bits = 0L;
            if (object instanceof PdbResidueIdentifier) {
                instance = (PdbResidueIdentifier)object;
                if ((bits & 2L) == 0L) {
                    this.insertionCode(((PdbResidueIdentifier)instance).insertionCode());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.residueNumber(((PdbResidueIdentifier)instance).residueNumber());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.chainIdentifier(((PdbResidueIdentifier)instance).chainIdentifier());
                    bits |= 4L;
                }
            }
            if (object instanceof ChainNumberICode) {
                instance = (ChainNumberICode)object;
                if ((bits & 2L) == 0L) {
                    this.insertionCode(instance.insertionCode());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.residueNumber(instance.residueNumber());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.chainIdentifier(instance.chainIdentifier());
                    bits |= 4L;
                }
            }
        }

        public final Builder chainIdentifier(String chainIdentifier) {
            this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder residueNumber(int residueNumber) {
            this.residueNumber = residueNumber;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder insertionCode(String insertionCode) {
            this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutablePdbResidueIdentifier build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePdbResidueIdentifier(null, this.chainIdentifier, this.residueNumber, this.insertionCode);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("chainIdentifier");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("residueNumber");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("insertionCode");
            }
            return "Cannot build PdbResidueIdentifier, some of required attributes are not set " + attributes;
        }
    }
}

