/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.ChainNumberICode;
import pl.poznan.put.pdb.PdbModresLine;

@ParametersAreNonnullByDefault
@Generated(from="PdbModresLine", generator="Immutables")
@Immutable
public final class ImmutablePdbModresLine
extends PdbModresLine {
    private final String idCode;
    private final String residueName;
    private final String chainIdentifier;
    private final int residueNumber;
    private final String insertionCode;
    private final String standardResidueName;
    private final String comment;

    private ImmutablePdbModresLine(String idCode, String residueName, String chainIdentifier, int residueNumber, String insertionCode, String standardResidueName, String comment) {
        this.idCode = Objects.requireNonNull(idCode, "idCode");
        this.residueName = Objects.requireNonNull(residueName, "residueName");
        this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
        this.residueNumber = residueNumber;
        this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
        this.standardResidueName = Objects.requireNonNull(standardResidueName, "standardResidueName");
        this.comment = Objects.requireNonNull(comment, "comment");
    }

    private ImmutablePdbModresLine(ImmutablePdbModresLine original, String idCode, String residueName, String chainIdentifier, int residueNumber, String insertionCode, String standardResidueName, String comment) {
        this.idCode = idCode;
        this.residueName = residueName;
        this.chainIdentifier = chainIdentifier;
        this.residueNumber = residueNumber;
        this.insertionCode = insertionCode;
        this.standardResidueName = standardResidueName;
        this.comment = comment;
    }

    @Override
    public String idCode() {
        return this.idCode;
    }

    @Override
    public String residueName() {
        return this.residueName;
    }

    @Override
    public String chainIdentifier() {
        return this.chainIdentifier;
    }

    @Override
    public int residueNumber() {
        return this.residueNumber;
    }

    @Override
    public String insertionCode() {
        return this.insertionCode;
    }

    @Override
    public String standardResidueName() {
        return this.standardResidueName;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public final ImmutablePdbModresLine withIdCode(String value) {
        String newValue = Objects.requireNonNull(value, "idCode");
        if (this.idCode.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbModresLine(this, newValue, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, this.standardResidueName, this.comment);
    }

    public final ImmutablePdbModresLine withResidueName(String value) {
        String newValue = Objects.requireNonNull(value, "residueName");
        if (this.residueName.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbModresLine(this, this.idCode, newValue, this.chainIdentifier, this.residueNumber, this.insertionCode, this.standardResidueName, this.comment);
    }

    public final ImmutablePdbModresLine withChainIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "chainIdentifier");
        if (this.chainIdentifier.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbModresLine(this, this.idCode, this.residueName, newValue, this.residueNumber, this.insertionCode, this.standardResidueName, this.comment);
    }

    public final ImmutablePdbModresLine withResidueNumber(int value) {
        if (this.residueNumber == value) {
            return this;
        }
        return new ImmutablePdbModresLine(this, this.idCode, this.residueName, this.chainIdentifier, value, this.insertionCode, this.standardResidueName, this.comment);
    }

    public final ImmutablePdbModresLine withInsertionCode(String value) {
        String newValue = Objects.requireNonNull(value, "insertionCode");
        if (this.insertionCode.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbModresLine(this, this.idCode, this.residueName, this.chainIdentifier, this.residueNumber, newValue, this.standardResidueName, this.comment);
    }

    public final ImmutablePdbModresLine withStandardResidueName(String value) {
        String newValue = Objects.requireNonNull(value, "standardResidueName");
        if (this.standardResidueName.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbModresLine(this, this.idCode, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, newValue, this.comment);
    }

    public final ImmutablePdbModresLine withComment(String value) {
        String newValue = Objects.requireNonNull(value, "comment");
        if (this.comment.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbModresLine(this, this.idCode, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, this.standardResidueName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePdbModresLine && this.equalTo((ImmutablePdbModresLine)another);
    }

    private boolean equalTo(ImmutablePdbModresLine another) {
        return this.idCode.equals(another.idCode) && this.residueName.equals(another.residueName) && this.chainIdentifier.equals(another.chainIdentifier) && this.residueNumber == another.residueNumber && this.insertionCode.equals(another.insertionCode) && this.standardResidueName.equals(another.standardResidueName) && this.comment.equals(another.comment);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.idCode.hashCode();
        h += (h << 5) + this.residueName.hashCode();
        h += (h << 5) + this.chainIdentifier.hashCode();
        h += (h << 5) + this.residueNumber;
        h += (h << 5) + this.insertionCode.hashCode();
        h += (h << 5) + this.standardResidueName.hashCode();
        h += (h << 5) + this.comment.hashCode();
        return h;
    }

    public static ImmutablePdbModresLine of(String idCode, String residueName, String chainIdentifier, int residueNumber, String insertionCode, String standardResidueName, String comment) {
        return new ImmutablePdbModresLine(idCode, residueName, chainIdentifier, residueNumber, insertionCode, standardResidueName, comment);
    }

    public static ImmutablePdbModresLine copyOf(PdbModresLine instance) {
        if (instance instanceof ImmutablePdbModresLine) {
            return (ImmutablePdbModresLine)instance;
        }
        return ImmutablePdbModresLine.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PdbModresLine", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID_CODE = 1L;
        private static final long INIT_BIT_RESIDUE_NAME = 2L;
        private static final long INIT_BIT_CHAIN_IDENTIFIER = 4L;
        private static final long INIT_BIT_RESIDUE_NUMBER = 8L;
        private static final long INIT_BIT_INSERTION_CODE = 16L;
        private static final long INIT_BIT_STANDARD_RESIDUE_NAME = 32L;
        private static final long INIT_BIT_COMMENT = 64L;
        private long initBits = 127L;
        @Nullable
        private String idCode;
        @Nullable
        private String residueName;
        @Nullable
        private String chainIdentifier;
        private int residueNumber;
        @Nullable
        private String insertionCode;
        @Nullable
        private String standardResidueName;
        @Nullable
        private String comment;

        private Builder() {
        }

        public final Builder from(ChainNumberICode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PdbModresLine instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChainNumberICode instance;
            long bits = 0L;
            if (object instanceof ChainNumberICode) {
                instance = (ChainNumberICode)object;
                if ((bits & 2L) == 0L) {
                    this.insertionCode(instance.insertionCode());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.residueNumber(instance.residueNumber());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.chainIdentifier(instance.chainIdentifier());
                    bits |= 4L;
                }
            }
            if (object instanceof PdbModresLine) {
                instance = (PdbModresLine)object;
                this.standardResidueName(((PdbModresLine)instance).standardResidueName());
                this.residueName(((PdbModresLine)instance).residueName());
                this.idCode(((PdbModresLine)instance).idCode());
                if ((bits & 1L) == 0L) {
                    this.residueNumber(((PdbModresLine)instance).residueNumber());
                    bits |= 1L;
                }
                this.comment(((PdbModresLine)instance).comment());
                if ((bits & 2L) == 0L) {
                    this.insertionCode(((PdbModresLine)instance).insertionCode());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.chainIdentifier(((PdbModresLine)instance).chainIdentifier());
                    bits |= 4L;
                }
            }
        }

        public final Builder idCode(String idCode) {
            this.idCode = Objects.requireNonNull(idCode, "idCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder residueName(String residueName) {
            this.residueName = Objects.requireNonNull(residueName, "residueName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder chainIdentifier(String chainIdentifier) {
            this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder residueNumber(int residueNumber) {
            this.residueNumber = residueNumber;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder insertionCode(String insertionCode) {
            this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder standardResidueName(String standardResidueName) {
            this.standardResidueName = Objects.requireNonNull(standardResidueName, "standardResidueName");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "comment");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutablePdbModresLine build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePdbModresLine(null, this.idCode, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, this.standardResidueName, this.comment);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("idCode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("residueName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("chainIdentifier");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("residueNumber");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("insertionCode");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("standardResidueName");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("comment");
            }
            return "Cannot build PdbModresLine, some of required attributes are not set " + attributes;
        }
    }
}

