/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.ChainNumberICode;
import pl.poznan.put.pdb.PdbAtomLine;

@ParametersAreNonnullByDefault
@Generated(from="PdbAtomLine", generator="Immutables")
@Immutable
public final class ImmutablePdbAtomLine
extends PdbAtomLine {
    private final int serialNumber;
    private final String atomName;
    private final String alternateLocation;
    private final String residueName;
    private final String chainIdentifier;
    private final int residueNumber;
    private final String insertionCode;
    private final double x;
    private final double y;
    private final double z;
    private final double occupancy;
    private final double temperatureFactor;
    private final String elementSymbol;
    private final String charge;

    private ImmutablePdbAtomLine(int serialNumber, String atomName, String alternateLocation, String residueName, String chainIdentifier, int residueNumber, String insertionCode, double x, double y, double z, double occupancy, double temperatureFactor, String elementSymbol, String charge) {
        this.serialNumber = serialNumber;
        this.atomName = Objects.requireNonNull(atomName, "atomName");
        this.alternateLocation = Objects.requireNonNull(alternateLocation, "alternateLocation");
        this.residueName = Objects.requireNonNull(residueName, "residueName");
        this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
        this.residueNumber = residueNumber;
        this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
        this.x = x;
        this.y = y;
        this.z = z;
        this.occupancy = occupancy;
        this.temperatureFactor = temperatureFactor;
        this.elementSymbol = Objects.requireNonNull(elementSymbol, "elementSymbol");
        this.charge = Objects.requireNonNull(charge, "charge");
    }

    private ImmutablePdbAtomLine(ImmutablePdbAtomLine original, int serialNumber, String atomName, String alternateLocation, String residueName, String chainIdentifier, int residueNumber, String insertionCode, double x, double y, double z, double occupancy, double temperatureFactor, String elementSymbol, String charge) {
        this.serialNumber = serialNumber;
        this.atomName = atomName;
        this.alternateLocation = alternateLocation;
        this.residueName = residueName;
        this.chainIdentifier = chainIdentifier;
        this.residueNumber = residueNumber;
        this.insertionCode = insertionCode;
        this.x = x;
        this.y = y;
        this.z = z;
        this.occupancy = occupancy;
        this.temperatureFactor = temperatureFactor;
        this.elementSymbol = elementSymbol;
        this.charge = charge;
    }

    @Override
    public int serialNumber() {
        return this.serialNumber;
    }

    @Override
    public String atomName() {
        return this.atomName;
    }

    @Override
    public String alternateLocation() {
        return this.alternateLocation;
    }

    @Override
    public String residueName() {
        return this.residueName;
    }

    @Override
    public String chainIdentifier() {
        return this.chainIdentifier;
    }

    @Override
    public int residueNumber() {
        return this.residueNumber;
    }

    @Override
    public String insertionCode() {
        return this.insertionCode;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public double occupancy() {
        return this.occupancy;
    }

    @Override
    public double temperatureFactor() {
        return this.temperatureFactor;
    }

    @Override
    public String elementSymbol() {
        return this.elementSymbol;
    }

    @Override
    public String charge() {
        return this.charge;
    }

    public final ImmutablePdbAtomLine withSerialNumber(int value) {
        if (this.serialNumber == value) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, value, this.atomName, this.alternateLocation, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, this.x, this.y, this.z, this.occupancy, this.temperatureFactor, this.elementSymbol, this.charge);
    }

    public final ImmutablePdbAtomLine withAtomName(String value) {
        String newValue = Objects.requireNonNull(value, "atomName");
        if (this.atomName.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, this.serialNumber, newValue, this.alternateLocation, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, this.x, this.y, this.z, this.occupancy, this.temperatureFactor, this.elementSymbol, this.charge);
    }

    public final ImmutablePdbAtomLine withAlternateLocation(String value) {
        String newValue = Objects.requireNonNull(value, "alternateLocation");
        if (this.alternateLocation.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, this.serialNumber, this.atomName, newValue, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, this.x, this.y, this.z, this.occupancy, this.temperatureFactor, this.elementSymbol, this.charge);
    }

    public final ImmutablePdbAtomLine withResidueName(String value) {
        String newValue = Objects.requireNonNull(value, "residueName");
        if (this.residueName.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, this.serialNumber, this.atomName, this.alternateLocation, newValue, this.chainIdentifier, this.residueNumber, this.insertionCode, this.x, this.y, this.z, this.occupancy, this.temperatureFactor, this.elementSymbol, this.charge);
    }

    public final ImmutablePdbAtomLine withChainIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "chainIdentifier");
        if (this.chainIdentifier.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, this.serialNumber, this.atomName, this.alternateLocation, this.residueName, newValue, this.residueNumber, this.insertionCode, this.x, this.y, this.z, this.occupancy, this.temperatureFactor, this.elementSymbol, this.charge);
    }

    public final ImmutablePdbAtomLine withResidueNumber(int value) {
        if (this.residueNumber == value) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, this.serialNumber, this.atomName, this.alternateLocation, this.residueName, this.chainIdentifier, value, this.insertionCode, this.x, this.y, this.z, this.occupancy, this.temperatureFactor, this.elementSymbol, this.charge);
    }

    public final ImmutablePdbAtomLine withInsertionCode(String value) {
        String newValue = Objects.requireNonNull(value, "insertionCode");
        if (this.insertionCode.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, this.serialNumber, this.atomName, this.alternateLocation, this.residueName, this.chainIdentifier, this.residueNumber, newValue, this.x, this.y, this.z, this.occupancy, this.temperatureFactor, this.elementSymbol, this.charge);
    }

    public final ImmutablePdbAtomLine withX(double value) {
        if (Double.doubleToLongBits(this.x) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, this.serialNumber, this.atomName, this.alternateLocation, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, value, this.y, this.z, this.occupancy, this.temperatureFactor, this.elementSymbol, this.charge);
    }

    public final ImmutablePdbAtomLine withY(double value) {
        if (Double.doubleToLongBits(this.y) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, this.serialNumber, this.atomName, this.alternateLocation, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, this.x, value, this.z, this.occupancy, this.temperatureFactor, this.elementSymbol, this.charge);
    }

    public final ImmutablePdbAtomLine withZ(double value) {
        if (Double.doubleToLongBits(this.z) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, this.serialNumber, this.atomName, this.alternateLocation, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, this.x, this.y, value, this.occupancy, this.temperatureFactor, this.elementSymbol, this.charge);
    }

    public final ImmutablePdbAtomLine withOccupancy(double value) {
        if (Double.doubleToLongBits(this.occupancy) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, this.serialNumber, this.atomName, this.alternateLocation, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, this.x, this.y, this.z, value, this.temperatureFactor, this.elementSymbol, this.charge);
    }

    public final ImmutablePdbAtomLine withTemperatureFactor(double value) {
        if (Double.doubleToLongBits(this.temperatureFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, this.serialNumber, this.atomName, this.alternateLocation, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, this.x, this.y, this.z, this.occupancy, value, this.elementSymbol, this.charge);
    }

    public final ImmutablePdbAtomLine withElementSymbol(String value) {
        String newValue = Objects.requireNonNull(value, "elementSymbol");
        if (this.elementSymbol.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, this.serialNumber, this.atomName, this.alternateLocation, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, this.x, this.y, this.z, this.occupancy, this.temperatureFactor, newValue, this.charge);
    }

    public final ImmutablePdbAtomLine withCharge(String value) {
        String newValue = Objects.requireNonNull(value, "charge");
        if (this.charge.equals(newValue)) {
            return this;
        }
        return new ImmutablePdbAtomLine(this, this.serialNumber, this.atomName, this.alternateLocation, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, this.x, this.y, this.z, this.occupancy, this.temperatureFactor, this.elementSymbol, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePdbAtomLine && this.equalTo((ImmutablePdbAtomLine)another);
    }

    private boolean equalTo(ImmutablePdbAtomLine another) {
        return this.atomName.equals(another.atomName) && this.residueName.equals(another.residueName) && this.chainIdentifier.equals(another.chainIdentifier) && this.residueNumber == another.residueNumber && this.insertionCode.equals(another.insertionCode) && Double.doubleToLongBits(this.x) == Double.doubleToLongBits(another.x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(another.y) && Double.doubleToLongBits(this.z) == Double.doubleToLongBits(another.z);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.atomName.hashCode();
        h += (h << 5) + this.residueName.hashCode();
        h += (h << 5) + this.chainIdentifier.hashCode();
        h += (h << 5) + this.residueNumber;
        h += (h << 5) + this.insertionCode.hashCode();
        h += (h << 5) + Double.hashCode(this.x);
        h += (h << 5) + Double.hashCode(this.y);
        h += (h << 5) + Double.hashCode(this.z);
        return h;
    }

    public static ImmutablePdbAtomLine of(int serialNumber, String atomName, String alternateLocation, String residueName, String chainIdentifier, int residueNumber, String insertionCode, double x, double y, double z, double occupancy, double temperatureFactor, String elementSymbol, String charge) {
        return new ImmutablePdbAtomLine(serialNumber, atomName, alternateLocation, residueName, chainIdentifier, residueNumber, insertionCode, x, y, z, occupancy, temperatureFactor, elementSymbol, charge);
    }

    public static ImmutablePdbAtomLine copyOf(PdbAtomLine instance) {
        if (instance instanceof ImmutablePdbAtomLine) {
            return (ImmutablePdbAtomLine)instance;
        }
        return ImmutablePdbAtomLine.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PdbAtomLine", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SERIAL_NUMBER = 1L;
        private static final long INIT_BIT_ATOM_NAME = 2L;
        private static final long INIT_BIT_ALTERNATE_LOCATION = 4L;
        private static final long INIT_BIT_RESIDUE_NAME = 8L;
        private static final long INIT_BIT_CHAIN_IDENTIFIER = 16L;
        private static final long INIT_BIT_RESIDUE_NUMBER = 32L;
        private static final long INIT_BIT_INSERTION_CODE = 64L;
        private static final long INIT_BIT_X = 128L;
        private static final long INIT_BIT_Y = 256L;
        private static final long INIT_BIT_Z = 512L;
        private static final long INIT_BIT_OCCUPANCY = 1024L;
        private static final long INIT_BIT_TEMPERATURE_FACTOR = 2048L;
        private static final long INIT_BIT_ELEMENT_SYMBOL = 4096L;
        private static final long INIT_BIT_CHARGE = 8192L;
        private long initBits = 16383L;
        private int serialNumber;
        @Nullable
        private String atomName;
        @Nullable
        private String alternateLocation;
        @Nullable
        private String residueName;
        @Nullable
        private String chainIdentifier;
        private int residueNumber;
        @Nullable
        private String insertionCode;
        private double x;
        private double y;
        private double z;
        private double occupancy;
        private double temperatureFactor;
        @Nullable
        private String elementSymbol;
        @Nullable
        private String charge;

        private Builder() {
        }

        public final Builder from(ChainNumberICode instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PdbAtomLine instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChainNumberICode instance;
            long bits = 0L;
            if (object instanceof ChainNumberICode) {
                instance = (ChainNumberICode)object;
                if ((bits & 1L) == 0L) {
                    this.insertionCode(instance.insertionCode());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.residueNumber(instance.residueNumber());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.chainIdentifier(instance.chainIdentifier());
                    bits |= 4L;
                }
            }
            if (object instanceof PdbAtomLine) {
                instance = (PdbAtomLine)object;
                this.elementSymbol(((PdbAtomLine)instance).elementSymbol());
                this.residueName(((PdbAtomLine)instance).residueName());
                this.serialNumber(((PdbAtomLine)instance).serialNumber());
                this.charge(((PdbAtomLine)instance).charge());
                this.occupancy(((PdbAtomLine)instance).occupancy());
                if ((bits & 1L) == 0L) {
                    this.insertionCode(((PdbAtomLine)instance).insertionCode());
                    bits |= 1L;
                }
                this.atomName(((PdbAtomLine)instance).atomName());
                this.temperatureFactor(((PdbAtomLine)instance).temperatureFactor());
                this.alternateLocation(((PdbAtomLine)instance).alternateLocation());
                if ((bits & 2L) == 0L) {
                    this.residueNumber(((PdbAtomLine)instance).residueNumber());
                    bits |= 2L;
                }
                this.x(((PdbAtomLine)instance).x());
                this.y(((PdbAtomLine)instance).y());
                this.z(((PdbAtomLine)instance).z());
                if ((bits & 4L) == 0L) {
                    this.chainIdentifier(((PdbAtomLine)instance).chainIdentifier());
                    bits |= 4L;
                }
            }
        }

        public final Builder serialNumber(int serialNumber) {
            this.serialNumber = serialNumber;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder atomName(String atomName) {
            this.atomName = Objects.requireNonNull(atomName, "atomName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder alternateLocation(String alternateLocation) {
            this.alternateLocation = Objects.requireNonNull(alternateLocation, "alternateLocation");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder residueName(String residueName) {
            this.residueName = Objects.requireNonNull(residueName, "residueName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder chainIdentifier(String chainIdentifier) {
            this.chainIdentifier = Objects.requireNonNull(chainIdentifier, "chainIdentifier");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder residueNumber(int residueNumber) {
            this.residueNumber = residueNumber;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder insertionCode(String insertionCode) {
            this.insertionCode = Objects.requireNonNull(insertionCode, "insertionCode");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder x(double x) {
            this.x = x;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder y(double y) {
            this.y = y;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder z(double z) {
            this.z = z;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder occupancy(double occupancy) {
            this.occupancy = occupancy;
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public final Builder temperatureFactor(double temperatureFactor) {
            this.temperatureFactor = temperatureFactor;
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        public final Builder elementSymbol(String elementSymbol) {
            this.elementSymbol = Objects.requireNonNull(elementSymbol, "elementSymbol");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        public final Builder charge(String charge) {
            this.charge = Objects.requireNonNull(charge, "charge");
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        public ImmutablePdbAtomLine build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePdbAtomLine(null, this.serialNumber, this.atomName, this.alternateLocation, this.residueName, this.chainIdentifier, this.residueNumber, this.insertionCode, this.x, this.y, this.z, this.occupancy, this.temperatureFactor, this.elementSymbol, this.charge);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serialNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("atomName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("alternateLocation");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("residueName");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("chainIdentifier");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("residueNumber");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("insertionCode");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("x");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("y");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("z");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("occupancy");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("temperatureFactor");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("elementSymbol");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("charge");
            }
            return "Cannot build PdbAtomLine, some of required attributes are not set " + attributes;
        }
    }
}

