/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.pdb;

import java.util.Arrays;

public enum ExperimentalTechnique {
    ELECTRON_CRYSTALLOGRAPHY("ELECTRON CRYSTALLOGRAPHY"),
    ELECTRON_MICROSCOPY("ELECTRON MICROSCOPY"),
    EPR("EPR"),
    FIBER_DIFFRACTION("FIBER DIFFRACTION"),
    FLUORESCENCE_TRANSFER("FLUORESCENCE TRANSFER"),
    INFRARED_SPECTROSCOPY("INFRARED SPECTROSCOPY"),
    NEUTRON_DIFFRACTION("NEUTRON DIFFRACTION"),
    POWDER_DIFFRACTION("POWDER DIFFRACTION"),
    SOLID_STATE_NMR("SOLID-STATE NMR"),
    SOLUTION_NMR("SOLUTION NMR"),
    SOLUTION_SCATTERING("SOLUTION SCATTERING"),
    THEORETICAL_MODEL("THEORETICAL MODEL"),
    X_RAY_DIFFRACTION("X-RAY DIFFRACTION"),
    UNKNOWN("UNKNOWN");

    private final String pdbName;

    private ExperimentalTechnique(String pdbName) {
        this.pdbName = pdbName;
    }

    public static ExperimentalTechnique fromFullName(String pdbName) {
        return Arrays.stream(ExperimentalTechnique.values()).filter(technique -> technique.pdbName.equalsIgnoreCase(pdbName)).findFirst().orElse(UNKNOWN);
    }

    public String getPdbName() {
        return this.pdbName;
    }
}

