/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.notation;

import java.util.Arrays;
import java.util.Objects;
import pl.poznan.put.structure.BasePair;

public enum Saenger {
    I,
    II,
    III,
    IV,
    V,
    VI,
    VII,
    VIII,
    IX,
    X,
    XI,
    XII,
    XIII,
    XIV,
    XV,
    XVI,
    XVII,
    XVIII,
    XIX,
    XX,
    XXI,
    XXII,
    XXIII,
    XXIV,
    XXV,
    XXVI,
    XXVII,
    XXVIII,
    UNKNOWN;


    public static Saenger fromString(String str) {
        return Arrays.stream(Saenger.values()).filter(saenger -> Objects.equals(saenger.toString(), str)).findFirst().orElse(UNKNOWN);
    }

    public static Saenger fromNumber(int number) {
        if (number >= 1 && number <= 28) {
            return Saenger.values()[number - 1];
        }
        return UNKNOWN;
    }

    public static Saenger assumeCanonical(BasePair basePair) {
        char l = Character.toUpperCase(basePair.left().oneLetterName());
        char r = Character.toUpperCase(basePair.right().oneLetterName());
        String pair = String.format("%c%c", Character.valueOf(l), Character.valueOf(r));
        if ("CG".equals(pair) || "GC".equals(pair)) {
            return XIX;
        }
        if ("AU".equals(pair) || "UA".equals(pair)) {
            return XX;
        }
        if ("GU".equals(pair) || "UG".equals(pair)) {
            return XXVIII;
        }
        return UNKNOWN;
    }

    public static boolean isCanonical(Saenger saenger) {
        return saenger == XIX || saenger == XX || saenger == XXVIII;
    }

    public String toString() {
        if (this == UNKNOWN) {
            return "n/a";
        }
        return this.name();
    }

    public boolean isCanonical() {
        return Saenger.isCanonical(this);
    }
}

