/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.notation;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import pl.poznan.put.notation.NucleobaseEdge;
import pl.poznan.put.notation.Stericity;

public enum LeontisWesthof {
    CWW(Stericity.CIS, NucleobaseEdge.WATSON_CRICK, NucleobaseEdge.WATSON_CRICK),
    CWH(Stericity.CIS, NucleobaseEdge.WATSON_CRICK, NucleobaseEdge.HOOGSTEEN),
    CWS(Stericity.CIS, NucleobaseEdge.WATSON_CRICK, NucleobaseEdge.SUGAR),
    CHW(Stericity.CIS, NucleobaseEdge.HOOGSTEEN, NucleobaseEdge.WATSON_CRICK),
    CHH(Stericity.CIS, NucleobaseEdge.HOOGSTEEN, NucleobaseEdge.HOOGSTEEN),
    CHS(Stericity.CIS, NucleobaseEdge.HOOGSTEEN, NucleobaseEdge.SUGAR),
    CSW(Stericity.CIS, NucleobaseEdge.SUGAR, NucleobaseEdge.WATSON_CRICK),
    CSH(Stericity.CIS, NucleobaseEdge.SUGAR, NucleobaseEdge.HOOGSTEEN),
    CSS(Stericity.CIS, NucleobaseEdge.SUGAR, NucleobaseEdge.SUGAR),
    TWW(Stericity.TRANS, NucleobaseEdge.WATSON_CRICK, NucleobaseEdge.WATSON_CRICK),
    TWH(Stericity.TRANS, NucleobaseEdge.WATSON_CRICK, NucleobaseEdge.HOOGSTEEN),
    TWS(Stericity.TRANS, NucleobaseEdge.WATSON_CRICK, NucleobaseEdge.SUGAR),
    THW(Stericity.TRANS, NucleobaseEdge.HOOGSTEEN, NucleobaseEdge.WATSON_CRICK),
    THH(Stericity.TRANS, NucleobaseEdge.HOOGSTEEN, NucleobaseEdge.HOOGSTEEN),
    THS(Stericity.TRANS, NucleobaseEdge.HOOGSTEEN, NucleobaseEdge.SUGAR),
    TSW(Stericity.TRANS, NucleobaseEdge.SUGAR, NucleobaseEdge.WATSON_CRICK),
    TSH(Stericity.TRANS, NucleobaseEdge.SUGAR, NucleobaseEdge.HOOGSTEEN),
    TSS(Stericity.TRANS, NucleobaseEdge.SUGAR, NucleobaseEdge.SUGAR),
    UNKNOWN(Stericity.UNKNOWN, NucleobaseEdge.UNKNOWN, NucleobaseEdge.UNKNOWN);

    private final Stericity stericity;
    private final NucleobaseEdge edge5;
    private final NucleobaseEdge edge3;

    private LeontisWesthof(Stericity stericity, NucleobaseEdge edge5, NucleobaseEdge edge3) {
        this.stericity = stericity;
        this.edge5 = edge5;
        this.edge3 = edge3;
    }

    public static LeontisWesthof fromNumber(int number) {
        switch (number) {
            case 1: {
                return CWW;
            }
            case 2: {
                return TWW;
            }
            case 3: {
                return CWH;
            }
            case 4: {
                return TWH;
            }
            case 5: {
                return CWS;
            }
            case 6: {
                return TWS;
            }
            case 7: {
                return CHH;
            }
            case 8: {
                return THH;
            }
            case 9: {
                return CHS;
            }
            case 10: {
                return THS;
            }
            case 11: {
                return CSS;
            }
            case 12: {
                return TSS;
            }
        }
        return UNKNOWN;
    }

    public static LeontisWesthof fromString(CharSequence input) {
        return Arrays.stream(LeontisWesthof.values()).filter(leontisWesthof -> StringUtils.equalsIgnoreCase((CharSequence)leontisWesthof.name(), (CharSequence)input)).findFirst().orElse(UNKNOWN);
    }

    private static String edgeName(char c) {
        switch (Character.toLowerCase(c)) {
            case 'c': {
                return "cis";
            }
            case 't': {
                return "trans";
            }
            case 'w': {
                return "Watson-Crick";
            }
            case 'h': {
                return "Hoogsteen";
            }
            case 's': {
                return "Sugar";
            }
        }
        throw new IllegalArgumentException(String.format("Letter %s is not recognized in Leontis-Westhof notation", Character.valueOf(c)));
    }

    public int toNumber() {
        switch (this) {
            case CWW: {
                return 1;
            }
            case TWW: {
                return 2;
            }
            case CWH: {
                return 3;
            }
            case TWH: {
                return 4;
            }
            case CWS: {
                return 5;
            }
            case TWS: {
                return 6;
            }
            case CHH: {
                return 7;
            }
            case THH: {
                return 8;
            }
            case CHS: {
                return 9;
            }
            case THS: {
                return 10;
            }
            case CSS: {
                return 11;
            }
            case TSS: {
                return 12;
            }
        }
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return this.shortName();
    }

    public String shortName() {
        if (this == UNKNOWN) {
            return "n/a";
        }
        char[] chars = this.name().toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public String fullName() {
        if (this == UNKNOWN) {
            return "n/a";
        }
        char[] cs = this.name().toCharArray();
        return String.format("%s%s/%s", LeontisWesthof.edgeName(cs[0]), LeontisWesthof.edgeName(cs[1]), LeontisWesthof.edgeName(cs[2]));
    }

    public LeontisWesthof invert() {
        if (this == UNKNOWN) {
            return UNKNOWN;
        }
        char[] chars = this.name().toCharArray();
        char tmp = chars[1];
        chars[1] = chars[2];
        chars[2] = tmp;
        return LeontisWesthof.fromString(new String(chars));
    }

    public Stericity stericity() {
        return this.stericity;
    }

    public NucleobaseEdge edge5() {
        return this.edge5;
    }

    public NucleobaseEdge edge3() {
        return this.edge3;
    }
}

