/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.external.dssr;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.immutables.value.Value;
import pl.poznan.put.external.dssr.ImmutableNucleotide;
import pl.poznan.put.pdb.ImmutablePdbNamedResidueIdentifier;
import pl.poznan.put.pdb.PdbNamedResidueIdentifier;

@JsonSerialize(as=ImmutableNucleotide.class)
@JsonDeserialize(as=ImmutableNucleotide.class)
@Value.Immutable
public interface Nucleotide {
    @JsonProperty(value="nt_id")
    public String id();

    @JsonProperty(value="chain_name")
    public String chainName();

    @JsonProperty(value="nt_code")
    public String oneLetterName();

    @JsonProperty(value="nt_resnum")
    public int residueNumber();

    default public PdbNamedResidueIdentifier toNamedResidueIdentifer() {
        String[] split = this.id().split("\\^");
        return ImmutablePdbNamedResidueIdentifier.of(this.chainName(), this.residueNumber(), split.length == 1 ? " " : split[1], this.oneLetterName().charAt(0));
    }
}

