/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.external.dssr;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.external.dssr.Nucleotide;

@ParametersAreNonnullByDefault
@Generated(from="Nucleotide", generator="Immutables")
@Immutable
public final class ImmutableNucleotide
implements Nucleotide {
    private final String id;
    private final String chainName;
    private final String oneLetterName;
    private final int residueNumber;

    private ImmutableNucleotide(String id, String chainName, String oneLetterName, int residueNumber) {
        this.id = id;
        this.chainName = chainName;
        this.oneLetterName = oneLetterName;
        this.residueNumber = residueNumber;
    }

    @Override
    @JsonProperty(value="nt_id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="chain_name")
    public String chainName() {
        return this.chainName;
    }

    @Override
    @JsonProperty(value="nt_code")
    public String oneLetterName() {
        return this.oneLetterName;
    }

    @Override
    @JsonProperty(value="nt_resnum")
    public int residueNumber() {
        return this.residueNumber;
    }

    public final ImmutableNucleotide withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableNucleotide(newValue, this.chainName, this.oneLetterName, this.residueNumber);
    }

    public final ImmutableNucleotide withChainName(String value) {
        String newValue = Objects.requireNonNull(value, "chainName");
        if (this.chainName.equals(newValue)) {
            return this;
        }
        return new ImmutableNucleotide(this.id, newValue, this.oneLetterName, this.residueNumber);
    }

    public final ImmutableNucleotide withOneLetterName(String value) {
        String newValue = Objects.requireNonNull(value, "oneLetterName");
        if (this.oneLetterName.equals(newValue)) {
            return this;
        }
        return new ImmutableNucleotide(this.id, this.chainName, newValue, this.residueNumber);
    }

    public final ImmutableNucleotide withResidueNumber(int value) {
        if (this.residueNumber == value) {
            return this;
        }
        return new ImmutableNucleotide(this.id, this.chainName, this.oneLetterName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNucleotide && this.equalTo((ImmutableNucleotide)another);
    }

    private boolean equalTo(ImmutableNucleotide another) {
        return this.id.equals(another.id) && this.chainName.equals(another.chainName) && this.oneLetterName.equals(another.oneLetterName) && this.residueNumber == another.residueNumber;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.chainName.hashCode();
        h += (h << 5) + this.oneLetterName.hashCode();
        h += (h << 5) + this.residueNumber;
        return h;
    }

    public String toString() {
        return "Nucleotide{id=" + this.id + ", chainName=" + this.chainName + ", oneLetterName=" + this.oneLetterName + ", residueNumber=" + this.residueNumber + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNucleotide fromJson(Json json) {
        Builder builder = ImmutableNucleotide.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.chainName != null) {
            builder.chainName(json.chainName);
        }
        if (json.oneLetterName != null) {
            builder.oneLetterName(json.oneLetterName);
        }
        if (json.residueNumberIsSet) {
            builder.residueNumber(json.residueNumber);
        }
        return builder.build();
    }

    public static ImmutableNucleotide copyOf(Nucleotide instance) {
        if (instance instanceof ImmutableNucleotide) {
            return (ImmutableNucleotide)instance;
        }
        return ImmutableNucleotide.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Nucleotide", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CHAIN_NAME = 2L;
        private static final long INIT_BIT_ONE_LETTER_NAME = 4L;
        private static final long INIT_BIT_RESIDUE_NUMBER = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String chainName;
        @Nullable
        private String oneLetterName;
        private int residueNumber;

        private Builder() {
        }

        public final Builder from(Nucleotide instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.chainName(instance.chainName());
            this.oneLetterName(instance.oneLetterName());
            this.residueNumber(instance.residueNumber());
            return this;
        }

        @JsonProperty(value="nt_id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="chain_name")
        public final Builder chainName(String chainName) {
            this.chainName = Objects.requireNonNull(chainName, "chainName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="nt_code")
        public final Builder oneLetterName(String oneLetterName) {
            this.oneLetterName = Objects.requireNonNull(oneLetterName, "oneLetterName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="nt_resnum")
        public final Builder residueNumber(int residueNumber) {
            this.residueNumber = residueNumber;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableNucleotide build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNucleotide(this.id, this.chainName, this.oneLetterName, this.residueNumber);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("chainName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("oneLetterName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("residueNumber");
            }
            return "Cannot build Nucleotide, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Nucleotide", generator="Immutables")
    static final class Json
    implements Nucleotide {
        @Nullable
        String id;
        @Nullable
        String chainName;
        @Nullable
        String oneLetterName;
        int residueNumber;
        boolean residueNumberIsSet;

        Json() {
        }

        @JsonProperty(value="nt_id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="chain_name")
        public void setChainName(String chainName) {
            this.chainName = chainName;
        }

        @JsonProperty(value="nt_code")
        public void setOneLetterName(String oneLetterName) {
            this.oneLetterName = oneLetterName;
        }

        @JsonProperty(value="nt_resnum")
        public void setResidueNumber(int residueNumber) {
            this.residueNumber = residueNumber;
            this.residueNumberIsSet = true;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String chainName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String oneLetterName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int residueNumber() {
            throw new UnsupportedOperationException();
        }
    }
}

