/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.external.dssr;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.external.dssr.DssrJson;
import pl.poznan.put.external.dssr.Nucleotide;
import pl.poznan.put.external.dssr.Pair;

@ParametersAreNonnullByDefault
@Generated(from="DssrJson", generator="Immutables")
@Immutable
public final class ImmutableDssrJson
extends DssrJson {
    private final List<Pair> pairs;
    private final List<Nucleotide> nucleotides;
    private volatile transient long lazyInitBitmap;
    private static final long ID_NUCLEOTIDE_MAP_LAZY_INIT_BIT = 1L;
    private transient Map<String, Nucleotide> idNucleotideMap;

    private ImmutableDssrJson(List<Pair> pairs, List<Nucleotide> nucleotides) {
        this.pairs = pairs;
        this.nucleotides = nucleotides;
    }

    @Override
    @JsonProperty(value="pairs")
    public List<Pair> pairs() {
        return this.pairs;
    }

    @Override
    @JsonProperty(value="nts")
    public List<Nucleotide> nucleotides() {
        return this.nucleotides;
    }

    public final ImmutableDssrJson withPairs(Pair ... elements) {
        List<Pair> newValue = ImmutableDssrJson.createUnmodifiableList(false, ImmutableDssrJson.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDssrJson(newValue, this.nucleotides);
    }

    public final ImmutableDssrJson withPairs(Iterable<? extends Pair> elements) {
        if (this.pairs == elements) {
            return this;
        }
        List<Pair> newValue = ImmutableDssrJson.createUnmodifiableList(false, ImmutableDssrJson.createSafeList(elements, true, false));
        return new ImmutableDssrJson(newValue, this.nucleotides);
    }

    public final ImmutableDssrJson withNucleotides(Nucleotide ... elements) {
        List<Nucleotide> newValue = ImmutableDssrJson.createUnmodifiableList(false, ImmutableDssrJson.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableDssrJson(this.pairs, newValue);
    }

    public final ImmutableDssrJson withNucleotides(Iterable<? extends Nucleotide> elements) {
        if (this.nucleotides == elements) {
            return this;
        }
        List<Nucleotide> newValue = ImmutableDssrJson.createUnmodifiableList(false, ImmutableDssrJson.createSafeList(elements, true, false));
        return new ImmutableDssrJson(this.pairs, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDssrJson && this.equalTo((ImmutableDssrJson)another);
    }

    private boolean equalTo(ImmutableDssrJson another) {
        return this.pairs.equals(another.pairs) && this.nucleotides.equals(another.nucleotides);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pairs.hashCode();
        h += (h << 5) + this.nucleotides.hashCode();
        return h;
    }

    public String toString() {
        return "DssrJson{pairs=" + this.pairs + ", nucleotides=" + this.nucleotides + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDssrJson fromJson(Json json) {
        Builder builder = ImmutableDssrJson.builder();
        if (json.pairs != null) {
            builder.addAllPairs(json.pairs);
        }
        if (json.nucleotides != null) {
            builder.addAllNucleotides(json.nucleotides);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Nucleotide> idNucleotideMap() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableDssrJson immutableDssrJson = this;
            synchronized (immutableDssrJson) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.idNucleotideMap = Objects.requireNonNull(super.idNucleotideMap(), "idNucleotideMap");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.idNucleotideMap;
    }

    public static ImmutableDssrJson copyOf(DssrJson instance) {
        if (instance instanceof ImmutableDssrJson) {
            return (ImmutableDssrJson)instance;
        }
        return ImmutableDssrJson.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="DssrJson", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Pair> pairs = new ArrayList<Pair>();
        private List<Nucleotide> nucleotides = new ArrayList<Nucleotide>();

        private Builder() {
        }

        public final Builder from(DssrJson instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllPairs(instance.pairs());
            this.addAllNucleotides(instance.nucleotides());
            return this;
        }

        public final Builder addPairs(Pair element) {
            this.pairs.add(Objects.requireNonNull(element, "pairs element"));
            return this;
        }

        public final Builder addPairs(Pair ... elements) {
            for (Pair element : elements) {
                this.pairs.add(Objects.requireNonNull(element, "pairs element"));
            }
            return this;
        }

        @JsonProperty(value="pairs")
        public final Builder pairs(Iterable<? extends Pair> elements) {
            this.pairs.clear();
            return this.addAllPairs(elements);
        }

        public final Builder addAllPairs(Iterable<? extends Pair> elements) {
            for (Pair pair : elements) {
                this.pairs.add(Objects.requireNonNull(pair, "pairs element"));
            }
            return this;
        }

        public final Builder addNucleotides(Nucleotide element) {
            this.nucleotides.add(Objects.requireNonNull(element, "nucleotides element"));
            return this;
        }

        public final Builder addNucleotides(Nucleotide ... elements) {
            for (Nucleotide element : elements) {
                this.nucleotides.add(Objects.requireNonNull(element, "nucleotides element"));
            }
            return this;
        }

        @JsonProperty(value="nts")
        public final Builder nucleotides(Iterable<? extends Nucleotide> elements) {
            this.nucleotides.clear();
            return this.addAllNucleotides(elements);
        }

        public final Builder addAllNucleotides(Iterable<? extends Nucleotide> elements) {
            for (Nucleotide nucleotide : elements) {
                this.nucleotides.add(Objects.requireNonNull(nucleotide, "nucleotides element"));
            }
            return this;
        }

        public ImmutableDssrJson build() {
            return new ImmutableDssrJson(ImmutableDssrJson.createUnmodifiableList(true, this.pairs), ImmutableDssrJson.createUnmodifiableList(true, this.nucleotides));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DssrJson", generator="Immutables")
    static final class Json
    extends DssrJson {
        @Nullable
        List<Pair> pairs = Collections.emptyList();
        @Nullable
        List<Nucleotide> nucleotides = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="pairs")
        public void setPairs(List<Pair> pairs) {
            this.pairs = pairs;
        }

        @JsonProperty(value="nts")
        public void setNucleotides(List<Nucleotide> nucleotides) {
            this.nucleotides = nucleotides;
        }

        @Override
        public List<Pair> pairs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Nucleotide> nucleotides() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Map<String, Nucleotide> idNucleotideMap() {
            throw new UnsupportedOperationException();
        }
    }
}

