/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.external.dssr;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import pl.poznan.put.external.dssr.ImmutableDssrJson;
import pl.poznan.put.external.dssr.Nucleotide;
import pl.poznan.put.external.dssr.Pair;

@JsonSerialize(as=ImmutableDssrJson.class)
@JsonDeserialize(as=ImmutableDssrJson.class)
@Value.Immutable
public abstract class DssrJson {
    public abstract List<Pair> pairs();

    @JsonProperty(value="nts")
    public abstract List<Nucleotide> nucleotides();

    @Value.Lazy
    protected Map<String, Nucleotide> idNucleotideMap() {
        return this.nucleotides().stream().collect(Collectors.toMap(Nucleotide::id, Function.identity()));
    }

    public final Nucleotide findNucleotide(String id) {
        return this.idNucleotideMap().get(id);
    }
}

