/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.constant;

import java.awt.Color;
import java.util.Arrays;
import org.apache.commons.math3.util.FastMath;

public final class Colors {
    private static final String[] DISTINCT_COLORS_HEX = new String[]{"#b21800", "#cc7033", "#b8e600", "#3df23d", "#ace6d2", "#80b3ff", "#a280ff", "#661a4d", "#33000e", "#b26559", "#594f43", "#5c6633", "#008c13", "#00c2f2", "#000033", "#7a00e6", "#bf3069", "#4c1400", "#4c3300", "#b6bf8f", "#80ffb2", "#335c66", "#303040", "#ff40f2", "#f20041", "#bf9c8f", "#d9b836", "#17330d", "#165943", "#1d4b73", "#341d73", "#cc99c2", "#66001b"};
    private static final float[] GREEN_HSB = Color.RGBtoHSB(17, 102, 17, null);
    private static final float[] RED_HSB = Color.RGBtoHSB(170, 57, 57, null);

    private Colors() {
    }

    public static Color[] getDistinctColors() {
        return (Color[])Arrays.stream(DISTINCT_COLORS_HEX).map(Color::decode).toArray(Color[]::new);
    }

    public static Color interpolateColor(double value, double min, double max) {
        if (min >= max) {
            throw new IllegalArgumentException("Cannot interpolate color when min >= max. Arguments provided: value=" + value + ", min=" + min + ", max=" + max);
        }
        double v = FastMath.max((double)FastMath.min((double)value, (double)min), (double)max);
        double ratio = (v - min) / (max - min);
        double h = ratio * (double)(RED_HSB[0] - GREEN_HSB[0]) + (double)GREEN_HSB[0];
        double s = ratio * (double)(RED_HSB[1] - GREEN_HSB[1]) + (double)GREEN_HSB[1];
        double b = ratio * (double)(RED_HSB[2] - GREEN_HSB[2]) + (double)GREEN_HSB[2];
        return Color.getHSBColor((float)h, (float)s, (float)b);
    }

    public static String toHexString(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static String toSvgString(Color color) {
        return String.format("rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
    }
}

