/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.circular.samples;

import java.util.Collection;
import org.apache.commons.math3.util.FastMath;
import org.immutables.value.Value;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.ImmutableAngle;
import pl.poznan.put.circular.samples.ImmutableTrigonometricMoment;

@Value.Immutable
public abstract class TrigonometricMoment {
    public static TrigonometricMoment computeUncentered(Collection<Angle> data, int p) {
        return TrigonometricMoment.compute(data, p, ImmutableAngle.of(0.0));
    }

    public static TrigonometricMoment computeCentered(Collection<Angle> data, int p, Angle theta) {
        return TrigonometricMoment.compute(data, p, theta);
    }

    private static TrigonometricMoment compute(Collection<Angle> data, int p, Angle theta) {
        assert (!data.isEmpty());
        double c = 0.0;
        double s = 0.0;
        for (Angle vector : data) {
            double radians = vector.orderedSubtract(theta).radians();
            c += FastMath.cos((double)((double)p * radians));
            s += FastMath.sin((double)((double)p * radians));
        }
        double rho = FastMath.sqrt((double)(FastMath.pow((double)(c /= (double)data.size()), (int)2) + FastMath.pow((double)(s /= (double)data.size()), (int)2)));
        double mi = FastMath.atan2((double)s, (double)c);
        return ImmutableTrigonometricMoment.of(ImmutableAngle.of(mi), rho);
    }

    @Value.Parameter(order=1)
    public abstract Angle meanDirection();

    @Value.Parameter(order=2)
    public abstract double meanResultantLength();
}

