/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.circular.samples;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.samples.TrigonometricMoment;

@ParametersAreNonnullByDefault
@Generated(from="TrigonometricMoment", generator="Immutables")
@Immutable
public final class ImmutableTrigonometricMoment
extends TrigonometricMoment {
    private final Angle meanDirection;
    private final double meanResultantLength;

    private ImmutableTrigonometricMoment(Angle meanDirection, double meanResultantLength) {
        this.meanDirection = Objects.requireNonNull(meanDirection, "meanDirection");
        this.meanResultantLength = meanResultantLength;
    }

    private ImmutableTrigonometricMoment(ImmutableTrigonometricMoment original, Angle meanDirection, double meanResultantLength) {
        this.meanDirection = meanDirection;
        this.meanResultantLength = meanResultantLength;
    }

    @Override
    public Angle meanDirection() {
        return this.meanDirection;
    }

    @Override
    public double meanResultantLength() {
        return this.meanResultantLength;
    }

    public final ImmutableTrigonometricMoment withMeanDirection(Angle value) {
        if (this.meanDirection == value) {
            return this;
        }
        Angle newValue = Objects.requireNonNull(value, "meanDirection");
        return new ImmutableTrigonometricMoment(this, newValue, this.meanResultantLength);
    }

    public final ImmutableTrigonometricMoment withMeanResultantLength(double value) {
        if (Double.doubleToLongBits(this.meanResultantLength) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableTrigonometricMoment(this, this.meanDirection, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTrigonometricMoment && this.equalTo((ImmutableTrigonometricMoment)another);
    }

    private boolean equalTo(ImmutableTrigonometricMoment another) {
        return this.meanDirection.equals(another.meanDirection) && Double.doubleToLongBits(this.meanResultantLength) == Double.doubleToLongBits(another.meanResultantLength);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.meanDirection.hashCode();
        h += (h << 5) + Double.hashCode(this.meanResultantLength);
        return h;
    }

    public String toString() {
        return "TrigonometricMoment{meanDirection=" + this.meanDirection + ", meanResultantLength=" + this.meanResultantLength + "}";
    }

    public static ImmutableTrigonometricMoment of(Angle meanDirection, double meanResultantLength) {
        return new ImmutableTrigonometricMoment(meanDirection, meanResultantLength);
    }

    public static ImmutableTrigonometricMoment copyOf(TrigonometricMoment instance) {
        if (instance instanceof ImmutableTrigonometricMoment) {
            return (ImmutableTrigonometricMoment)instance;
        }
        return ImmutableTrigonometricMoment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TrigonometricMoment", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MEAN_DIRECTION = 1L;
        private static final long INIT_BIT_MEAN_RESULTANT_LENGTH = 2L;
        private long initBits = 3L;
        @Nullable
        private Angle meanDirection;
        private double meanResultantLength;

        private Builder() {
        }

        public final Builder from(TrigonometricMoment instance) {
            Objects.requireNonNull(instance, "instance");
            this.meanDirection(instance.meanDirection());
            this.meanResultantLength(instance.meanResultantLength());
            return this;
        }

        public final Builder meanDirection(Angle meanDirection) {
            this.meanDirection = Objects.requireNonNull(meanDirection, "meanDirection");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder meanResultantLength(double meanResultantLength) {
            this.meanResultantLength = meanResultantLength;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTrigonometricMoment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTrigonometricMoment(null, this.meanDirection, this.meanResultantLength);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("meanDirection");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("meanResultantLength");
            }
            return "Cannot build TrigonometricMoment, some of required attributes are not set " + attributes;
        }
    }
}

