/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.circular.samples;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.util.FastMath;
import org.immutables.value.Value;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.ImmutableAngle;
import pl.poznan.put.circular.exception.InvalidCircularOperationException;
import pl.poznan.put.circular.samples.TrigonometricMoment;

@Value.Immutable
public abstract class AngleSample {
    @Value.Parameter(order=1)
    public abstract Collection<Angle> data();

    @Value.Lazy
    public Angle meanDirection() {
        return this.um1().meanDirection();
    }

    @Value.Lazy
    public double meanResultantLength() {
        return this.um1().meanResultantLength();
    }

    @Value.Lazy
    public double circularVariance() {
        return 1.0 - this.meanResultantLength();
    }

    @Value.Lazy
    public double circularStandardDeviation() {
        return FastMath.sqrt((double)(-2.0 * FastMath.log((double)this.meanResultantLength())));
    }

    @Value.Lazy
    public double circularDispersion() {
        return (1.0 - this.cm2().meanResultantLength()) / (2.0 * FastMath.pow((double)this.meanResultantLength(), (int)2));
    }

    @Value.Lazy
    public double skewness() {
        return this.cm2().meanResultantLength() * FastMath.sin((double)this.cm2().meanDirection().subtract(this.meanDirection().multiply(2.0)).radians()) / FastMath.sqrt((double)this.circularVariance());
    }

    @Value.Lazy
    public double kurtosis() {
        return (this.cm2().meanResultantLength() * FastMath.cos((double)this.um2().meanDirection().subtract(this.meanDirection().multiply(2.0)).radians()) - FastMath.pow((double)this.meanResultantLength(), (int)4)) / FastMath.pow((double)this.circularVariance(), (int)2);
    }

    @Value.Lazy
    public Angle medianDirection() {
        return (Angle)this.medianAndMeanDeviation().getKey();
    }

    @Value.Lazy
    public double meanDeviation() {
        return (Double)this.medianAndMeanDeviation().getValue();
    }

    public double circularRank(Angle datapoint) {
        if (!this.sortedData().contains(datapoint)) {
            throw new InvalidCircularOperationException("Cannot calculate circular rank for an observation outside the sample range");
        }
        int rank = this.sortedData().indexOf(datapoint) + 1;
        return Math.PI * 2 * (double)rank / (double)this.sortedData().size();
    }

    public String toString() {
        return "AngleSample [meanDirection=" + this.meanDirection() + ", meanResultantLength=" + this.meanResultantLength() + ", circularVariance=" + this.circularVariance() + ", circularStandardDeviation=" + this.circularStandardDeviation() + ", circularDispersion=" + this.circularDispersion() + ", skewness=" + this.skewness() + ", kurtosis=" + this.kurtosis() + ", medianDirection=" + this.medianDirection() + ", meanDeviation=" + this.meanDeviation() + ']';
    }

    @Value.Check
    protected void check() {
        Validate.notEmpty(this.data());
    }

    @Value.Lazy
    protected Pair<Angle, Double> medianAndMeanDeviation() {
        List<Angle> candidates = this.sortedData().size() % 2 == 1 ? this.sortedData() : this.computeMiddlePoints();
        double minDeviation = Double.POSITIVE_INFINITY;
        Angle minCandidate = candidates.get(0);
        for (Angle candidate : candidates) {
            ImmutableAngle candidateAlternative;
            double deviationAlternative;
            double deviation = this.computeMeanDeviation(candidate);
            if (deviation < minDeviation) {
                minDeviation = deviation;
                minCandidate = candidate;
            }
            if (!((deviationAlternative = this.computeMeanDeviation(candidateAlternative = ImmutableAngle.of(candidate.radians() + Math.PI))) < minDeviation)) continue;
            minDeviation = deviationAlternative;
            minCandidate = candidateAlternative;
        }
        return Pair.of((Object)minCandidate, (Object)minDeviation);
    }

    @Value.Lazy
    protected List<Angle> sortedData() {
        return this.data().stream().sorted().collect(Collectors.toList());
    }

    @Value.Lazy
    protected TrigonometricMoment um1() {
        return TrigonometricMoment.computeUncentered(this.data(), 1);
    }

    @Value.Lazy
    protected TrigonometricMoment cm2() {
        return TrigonometricMoment.computeCentered(this.data(), 2, this.meanDirection());
    }

    @Value.Lazy
    protected TrigonometricMoment um2() {
        return TrigonometricMoment.computeUncentered(this.data(), 2);
    }

    private double computeMeanDeviation(Angle alpha) {
        return this.data().stream().mapToDouble(angle -> angle.subtract(alpha).radians()).reduce(Double::sum).orElse(Double.NaN) / (double)this.data().size();
    }

    private List<Angle> computeMiddlePoints() {
        ArrayList<Angle> middlePoints = new ArrayList<Angle>();
        for (int i = 1; i < this.sortedData().size(); ++i) {
            Angle begin = this.sortedData().get(i - 1);
            Angle end = this.sortedData().get(i);
            ImmutableAngle middle = ImmutableAngle.of((begin.radians() + end.radians()) / 2.0);
            middlePoints.add(middle);
        }
        Angle last = this.sortedData().get(this.sortedData().size() - 1);
        Angle first = this.sortedData().get(0);
        ImmutableAngle middle = ImmutableAngle.of((last.radians() + first.radians()) / 2.0);
        middlePoints.add(middle);
        return middlePoints;
    }
}

