/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.circular.conversion;

import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import org.apache.commons.math3.geometry.euclidean.threed.Plane;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import pl.poznan.put.circular.Angle;

public final class CartesianUtilities {
    private CartesianUtilities() {
    }

    public static Vector3D nextPlacement(Vector3D coordA, Vector3D coordB, Vector3D coordC, double lengthCD, Angle angleBCD, Angle torsionABCD) {
        Vector3D vectorBC = coordC.subtract((Vector)coordB);
        Vector3D unitBC = vectorBC.normalize();
        Plane plane = new Plane(coordC, coordB, coordA, 0.001);
        Rotation rotationFirst = new Rotation(plane.getNormal().normalize(), angleBCD.radians(), RotationConvention.VECTOR_OPERATOR);
        Rotation rotationSecond = new Rotation(unitBC, torsionABCD.radians(), RotationConvention.VECTOR_OPERATOR);
        Vector3D coordD0 = CartesianUtilities.coordD0((Vector<Euclidean3D>)coordB, (Vector<Euclidean3D>)coordC, lengthCD);
        Vector3D coordD1 = rotationFirst.applyTo(coordD0);
        Vector3D coordD2 = rotationSecond.applyTo(coordD1);
        return coordD2.add((Vector)coordC);
    }

    private static Vector3D coordD0(Vector<Euclidean3D> coordB, Vector<Euclidean3D> coordC, double lengthCD) {
        return (Vector3D)coordB.subtract(coordC).normalize().scalarMultiply(lengthCD);
    }
}

