/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.circular;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.Histogram;

@ParametersAreNonnullByDefault
@Generated(from="Histogram", generator="Immutables")
@Immutable
public final class ImmutableHistogram
extends Histogram {
    private final Collection<Angle> data;
    private final double binWidth;
    private volatile transient long lazyInitBitmap;
    private static final long BINS_LAZY_INIT_BIT = 1L;
    private transient Collection<Histogram.Bin> bins;

    private ImmutableHistogram(Collection<Angle> data, double binWidth) {
        this.data = Objects.requireNonNull(data, "data");
        this.binWidth = binWidth;
    }

    private ImmutableHistogram(ImmutableHistogram original, Collection<Angle> data, double binWidth) {
        this.data = data;
        this.binWidth = binWidth;
    }

    @Override
    public Collection<Angle> data() {
        return this.data;
    }

    @Override
    public double binWidth() {
        return this.binWidth;
    }

    public final ImmutableHistogram withData(Collection<Angle> value) {
        if (this.data == value) {
            return this;
        }
        Collection<Angle> newValue = Objects.requireNonNull(value, "data");
        return ImmutableHistogram.validate(new ImmutableHistogram(this, newValue, this.binWidth));
    }

    public final ImmutableHistogram withBinWidth(double value) {
        if (Double.doubleToLongBits(this.binWidth) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableHistogram.validate(new ImmutableHistogram(this, this.data, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHistogram && this.equalTo((ImmutableHistogram)another);
    }

    private boolean equalTo(ImmutableHistogram another) {
        return this.data.equals(another.data) && Double.doubleToLongBits(this.binWidth) == Double.doubleToLongBits(another.binWidth);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.data.hashCode();
        h += (h << 5) + Double.hashCode(this.binWidth);
        return h;
    }

    public String toString() {
        return "Histogram{data=" + this.data + ", binWidth=" + this.binWidth + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<Histogram.Bin> bins() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableHistogram immutableHistogram = this;
            synchronized (immutableHistogram) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.bins = Objects.requireNonNull(super.bins(), "bins");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.bins;
    }

    public static ImmutableHistogram of(Collection<Angle> data, double binWidth) {
        return ImmutableHistogram.validate(new ImmutableHistogram(data, binWidth));
    }

    private static ImmutableHistogram validate(ImmutableHistogram instance) {
        instance.check();
        return instance;
    }

    public static ImmutableHistogram copyOf(Histogram instance) {
        if (instance instanceof ImmutableHistogram) {
            return (ImmutableHistogram)instance;
        }
        return ImmutableHistogram.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Histogram", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATA = 1L;
        private static final long INIT_BIT_BIN_WIDTH = 2L;
        private long initBits = 3L;
        @Nullable
        private Collection<Angle> data;
        private double binWidth;

        private Builder() {
        }

        public final Builder from(Histogram instance) {
            Objects.requireNonNull(instance, "instance");
            this.data(instance.data());
            this.binWidth(instance.binWidth());
            return this;
        }

        public final Builder data(Collection<Angle> data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder binWidth(double binWidth) {
            this.binWidth = binWidth;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableHistogram build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableHistogram.validate(new ImmutableHistogram(null, this.data, this.binWidth));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("data");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("binWidth");
            }
            return "Cannot build Histogram, some of required attributes are not set " + attributes;
        }
    }
}

