/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.circular;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.Histogram;

@ParametersAreNonnullByDefault
@Generated(from="Histogram.Bin", generator="Immutables")
@Immutable
final class ImmutableBin
implements Histogram.Bin {
    private final double radiansStart;
    private final List<Angle> data;

    private ImmutableBin(double radiansStart, Iterable<? extends Angle> data) {
        this.radiansStart = radiansStart;
        this.data = ImmutableBin.createUnmodifiableList(false, ImmutableBin.createSafeList(data, true, false));
    }

    private ImmutableBin(ImmutableBin original, double radiansStart, List<Angle> data) {
        this.radiansStart = radiansStart;
        this.data = data;
    }

    @Override
    public double radiansStart() {
        return this.radiansStart;
    }

    @Override
    public List<Angle> data() {
        return this.data;
    }

    public final ImmutableBin withRadiansStart(double value) {
        if (Double.doubleToLongBits(this.radiansStart) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableBin(this, value, this.data);
    }

    public final ImmutableBin withData(Angle ... elements) {
        List<Angle> newValue = ImmutableBin.createUnmodifiableList(false, ImmutableBin.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBin(this, this.radiansStart, newValue);
    }

    public final ImmutableBin withData(Iterable<? extends Angle> elements) {
        if (this.data == elements) {
            return this;
        }
        List<Angle> newValue = ImmutableBin.createUnmodifiableList(false, ImmutableBin.createSafeList(elements, true, false));
        return new ImmutableBin(this, this.radiansStart, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBin && this.equalTo((ImmutableBin)another);
    }

    private boolean equalTo(ImmutableBin another) {
        return Double.doubleToLongBits(this.radiansStart) == Double.doubleToLongBits(another.radiansStart) && this.data.equals(another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Double.hashCode(this.radiansStart);
        h += (h << 5) + this.data.hashCode();
        return h;
    }

    public String toString() {
        return "Bin{radiansStart=" + this.radiansStart + ", data=" + this.data + "}";
    }

    public static ImmutableBin of(double radiansStart, List<Angle> data) {
        return ImmutableBin.of(radiansStart, data);
    }

    public static ImmutableBin of(double radiansStart, Iterable<? extends Angle> data) {
        return new ImmutableBin(radiansStart, data);
    }

    public static ImmutableBin copyOf(Histogram.Bin instance) {
        if (instance instanceof ImmutableBin) {
            return (ImmutableBin)instance;
        }
        return ImmutableBin.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Histogram.Bin", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RADIANS_START = 1L;
        private long initBits = 1L;
        private double radiansStart;
        private List<Angle> data = new ArrayList<Angle>();

        private Builder() {
        }

        public final Builder from(Histogram.Bin instance) {
            Objects.requireNonNull(instance, "instance");
            this.radiansStart(instance.radiansStart());
            this.addAllData(instance.data());
            return this;
        }

        public final Builder radiansStart(double radiansStart) {
            this.radiansStart = radiansStart;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addData(Angle element) {
            this.data.add(Objects.requireNonNull(element, "data element"));
            return this;
        }

        public final Builder addData(Angle ... elements) {
            for (Angle element : elements) {
                this.data.add(Objects.requireNonNull(element, "data element"));
            }
            return this;
        }

        public final Builder data(Iterable<? extends Angle> elements) {
            this.data.clear();
            return this.addAllData(elements);
        }

        public final Builder addAllData(Iterable<? extends Angle> elements) {
            for (Angle angle : elements) {
                this.data.add(Objects.requireNonNull(angle, "data element"));
            }
            return this;
        }

        public ImmutableBin build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBin(null, this.radiansStart, ImmutableBin.createUnmodifiableList(true, this.data));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("radiansStart");
            }
            return "Cannot build Bin, some of required attributes are not set " + attributes;
        }
    }
}

