/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.circular;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.immutables.value.Value;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.circular.ImmutableBin;

@Value.Immutable
public abstract class Histogram {
    @Value.Parameter(order=1)
    public abstract Collection<Angle> data();

    @Value.Parameter(order=2)
    public abstract double binWidth();

    public final double largestBinSize() {
        double maxFrequency = Double.NEGATIVE_INFINITY;
        for (double d = 0.0; d < Math.PI * 2; d += this.binWidth()) {
            double frequency = (double)this.findBin(d).size() / (double)this.data().size();
            maxFrequency = FastMath.max((double)frequency, (double)maxFrequency);
        }
        return maxFrequency;
    }

    public final Collection<Angle> findBin(double radiansStart) {
        return this.bins().stream().filter(bin -> Precision.equals((double)bin.radiansStart(), (double)radiansStart, (double)0.001)).findFirst().map(Bin::data).orElse(Collections.emptyList());
    }

    @Value.Lazy
    protected Collection<Bin> bins() {
        ArrayList<Bin> bins = new ArrayList<Bin>();
        for (double radiansStart = 0.0; radiansStart < Math.PI * 2; radiansStart += this.binWidth()) {
            ArrayList<Angle> binData = new ArrayList<Angle>();
            for (Angle circular : this.data()) {
                double radians = circular.radians2PI();
                if (!(radians >= radiansStart) || !(radians < radiansStart + this.binWidth())) continue;
                binData.add(circular);
            }
            bins.add(ImmutableBin.of(radiansStart, binData));
        }
        return bins;
    }

    @Value.Check
    protected void check() {
        Validate.inclusiveBetween((double)0.0, (double)Math.PI, (double)this.binWidth());
    }

    @Value.Immutable
    static interface Bin {
        @Value.Parameter(order=1)
        public double radiansStart();

        @Value.Parameter(order=2)
        public List<Angle> data();
    }
}

