/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.circular;

import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.immutables.value.Value;
import pl.poznan.put.circular.ImmutableAngle;
import pl.poznan.put.circular.exception.InvalidVectorFormatException;

@Value.Immutable
public abstract class Angle
implements Comparable<Angle> {
    private static final Pattern DOT = Pattern.compile("[.]");
    private static final int MINUTES_IN_DAY = 1440;

    public static Angle betweenPoints(Vector3D coordA, Vector3D coordB, Vector3D coordC) {
        Vector3D vectorAB = coordB.subtract((Vector)coordA);
        Vector3D vectorCB = coordB.subtract((Vector)coordC);
        return ImmutableAngle.of(Vector3D.angle((Vector3D)vectorAB, (Vector3D)vectorCB));
    }

    public static Angle torsionAngleByAcos(Vector3D a1, Vector3D a2, Vector3D a3, Vector3D a4) {
        Vector3D u2;
        Vector3D d1 = a1.subtract((Vector)a2);
        Vector3D d2 = a2.subtract((Vector)a3);
        Vector3D d3 = a3.subtract((Vector)a4);
        Vector3D u1 = d1.crossProduct((Vector)d2);
        double ctor = u1.dotProduct((Vector)(u2 = d2.crossProduct((Vector)d3))) / FastMath.sqrt((double)(u1.dotProduct((Vector)u1) * u2.dotProduct((Vector)u2)));
        double torp = FastMath.acos((double)(ctor < -1.0 ? -1.0 : Math.min(ctor, 1.0)));
        return ImmutableAngle.of(u1.dotProduct((Vector)u2.crossProduct((Vector)d2)) >= 0.0 ? torp : -torp);
    }

    public static Angle torsionAngle(Vector3D coordA, Vector3D coordB, Vector3D coordC, Vector3D coordD) {
        Vector3D v1 = coordB.subtract((Vector)coordA);
        Vector3D v2 = coordC.subtract((Vector)coordB);
        Vector3D v3 = coordD.subtract((Vector)coordC);
        return Angle.torsionAngle(v1, v2, v3);
    }

    public static Angle torsionAngle(Vector3D vec1, Vector3D vec2, Vector3D vec3) {
        Vector3D tmp1 = vec1.crossProduct((Vector)vec2);
        Vector3D tmp2 = vec2.crossProduct((Vector)vec3);
        Vector3D tmp3 = vec1.scalarMultiply(vec2.getNorm());
        return ImmutableAngle.of(FastMath.atan2((double)tmp3.dotProduct((Vector)tmp2), (double)tmp1.dotProduct((Vector)tmp2)));
    }

    public static Angle fromHourMinuteString(String hourMinute) {
        String[] split = DOT.split(hourMinute);
        if (split.length != 2) {
            throw new InvalidVectorFormatException("Required format is HH.MM eg. 02.40. The input given was: " + hourMinute);
        }
        try {
            int hours = Integer.parseInt(split[0]);
            int minutes = Integer.parseInt(split[1]);
            return ImmutableAngle.of(Math.PI * 2 * (double)(minutes += hours * 60) / 1440.0);
        }
        catch (NumberFormatException e) {
            throw new InvalidVectorFormatException("Required format is HH.MM eg. 02.40. The input given was: " + hourMinute, e);
        }
    }

    public static double subtractByMinimum(double left, double right) {
        double d = FastMath.abs((double)(left - right));
        return FastMath.min((double)d, (double)(Math.PI * 2 - d));
    }

    public static double subtractAsVectors(double left, double right) {
        double v = FastMath.sin((double)left) * FastMath.sin((double)right);
        v += FastMath.cos((double)left) * FastMath.cos((double)right);
        v = FastMath.min((double)1.0, (double)v);
        v = FastMath.max((double)-1.0, (double)v);
        return FastMath.acos((double)v);
    }

    public static double subtractByAbsolutes(double left, double right) {
        return Math.PI - FastMath.abs((double)(Math.PI - FastMath.abs((double)(left - right))));
    }

    @Value.Parameter(order=1)
    public abstract double radians();

    public final double degrees() {
        return FastMath.toDegrees((double)this.radians());
    }

    public final double degrees360() {
        return FastMath.toDegrees((double)this.radians2PI());
    }

    public final double radians2PI() {
        return this.radians() < 0.0 ? this.radians() + Math.PI * 2 : this.radians();
    }

    public final boolean isValid() {
        return !Double.isNaN(this.radians());
    }

    public final boolean isBetween(Angle begin, Angle end) {
        double end2PI;
        double radians2PI = this.radians2PI();
        double begin2PI = begin.radians2PI();
        return begin2PI < (end2PI = end.radians2PI()) ? radians2PI >= begin2PI && radians2PI < end2PI : radians2PI >= begin2PI || radians2PI < end2PI;
    }

    public final Angle multiply(double v) {
        return ImmutableAngle.of(this.radians() * v);
    }

    public final Angle subtract(Angle other) {
        return ImmutableAngle.of(Angle.subtractByAbsolutes(this.radians(), other.radians()));
    }

    public final Angle orderedSubtract(Angle other) {
        double d = this.radians() - other.radians();
        while (Precision.compareTo((double)d, (double)(-Math.PI), (double)0.001) < 0) {
            d += Math.PI * 2;
        }
        while (Precision.compareTo((double)d, (double)Math.PI, (double)0.001) > 0) {
            d -= Math.PI * 2;
        }
        return ImmutableAngle.of(d);
    }

    public final double distance(Angle other) {
        return 1.0 - FastMath.cos((double)(this.radians() - other.radians()));
    }

    @Override
    public final int compareTo(Angle t) {
        return Double.compare(this.radians(), t.radians());
    }

    public final boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Angle && Precision.equals((double)this.radians(), (double)((Angle)obj).radians(), (double)0.001);
    }

    public final String toString() {
        return String.format(Locale.US, "Angle{degrees=%.2f}", this.degrees());
    }

    @Value.Check
    protected Angle normalize() {
        double value = this.radians();
        if (Double.isNaN(value)) {
            return this;
        }
        Validate.finite((double)value);
        if (value > -Math.PI && value <= Math.PI) {
            return this;
        }
        while (value <= -Math.PI) {
            value += Math.PI * 2;
        }
        while (value > Math.PI) {
            value -= Math.PI * 2;
        }
        return ImmutableAngle.of(value);
    }
}

