/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.atom;

import org.apache.commons.collections4.map.MultiKeyMap;
import pl.poznan.put.atom.AtomType;
import pl.poznan.put.atom.BondLength;
import pl.poznan.put.atom.ImmutableBondLength;

public final class Bond {
    private static final MultiKeyMap<AtomType, BondLength> MAP = new MultiKeyMap();
    private static final BondLength INVALID = ImmutableBondLength.of(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    private Bond() {
    }

    public static BondLength length(AtomType left, AtomType right) {
        BondLength bondLength = (BondLength)MAP.get((Object)left, (Object)right);
        if (bondLength == null) {
            bondLength = (BondLength)MAP.get((Object)right, (Object)left);
        }
        if (bondLength == null) {
            bondLength = INVALID;
        }
        return bondLength;
    }

    static {
        MAP.put((Object)AtomType.C, (Object)AtomType.C, (Object)ImmutableBondLength.of(1.32, 1.538, 1.463));
        MAP.put((Object)AtomType.C, (Object)AtomType.H, (Object)ImmutableBondLength.of(1.07, 1.111, 1.098));
        MAP.put((Object)AtomType.C, (Object)AtomType.N, (Object)ImmutableBondLength.of(1.3, 1.502, 1.396));
        MAP.put((Object)AtomType.C, (Object)AtomType.O, (Object)ImmutableBondLength.of(1.205, 1.48, 1.359));
        MAP.put((Object)AtomType.C, (Object)AtomType.S, (Object)ImmutableBondLength.of(1.816, 1.836, 1.82));
        MAP.put((Object)AtomType.H, (Object)AtomType.C, (Object)ImmutableBondLength.of(1.07, 1.111, 1.098));
        MAP.put((Object)AtomType.H, (Object)AtomType.N, (Object)ImmutableBondLength.of(0.976, 1.04, 1.005));
        MAP.put((Object)AtomType.H, (Object)AtomType.O, (Object)ImmutableBondLength.of(0.96, 0.96, 0.96));
        MAP.put((Object)AtomType.H, (Object)AtomType.S, (Object)ImmutableBondLength.of(1.325, 1.325, 1.325));
        MAP.put((Object)AtomType.N, (Object)AtomType.C, (Object)ImmutableBondLength.of(1.3, 1.502, 1.396));
        MAP.put((Object)AtomType.N, (Object)AtomType.H, (Object)ImmutableBondLength.of(0.976, 1.04, 1.005));
        MAP.put((Object)AtomType.O, (Object)AtomType.C, (Object)ImmutableBondLength.of(1.205, 1.48, 1.359));
        MAP.put((Object)AtomType.O, (Object)AtomType.H, (Object)ImmutableBondLength.of(0.96, 0.96, 0.96));
        MAP.put((Object)AtomType.O, (Object)AtomType.P, (Object)ImmutableBondLength.of(1.48, 1.6, 1.553));
        MAP.put((Object)AtomType.P, (Object)AtomType.O, (Object)ImmutableBondLength.of(1.48, 1.6, 1.553));
        MAP.put((Object)AtomType.S, (Object)AtomType.C, (Object)ImmutableBondLength.of(1.816, 1.836, 1.82));
        MAP.put((Object)AtomType.S, (Object)AtomType.H, (Object)ImmutableBondLength.of(1.325, 1.325, 1.325));
        MAP.put((Object)AtomType.S, (Object)AtomType.S, (Object)ImmutableBondLength.of(2.029, 2.029, 2.029));
    }
}

