package pl.poznan.put.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExecHelper.ExecutionResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExecutionResult.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableExecutionResult.of()}.
 */
@Generated(from = "ExecHelper.ExecutionResult", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableExecutionResult implements ExecHelper.ExecutionResult {
  private final int exitCode;
  private final String standardOutput;
  private final String standardError;

  private ImmutableExecutionResult(int exitCode, String standardOutput, String standardError) {
    this.exitCode = exitCode;
    this.standardOutput = Objects.requireNonNull(standardOutput, "standardOutput");
    this.standardError = Objects.requireNonNull(standardError, "standardError");
  }

  private ImmutableExecutionResult(
      ImmutableExecutionResult original,
      int exitCode,
      String standardOutput,
      String standardError) {
    this.exitCode = exitCode;
    this.standardOutput = standardOutput;
    this.standardError = standardError;
  }

  /**
   *@return The exit code (0 means success). 
   */
  @Override
  public int exitCode() {
    return exitCode;
  }

  /**
   *@return The contents of standard output stream. 
   */
  @Override
  public String standardOutput() {
    return standardOutput;
  }

  /**
   *@return The contents of standard error stream. 
   */
  @Override
  public String standardError() {
    return standardError;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecHelper.ExecutionResult#exitCode() exitCode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for exitCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecutionResult withExitCode(int value) {
    if (this.exitCode == value) return this;
    return new ImmutableExecutionResult(this, value, this.standardOutput, this.standardError);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecHelper.ExecutionResult#standardOutput() standardOutput} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for standardOutput
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecutionResult withStandardOutput(String value) {
    String newValue = Objects.requireNonNull(value, "standardOutput");
    if (this.standardOutput.equals(newValue)) return this;
    return new ImmutableExecutionResult(this, this.exitCode, newValue, this.standardError);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecHelper.ExecutionResult#standardError() standardError} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for standardError
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecutionResult withStandardError(String value) {
    String newValue = Objects.requireNonNull(value, "standardError");
    if (this.standardError.equals(newValue)) return this;
    return new ImmutableExecutionResult(this, this.exitCode, this.standardOutput, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExecutionResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExecutionResult
        && equalTo((ImmutableExecutionResult) another);
  }

  private boolean equalTo(ImmutableExecutionResult another) {
    return exitCode == another.exitCode
        && standardOutput.equals(another.standardOutput)
        && standardError.equals(another.standardError);
  }

  /**
   * Computes a hash code from attributes: {@code exitCode}, {@code standardOutput}, {@code standardError}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + exitCode;
    h += (h << 5) + standardOutput.hashCode();
    h += (h << 5) + standardError.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExecutionResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExecutionResult{"
        + "exitCode=" + exitCode
        + ", standardOutput=" + standardOutput
        + ", standardError=" + standardError
        + "}";
  }

  /**
   * Construct a new immutable {@code ExecutionResult} instance.
   * @param exitCode The value for the {@code exitCode} attribute
   * @param standardOutput The value for the {@code standardOutput} attribute
   * @param standardError The value for the {@code standardError} attribute
   * @return An immutable ExecutionResult instance
   */
  public static ImmutableExecutionResult of(int exitCode, String standardOutput, String standardError) {
    return new ImmutableExecutionResult(exitCode, standardOutput, standardError);
  }

  /**
   * Creates an immutable copy of a {@link ExecHelper.ExecutionResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExecutionResult instance
   */
  public static ImmutableExecutionResult copyOf(ExecHelper.ExecutionResult instance) {
    if (instance instanceof ImmutableExecutionResult) {
      return (ImmutableExecutionResult) instance;
    }
    return ImmutableExecutionResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExecutionResult ImmutableExecutionResult}.
   * <pre>
   * ImmutableExecutionResult.builder()
   *    .exitCode(int) // required {@link ExecHelper.ExecutionResult#exitCode() exitCode}
   *    .standardOutput(String) // required {@link ExecHelper.ExecutionResult#standardOutput() standardOutput}
   *    .standardError(String) // required {@link ExecHelper.ExecutionResult#standardError() standardError}
   *    .build();
   * </pre>
   * @return A new ImmutableExecutionResult builder
   */
  public static ImmutableExecutionResult.Builder builder() {
    return new ImmutableExecutionResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExecutionResult ImmutableExecutionResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExecHelper.ExecutionResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EXIT_CODE = 0x1L;
    private static final long INIT_BIT_STANDARD_OUTPUT = 0x2L;
    private static final long INIT_BIT_STANDARD_ERROR = 0x4L;
    private long initBits = 0x7L;

    private int exitCode;
    private @Nullable String standardOutput;
    private @Nullable String standardError;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExecutionResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExecHelper.ExecutionResult instance) {
      Objects.requireNonNull(instance, "instance");
      exitCode(instance.exitCode());
      standardOutput(instance.standardOutput());
      standardError(instance.standardError());
      return this;
    }

    /**
     * Initializes the value for the {@link ExecHelper.ExecutionResult#exitCode() exitCode} attribute.
     * @param exitCode The value for exitCode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder exitCode(int exitCode) {
      this.exitCode = exitCode;
      initBits &= ~INIT_BIT_EXIT_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link ExecHelper.ExecutionResult#standardOutput() standardOutput} attribute.
     * @param standardOutput The value for standardOutput 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder standardOutput(String standardOutput) {
      this.standardOutput = Objects.requireNonNull(standardOutput, "standardOutput");
      initBits &= ~INIT_BIT_STANDARD_OUTPUT;
      return this;
    }

    /**
     * Initializes the value for the {@link ExecHelper.ExecutionResult#standardError() standardError} attribute.
     * @param standardError The value for standardError 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder standardError(String standardError) {
      this.standardError = Objects.requireNonNull(standardError, "standardError");
      initBits &= ~INIT_BIT_STANDARD_ERROR;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExecutionResult ImmutableExecutionResult}.
     * @return An immutable instance of ExecutionResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExecutionResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExecutionResult(null, exitCode, standardOutput, standardError);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXIT_CODE) != 0) attributes.add("exitCode");
      if ((initBits & INIT_BIT_STANDARD_OUTPUT) != 0) attributes.add("standardOutput");
      if ((initBits & INIT_BIT_STANDARD_ERROR) != 0) attributes.add("standardError");
      return "Cannot build ExecutionResult, some of required attributes are not set " + attributes;
    }
  }
}
