package pl.poznan.put.utility;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExecHelper}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExecHelper.builder()}.
 */
@Generated(from = "ExecHelper", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableExecHelper extends ExecHelper {
  private final @Nullable File workingDirectory;
  private final String command;
  private final Map<String, String> environment;
  private final List<String> arguments;

  private ImmutableExecHelper(ImmutableExecHelper.Builder builder) {
    this.workingDirectory = builder.workingDirectory;
    this.command = builder.command;
    if (builder.environmentIsSet()) {
      initShim.environment(createUnmodifiableMap(false, false, builder.environment));
    }
    if (builder.argumentsIsSet()) {
      initShim.arguments(createUnmodifiableList(true, builder.arguments));
    }
    this.environment = initShim.environment();
    this.arguments = initShim.arguments();
    this.initShim = null;
  }

  private ImmutableExecHelper(
      @Nullable File workingDirectory,
      String command,
      Map<String, String> environment,
      List<String> arguments) {
    this.workingDirectory = workingDirectory;
    this.command = command;
    this.environment = environment;
    this.arguments = arguments;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ExecHelper", generator = "Immutables")
  private final class InitShim {
    private byte environmentBuildStage = STAGE_UNINITIALIZED;
    private Map<String, String> environment;

    Map<String, String> environment() {
      if (environmentBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (environmentBuildStage == STAGE_UNINITIALIZED) {
        environmentBuildStage = STAGE_INITIALIZING;
        this.environment = createUnmodifiableMap(true, false, ImmutableExecHelper.super.environment());
        environmentBuildStage = STAGE_INITIALIZED;
      }
      return this.environment;
    }

    void environment(Map<String, String> environment) {
      this.environment = environment;
      environmentBuildStage = STAGE_INITIALIZED;
    }

    private byte argumentsBuildStage = STAGE_UNINITIALIZED;
    private List<String> arguments;

    List<String> arguments() {
      if (argumentsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (argumentsBuildStage == STAGE_UNINITIALIZED) {
        argumentsBuildStage = STAGE_INITIALIZING;
        this.arguments = createUnmodifiableList(false, createSafeList(ImmutableExecHelper.super.arguments(), true, false));
        argumentsBuildStage = STAGE_INITIALIZED;
      }
      return this.arguments;
    }

    void arguments(List<String> arguments) {
      this.arguments = arguments;
      argumentsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (environmentBuildStage == STAGE_INITIALIZING) attributes.add("environment");
      if (argumentsBuildStage == STAGE_INITIALIZING) attributes.add("arguments");
      return "Cannot build ExecHelper, attribute initializers form cycle " + attributes;
    }
  }

  /**
   *@return The working directory where to run the command in. 
   */
  @Override
  public Optional<File> workingDirectory() {
    return Optional.ofNullable(workingDirectory);
  }

  /**
   *@return The command to run. 
   */
  @Override
  public String command() {
    return command;
  }

  /**
   * @return The environment variables to be set during external command running (default: empty).
   */
  @Override
  public Map<String, String> environment() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.environment()
        : this.environment;
  }

  /**
   *@return The list of arguments to the command (default: empty). 
   */
  @Override
  public List<String> arguments() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.arguments()
        : this.arguments;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ExecHelper#workingDirectory() workingDirectory} attribute.
   * @param value The value for workingDirectory
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecHelper withWorkingDirectory(File value) {
    @Nullable File newValue = Objects.requireNonNull(value, "workingDirectory");
    if (this.workingDirectory == newValue) return this;
    return new ImmutableExecHelper(newValue, this.command, this.environment, this.arguments);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ExecHelper#workingDirectory() workingDirectory} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for workingDirectory
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableExecHelper withWorkingDirectory(Optional<? extends File> optional) {
    @Nullable File value = optional.orElse(null);
    if (this.workingDirectory == value) return this;
    return new ImmutableExecHelper(value, this.command, this.environment, this.arguments);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ExecHelper#command() command} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for command
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExecHelper withCommand(String value) {
    String newValue = Objects.requireNonNull(value, "command");
    if (this.command.equals(newValue)) return this;
    return new ImmutableExecHelper(this.workingDirectory, newValue, this.environment, this.arguments);
  }

  /**
   * Copy the current immutable object by replacing the {@link ExecHelper#environment() environment} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the environment map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecHelper withEnvironment(Map<String, ? extends String> entries) {
    if (this.environment == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableExecHelper(this.workingDirectory, this.command, newValue, this.arguments);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExecHelper#arguments() arguments}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecHelper withArguments(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableExecHelper(this.workingDirectory, this.command, this.environment, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ExecHelper#arguments() arguments}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of arguments elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableExecHelper withArguments(Iterable<String> elements) {
    if (this.arguments == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableExecHelper(this.workingDirectory, this.command, this.environment, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExecHelper} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExecHelper
        && equalTo((ImmutableExecHelper) another);
  }

  private boolean equalTo(ImmutableExecHelper another) {
    return Objects.equals(workingDirectory, another.workingDirectory)
        && command.equals(another.command)
        && environment.equals(another.environment)
        && arguments.equals(another.arguments);
  }

  /**
   * Computes a hash code from attributes: {@code workingDirectory}, {@code command}, {@code environment}, {@code arguments}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(workingDirectory);
    h += (h << 5) + command.hashCode();
    h += (h << 5) + environment.hashCode();
    h += (h << 5) + arguments.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ExecHelper} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ExecHelper{");
    if (workingDirectory != null) {
      builder.append("workingDirectory=").append(workingDirectory);
    }
    if (builder.length() > 11) builder.append(", ");
    builder.append("command=").append(command);
    builder.append(", ");
    builder.append("environment=").append(environment);
    builder.append(", ");
    builder.append("arguments=").append(arguments);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link ExecHelper} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExecHelper instance
   */
  public static ImmutableExecHelper copyOf(ExecHelper instance) {
    if (instance instanceof ImmutableExecHelper) {
      return (ImmutableExecHelper) instance;
    }
    return ImmutableExecHelper.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExecHelper ImmutableExecHelper}.
   * <pre>
   * ImmutableExecHelper.builder()
   *    .workingDirectory(java.io.File) // optional {@link ExecHelper#workingDirectory() workingDirectory}
   *    .command(String) // required {@link ExecHelper#command() command}
   *    .putEnvironment|putAllEnvironment(String =&gt; String) // {@link ExecHelper#environment() environment} mappings
   *    .addArguments|addAllArguments(String) // {@link ExecHelper#arguments() arguments} elements
   *    .build();
   * </pre>
   * @return A new ImmutableExecHelper builder
   */
  public static ImmutableExecHelper.Builder builder() {
    return new ImmutableExecHelper.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExecHelper ImmutableExecHelper}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ExecHelper", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_COMMAND = 0x1L;
    private static final long OPT_BIT_ENVIRONMENT = 0x1L;
    private static final long OPT_BIT_ARGUMENTS = 0x2L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable File workingDirectory;
    private @Nullable String command;
    private Map<String, String> environment = new LinkedHashMap<String, String>();
    private List<String> arguments = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExecHelper} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExecHelper instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<File> workingDirectoryOptional = instance.workingDirectory();
      if (workingDirectoryOptional.isPresent()) {
        workingDirectory(workingDirectoryOptional);
      }
      command(instance.command());
      putAllEnvironment(instance.environment());
      addAllArguments(instance.arguments());
      return this;
    }

    /**
     * Initializes the optional value {@link ExecHelper#workingDirectory() workingDirectory} to workingDirectory.
     * @param workingDirectory The value for workingDirectory
     * @return {@code this} builder for chained invocation
     */
    public final Builder workingDirectory(File workingDirectory) {
      this.workingDirectory = Objects.requireNonNull(workingDirectory, "workingDirectory");
      return this;
    }

    /**
     * Initializes the optional value {@link ExecHelper#workingDirectory() workingDirectory} to workingDirectory.
     * @param workingDirectory The value for workingDirectory
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder workingDirectory(Optional<? extends File> workingDirectory) {
      this.workingDirectory = workingDirectory.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ExecHelper#command() command} attribute.
     * @param command The value for command 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(String command) {
      this.command = Objects.requireNonNull(command, "command");
      initBits &= ~INIT_BIT_COMMAND;
      return this;
    }

    /**
     * Put one entry to the {@link ExecHelper#environment() environment} map.
     * @param key The key in the environment map
     * @param value The associated value in the environment map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putEnvironment(String key, String value) {
      this.environment.put(
          Objects.requireNonNull(key, "environment key"),
          Objects.requireNonNull(value, "environment value"));
      optBits |= OPT_BIT_ENVIRONMENT;
      return this;
    }

    /**
     * Put one entry to the {@link ExecHelper#environment() environment} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putEnvironment(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.environment.put(
          Objects.requireNonNull(k, "environment key"),
          Objects.requireNonNull(v, "environment value"));
      optBits |= OPT_BIT_ENVIRONMENT;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ExecHelper#environment() environment} map. Nulls are not permitted
     * @param entries The entries that will be added to the environment map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environment(Map<String, ? extends String> entries) {
      this.environment.clear();
      optBits |= OPT_BIT_ENVIRONMENT;
      return putAllEnvironment(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ExecHelper#environment() environment} map. Nulls are not permitted
     * @param entries The entries that will be added to the environment map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironment(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.environment.put(
            Objects.requireNonNull(k, "environment key"),
            Objects.requireNonNull(v, "environment value"));
      }
      optBits |= OPT_BIT_ENVIRONMENT;
      return this;
    }

    /**
     * Adds one element to {@link ExecHelper#arguments() arguments} list.
     * @param element A arguments element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addArguments(String element) {
      this.arguments.add(Objects.requireNonNull(element, "arguments element"));
      optBits |= OPT_BIT_ARGUMENTS;
      return this;
    }

    /**
     * Adds elements to {@link ExecHelper#arguments() arguments} list.
     * @param elements An array of arguments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addArguments(String... elements) {
      for (String element : elements) {
        this.arguments.add(Objects.requireNonNull(element, "arguments element"));
      }
      optBits |= OPT_BIT_ARGUMENTS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ExecHelper#arguments() arguments} list.
     * @param elements An iterable of arguments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder arguments(Iterable<String> elements) {
      this.arguments.clear();
      return addAllArguments(elements);
    }

    /**
     * Adds elements to {@link ExecHelper#arguments() arguments} list.
     * @param elements An iterable of arguments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllArguments(Iterable<String> elements) {
      for (String element : elements) {
        this.arguments.add(Objects.requireNonNull(element, "arguments element"));
      }
      optBits |= OPT_BIT_ARGUMENTS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExecHelper ImmutableExecHelper}.
     * @return An immutable instance of ExecHelper
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExecHelper build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableExecHelper(this);
    }

    private boolean environmentIsSet() {
      return (optBits & OPT_BIT_ENVIRONMENT) != 0;
    }

    private boolean argumentsIsSet() {
      return (optBits & OPT_BIT_ARGUMENTS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_COMMAND) != 0) attributes.add("command");
      return "Cannot build ExecHelper, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
