package pl.poznan.put.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Quadruple}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuadruple.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableQuadruple.of()}.
 */
@Generated(from = "Quadruple", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableQuadruple<T> implements Quadruple<T> {
  private final T a;
  private final T b;
  private final T c;
  private final T d;

  private ImmutableQuadruple(T a, T b, T c, T d) {
    this.a = Objects.requireNonNull(a, "a");
    this.b = Objects.requireNonNull(b, "b");
    this.c = Objects.requireNonNull(c, "c");
    this.d = Objects.requireNonNull(d, "d");
  }

  private ImmutableQuadruple(ImmutableQuadruple<T> original, T a, T b, T c, T d) {
    this.a = a;
    this.b = b;
    this.c = c;
    this.d = d;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public T a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public T b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public T c() {
    return c;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  public T d() {
    return d;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Quadruple#a() a} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuadruple<T> withA(T value) {
    if (this.a == value) return this;
    T newValue = Objects.requireNonNull(value, "a");
    return new ImmutableQuadruple<>(this, newValue, this.b, this.c, this.d);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Quadruple#b() b} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuadruple<T> withB(T value) {
    if (this.b == value) return this;
    T newValue = Objects.requireNonNull(value, "b");
    return new ImmutableQuadruple<>(this, this.a, newValue, this.c, this.d);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Quadruple#c() c} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuadruple<T> withC(T value) {
    if (this.c == value) return this;
    T newValue = Objects.requireNonNull(value, "c");
    return new ImmutableQuadruple<>(this, this.a, this.b, newValue, this.d);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Quadruple#d() d} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for d
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuadruple<T> withD(T value) {
    if (this.d == value) return this;
    T newValue = Objects.requireNonNull(value, "d");
    return new ImmutableQuadruple<>(this, this.a, this.b, this.c, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuadruple} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuadruple<?>
        && equalTo((ImmutableQuadruple<?>) another);
  }

  private boolean equalTo(ImmutableQuadruple<?> another) {
    return a.equals(another.a)
        && b.equals(another.b)
        && c.equals(another.c)
        && d.equals(another.d);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}, {@code d}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    h += (h << 5) + d.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Quadruple} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Quadruple{"
        + "a=" + a
        + ", b=" + b
        + ", c=" + c
        + ", d=" + d
        + "}";
  }

  /**
   * Construct a new immutable {@code Quadruple} instance.
 * @param <T> generic parameter T
   * @param a The value for the {@code a} attribute
   * @param b The value for the {@code b} attribute
   * @param c The value for the {@code c} attribute
   * @param d The value for the {@code d} attribute
   * @return An immutable Quadruple instance
   */
  public static <T> ImmutableQuadruple<T> of(T a, T b, T c, T d) {
    return new ImmutableQuadruple<>(a, b, c, d);
  }

  /**
   * Creates an immutable copy of a {@link Quadruple} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Quadruple instance
   */
  public static <T> ImmutableQuadruple<T> copyOf(Quadruple<T> instance) {
    if (instance instanceof ImmutableQuadruple<?>) {
      return (ImmutableQuadruple<T>) instance;
    }
    return ImmutableQuadruple.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuadruple ImmutableQuadruple}.
   * <pre>
   * ImmutableQuadruple.&amp;lt;T&amp;gt;builder()
   *    .a(T) // required {@link Quadruple#a() a}
   *    .b(T) // required {@link Quadruple#b() b}
   *    .c(T) // required {@link Quadruple#c() c}
   *    .d(T) // required {@link Quadruple#d() d}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableQuadruple builder
   */
  public static <T> ImmutableQuadruple.Builder<T> builder() {
    return new ImmutableQuadruple.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableQuadruple ImmutableQuadruple}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Quadruple", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private static final long INIT_BIT_C = 0x4L;
    private static final long INIT_BIT_D = 0x8L;
    private long initBits = 0xfL;

    private @Nullable T a;
    private @Nullable T b;
    private @Nullable T c;
    private @Nullable T d;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Quadruple} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(Quadruple<T> instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      c(instance.c());
      d(instance.d());
      return this;
    }

    /**
     * Initializes the value for the {@link Quadruple#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> a(T a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link Quadruple#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> b(T b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link Quadruple#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> c(T c) {
      this.c = Objects.requireNonNull(c, "c");
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Initializes the value for the {@link Quadruple#d() d} attribute.
     * @param d The value for d 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> d(T d) {
      this.d = Objects.requireNonNull(d, "d");
      initBits &= ~INIT_BIT_D;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuadruple ImmutableQuadruple}.
     * @return An immutable instance of Quadruple
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuadruple<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQuadruple<>(null, a, b, c, d);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      if ((initBits & INIT_BIT_D) != 0) attributes.add("d");
      return "Cannot build Quadruple, some of required attributes are not set " + attributes;
    }
  }
}
