package pl.poznan.put.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DistanceMatrix}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDistanceMatrix.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDistanceMatrix.of()}.
 */
@Generated(from = "DistanceMatrix", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDistanceMatrix implements DistanceMatrix {
  private final List<String> names;
  private final double[][] matrix;

  private ImmutableDistanceMatrix(Iterable<String> names, double[][] matrix) {
    this.names = createUnmodifiableList(false, createSafeList(names, true, false));
    this.matrix = matrix.clone();
  }

  private ImmutableDistanceMatrix(ImmutableDistanceMatrix original, List<String> names, double[][] matrix) {
    this.names = names;
    this.matrix = matrix;
  }

  /**
   * @return The value of the {@code names} attribute
   */
  @Override
  public List<String> names() {
    return names;
  }

  /**
   * @return A cloned {@code matrix} array
   */
  @Override
  public double[][] matrix() {
    return matrix.clone();
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DistanceMatrix#names() names}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDistanceMatrix withNames(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableDistanceMatrix(this, newValue, this.matrix);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DistanceMatrix#names() names}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of names elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDistanceMatrix withNames(Iterable<String> elements) {
    if (this.names == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableDistanceMatrix(this, newValue, this.matrix);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DistanceMatrix#matrix() matrix}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for matrix
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDistanceMatrix withMatrix(double[]... elements) {
    double[][] newValue = elements.clone();
    return new ImmutableDistanceMatrix(this, this.names, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDistanceMatrix} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDistanceMatrix
        && equalTo((ImmutableDistanceMatrix) another);
  }

  private boolean equalTo(ImmutableDistanceMatrix another) {
    return names.equals(another.names)
        && Arrays.equals(matrix, another.matrix);
  }

  /**
   * Computes a hash code from attributes: {@code names}, {@code matrix}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + names.hashCode();
    h += (h << 5) + Arrays.hashCode(matrix);
    return h;
  }

  /**
   * Prints the immutable value {@code DistanceMatrix} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DistanceMatrix{"
        + "names=" + names
        + ", matrix=" + Arrays.toString(matrix)
        + "}";
  }

  /**
   * Construct a new immutable {@code DistanceMatrix} instance.
   * @param names The value for the {@code names} attribute
   * @param matrix The value for the {@code matrix} attribute
   * @return An immutable DistanceMatrix instance
   */
  public static ImmutableDistanceMatrix of(List<String> names, double[][] matrix) {
    return of((Iterable<String>) names, matrix);
  }

  /**
   * Construct a new immutable {@code DistanceMatrix} instance.
   * @param names The value for the {@code names} attribute
   * @param matrix The value for the {@code matrix} attribute
   * @return An immutable DistanceMatrix instance
   */
  public static ImmutableDistanceMatrix of(Iterable<String> names, double[][] matrix) {
    return new ImmutableDistanceMatrix(names, matrix);
  }

  /**
   * Creates an immutable copy of a {@link DistanceMatrix} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DistanceMatrix instance
   */
  public static ImmutableDistanceMatrix copyOf(DistanceMatrix instance) {
    if (instance instanceof ImmutableDistanceMatrix) {
      return (ImmutableDistanceMatrix) instance;
    }
    return ImmutableDistanceMatrix.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDistanceMatrix ImmutableDistanceMatrix}.
   * <pre>
   * ImmutableDistanceMatrix.builder()
   *    .addNames|addAllNames(String) // {@link DistanceMatrix#names() names} elements
   *    .matrix(double[]) // required {@link DistanceMatrix#matrix() matrix}
   *    .build();
   * </pre>
   * @return A new ImmutableDistanceMatrix builder
   */
  public static ImmutableDistanceMatrix.Builder builder() {
    return new ImmutableDistanceMatrix.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDistanceMatrix ImmutableDistanceMatrix}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DistanceMatrix", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MATRIX = 0x1L;
    private long initBits = 0x1L;

    private List<String> names = new ArrayList<String>();
    private @Nullable double[][] matrix;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DistanceMatrix} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DistanceMatrix instance) {
      Objects.requireNonNull(instance, "instance");
      addAllNames(instance.names());
      matrix(instance.matrix());
      return this;
    }

    /**
     * Adds one element to {@link DistanceMatrix#names() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addNames(String element) {
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link DistanceMatrix#names() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addNames(String... elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DistanceMatrix#names() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(Iterable<String> elements) {
      this.names.clear();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link DistanceMatrix#names() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DistanceMatrix#matrix() matrix} attribute.
     * @param matrix The elements for matrix
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder matrix(double[]... matrix) {
      this.matrix = matrix.clone();
      initBits &= ~INIT_BIT_MATRIX;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDistanceMatrix ImmutableDistanceMatrix}.
     * @return An immutable instance of DistanceMatrix
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDistanceMatrix build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDistanceMatrix(null, createUnmodifiableList(true, names), matrix);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MATRIX) != 0) attributes.add("matrix");
      return "Cannot build DistanceMatrix, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
