package pl.poznan.put.torsion;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.circular.Angle;
import pl.poznan.put.torsion.range.RangeDifference;

/**
 * Immutable implementation of {@link TorsionAngleDelta}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTorsionAngleDelta.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableTorsionAngleDelta.of()}.
 */
@Generated(from = "TorsionAngleDelta", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableTorsionAngleDelta extends TorsionAngleDelta {
  private final MasterTorsionAngleType angleType;
  private final TorsionAngleDelta.State state;
  private final Angle delta;
  private final RangeDifference rangeDifference;

  private ImmutableTorsionAngleDelta(
      MasterTorsionAngleType angleType,
      TorsionAngleDelta.State state,
      Angle delta,
      RangeDifference rangeDifference) {
    this.angleType = Objects.requireNonNull(angleType, "angleType");
    this.state = Objects.requireNonNull(state, "state");
    this.delta = Objects.requireNonNull(delta, "delta");
    this.rangeDifference = Objects.requireNonNull(rangeDifference, "rangeDifference");
  }

  private ImmutableTorsionAngleDelta(
      ImmutableTorsionAngleDelta original,
      MasterTorsionAngleType angleType,
      TorsionAngleDelta.State state,
      Angle delta,
      RangeDifference rangeDifference) {
    this.angleType = angleType;
    this.state = state;
    this.delta = delta;
    this.rangeDifference = rangeDifference;
  }

  /**
   *@return The type of torsion angle. 
   */
  @Override
  public MasterTorsionAngleType angleType() {
    return angleType;
  }

  /**
   *@return The state of comparison depending on whether the inputs were valid or not. 
   */
  @Override
  public TorsionAngleDelta.State state() {
    return state;
  }

  /**
   *@return The actual result of subtraction. 
   */
  @Override
  public Angle delta() {
    return delta;
  }

  /**
   *@return The difference in terms of ranges the angles belong to. 
   */
  @Override
  public RangeDifference rangeDifference() {
    return rangeDifference;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TorsionAngleDelta#angleType() angleType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for angleType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTorsionAngleDelta withAngleType(MasterTorsionAngleType value) {
    if (this.angleType == value) return this;
    MasterTorsionAngleType newValue = Objects.requireNonNull(value, "angleType");
    return new ImmutableTorsionAngleDelta(this, newValue, this.state, this.delta, this.rangeDifference);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TorsionAngleDelta#state() state} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTorsionAngleDelta withState(TorsionAngleDelta.State value) {
    if (this.state == value) return this;
    TorsionAngleDelta.State newValue = Objects.requireNonNull(value, "state");
    if (this.state.equals(newValue)) return this;
    return new ImmutableTorsionAngleDelta(this, this.angleType, newValue, this.delta, this.rangeDifference);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TorsionAngleDelta#delta() delta} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for delta
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTorsionAngleDelta withDelta(Angle value) {
    if (this.delta == value) return this;
    Angle newValue = Objects.requireNonNull(value, "delta");
    return new ImmutableTorsionAngleDelta(this, this.angleType, this.state, newValue, this.rangeDifference);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TorsionAngleDelta#rangeDifference() rangeDifference} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rangeDifference
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTorsionAngleDelta withRangeDifference(RangeDifference value) {
    if (this.rangeDifference == value) return this;
    RangeDifference newValue = Objects.requireNonNull(value, "rangeDifference");
    if (this.rangeDifference.equals(newValue)) return this;
    return new ImmutableTorsionAngleDelta(this, this.angleType, this.state, this.delta, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTorsionAngleDelta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTorsionAngleDelta
        && equalTo((ImmutableTorsionAngleDelta) another);
  }

  private boolean equalTo(ImmutableTorsionAngleDelta another) {
    return angleType.equals(another.angleType)
        && state.equals(another.state)
        && delta.equals(another.delta)
        && rangeDifference.equals(another.rangeDifference);
  }

  /**
   * Computes a hash code from attributes: {@code angleType}, {@code state}, {@code delta}, {@code rangeDifference}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + angleType.hashCode();
    h += (h << 5) + state.hashCode();
    h += (h << 5) + delta.hashCode();
    h += (h << 5) + rangeDifference.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TorsionAngleDelta} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TorsionAngleDelta{"
        + "angleType=" + angleType
        + ", state=" + state
        + ", delta=" + delta
        + ", rangeDifference=" + rangeDifference
        + "}";
  }

  /**
   * Construct a new immutable {@code TorsionAngleDelta} instance.
   * @param angleType The value for the {@code angleType} attribute
   * @param state The value for the {@code state} attribute
   * @param delta The value for the {@code delta} attribute
   * @param rangeDifference The value for the {@code rangeDifference} attribute
   * @return An immutable TorsionAngleDelta instance
   */
  public static ImmutableTorsionAngleDelta of(MasterTorsionAngleType angleType, TorsionAngleDelta.State state, Angle delta, RangeDifference rangeDifference) {
    return new ImmutableTorsionAngleDelta(angleType, state, delta, rangeDifference);
  }

  /**
   * Creates an immutable copy of a {@link TorsionAngleDelta} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TorsionAngleDelta instance
   */
  public static ImmutableTorsionAngleDelta copyOf(TorsionAngleDelta instance) {
    if (instance instanceof ImmutableTorsionAngleDelta) {
      return (ImmutableTorsionAngleDelta) instance;
    }
    return ImmutableTorsionAngleDelta.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTorsionAngleDelta ImmutableTorsionAngleDelta}.
   * <pre>
   * ImmutableTorsionAngleDelta.builder()
   *    .angleType(pl.poznan.put.torsion.MasterTorsionAngleType) // required {@link TorsionAngleDelta#angleType() angleType}
   *    .state(pl.poznan.put.torsion.TorsionAngleDelta.State) // required {@link TorsionAngleDelta#state() state}
   *    .delta(pl.poznan.put.circular.Angle) // required {@link TorsionAngleDelta#delta() delta}
   *    .rangeDifference(pl.poznan.put.torsion.range.RangeDifference) // required {@link TorsionAngleDelta#rangeDifference() rangeDifference}
   *    .build();
   * </pre>
   * @return A new ImmutableTorsionAngleDelta builder
   */
  public static ImmutableTorsionAngleDelta.Builder builder() {
    return new ImmutableTorsionAngleDelta.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTorsionAngleDelta ImmutableTorsionAngleDelta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TorsionAngleDelta", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ANGLE_TYPE = 0x1L;
    private static final long INIT_BIT_STATE = 0x2L;
    private static final long INIT_BIT_DELTA = 0x4L;
    private static final long INIT_BIT_RANGE_DIFFERENCE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable MasterTorsionAngleType angleType;
    private @Nullable TorsionAngleDelta.State state;
    private @Nullable Angle delta;
    private @Nullable RangeDifference rangeDifference;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TorsionAngleDelta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TorsionAngleDelta instance) {
      Objects.requireNonNull(instance, "instance");
      angleType(instance.angleType());
      state(instance.state());
      delta(instance.delta());
      rangeDifference(instance.rangeDifference());
      return this;
    }

    /**
     * Initializes the value for the {@link TorsionAngleDelta#angleType() angleType} attribute.
     * @param angleType The value for angleType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder angleType(MasterTorsionAngleType angleType) {
      this.angleType = Objects.requireNonNull(angleType, "angleType");
      initBits &= ~INIT_BIT_ANGLE_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link TorsionAngleDelta#state() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(TorsionAngleDelta.State state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link TorsionAngleDelta#delta() delta} attribute.
     * @param delta The value for delta 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder delta(Angle delta) {
      this.delta = Objects.requireNonNull(delta, "delta");
      initBits &= ~INIT_BIT_DELTA;
      return this;
    }

    /**
     * Initializes the value for the {@link TorsionAngleDelta#rangeDifference() rangeDifference} attribute.
     * @param rangeDifference The value for rangeDifference 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rangeDifference(RangeDifference rangeDifference) {
      this.rangeDifference = Objects.requireNonNull(rangeDifference, "rangeDifference");
      initBits &= ~INIT_BIT_RANGE_DIFFERENCE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTorsionAngleDelta ImmutableTorsionAngleDelta}.
     * @return An immutable instance of TorsionAngleDelta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTorsionAngleDelta build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTorsionAngleDelta(null, angleType, state, delta, rangeDifference);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ANGLE_TYPE) != 0) attributes.add("angleType");
      if ((initBits & INIT_BIT_STATE) != 0) attributes.add("state");
      if ((initBits & INIT_BIT_DELTA) != 0) attributes.add("delta");
      if ((initBits & INIT_BIT_RANGE_DIFFERENCE) != 0) attributes.add("rangeDifference");
      return "Cannot build TorsionAngleDelta, some of required attributes are not set " + attributes;
    }
  }
}
