package pl.poznan.put.torsion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.pdb.analysis.MoleculeType;

/**
 * Immutable implementation of {@link AverageTorsionAngleType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAverageTorsionAngleType.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAverageTorsionAngleType.of()}.
 */
@Generated(from = "AverageTorsionAngleType", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAverageTorsionAngleType extends AverageTorsionAngleType {
  private final MoleculeType moleculeType;
  private final List<MasterTorsionAngleType> consideredAngles;

  private ImmutableAverageTorsionAngleType(
      MoleculeType moleculeType,
      Iterable<? extends MasterTorsionAngleType> consideredAngles) {
    this.moleculeType = Objects.requireNonNull(moleculeType, "moleculeType");
    this.consideredAngles = createUnmodifiableList(false, createSafeList(consideredAngles, true, false));
  }

  private ImmutableAverageTorsionAngleType(
      ImmutableAverageTorsionAngleType original,
      MoleculeType moleculeType,
      List<MasterTorsionAngleType> consideredAngles) {
    this.moleculeType = moleculeType;
    this.consideredAngles = consideredAngles;
  }

  /**
   * @return The value of the {@code moleculeType} attribute
   */
  @Override
  public MoleculeType moleculeType() {
    return moleculeType;
  }

  /**
   *@return The list of angle types to calculate average from. 
   */
  @Override
  public List<MasterTorsionAngleType> consideredAngles() {
    return consideredAngles;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AverageTorsionAngleType#moleculeType() moleculeType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for moleculeType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAverageTorsionAngleType withMoleculeType(MoleculeType value) {
    if (this.moleculeType == value) return this;
    MoleculeType newValue = Objects.requireNonNull(value, "moleculeType");
    if (this.moleculeType.equals(newValue)) return this;
    return new ImmutableAverageTorsionAngleType(this, newValue, this.consideredAngles);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AverageTorsionAngleType#consideredAngles() consideredAngles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAverageTorsionAngleType withConsideredAngles(MasterTorsionAngleType... elements) {
    List<MasterTorsionAngleType> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableAverageTorsionAngleType(this, this.moleculeType, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AverageTorsionAngleType#consideredAngles() consideredAngles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of consideredAngles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAverageTorsionAngleType withConsideredAngles(Iterable<? extends MasterTorsionAngleType> elements) {
    if (this.consideredAngles == elements) return this;
    List<MasterTorsionAngleType> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableAverageTorsionAngleType(this, this.moleculeType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAverageTorsionAngleType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAverageTorsionAngleType
        && equalTo((ImmutableAverageTorsionAngleType) another);
  }

  private boolean equalTo(ImmutableAverageTorsionAngleType another) {
    return moleculeType.equals(another.moleculeType)
        && consideredAngles.equals(another.consideredAngles);
  }

  /**
   * Computes a hash code from attributes: {@code moleculeType}, {@code consideredAngles}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + moleculeType.hashCode();
    h += (h << 5) + consideredAngles.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AverageTorsionAngleType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AverageTorsionAngleType{"
        + "moleculeType=" + moleculeType
        + ", consideredAngles=" + consideredAngles
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long SHORT_DISPLAY_NAME_LAZY_INIT_BIT = 0x1L;

  private transient String shortDisplayName;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AverageTorsionAngleType#shortDisplayName() shortDisplayName} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code shortDisplayName} attribute
   */
  @Override
  public String shortDisplayName() {
    if ((lazyInitBitmap & SHORT_DISPLAY_NAME_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & SHORT_DISPLAY_NAME_LAZY_INIT_BIT) == 0) {
          this.shortDisplayName = Objects.requireNonNull(super.shortDisplayName(), "shortDisplayName");
          lazyInitBitmap |= SHORT_DISPLAY_NAME_LAZY_INIT_BIT;
        }
      }
    }
    return shortDisplayName;
  }

  private static final long EXPORT_NAME_LAZY_INIT_BIT = 0x2L;

  private transient String exportName;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AverageTorsionAngleType#exportName() exportName} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code exportName} attribute
   */
  @Override
  public String exportName() {
    if ((lazyInitBitmap & EXPORT_NAME_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & EXPORT_NAME_LAZY_INIT_BIT) == 0) {
          this.exportName = Objects.requireNonNull(super.exportName(), "exportName");
          lazyInitBitmap |= EXPORT_NAME_LAZY_INIT_BIT;
        }
      }
    }
    return exportName;
  }

  private static final long CONSIDERED_BASIC_ANGLE_TYPES_LAZY_INIT_BIT = 0x4L;

  private transient Set<TorsionAngleType> consideredBasicAngleTypes;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AverageTorsionAngleType#consideredBasicAngleTypes() consideredBasicAngleTypes} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code consideredBasicAngleTypes} attribute
   */
  @Override
  protected Set<TorsionAngleType> consideredBasicAngleTypes() {
    if ((lazyInitBitmap & CONSIDERED_BASIC_ANGLE_TYPES_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & CONSIDERED_BASIC_ANGLE_TYPES_LAZY_INIT_BIT) == 0) {
          this.consideredBasicAngleTypes = Objects.requireNonNull(super.consideredBasicAngleTypes(), "consideredBasicAngleTypes");
          lazyInitBitmap |= CONSIDERED_BASIC_ANGLE_TYPES_LAZY_INIT_BIT;
        }
      }
    }
    return consideredBasicAngleTypes;
  }

  /**
   * Construct a new immutable {@code AverageTorsionAngleType} instance.
   * @param moleculeType The value for the {@code moleculeType} attribute
   * @param consideredAngles The value for the {@code consideredAngles} attribute
   * @return An immutable AverageTorsionAngleType instance
   */
  public static ImmutableAverageTorsionAngleType of(MoleculeType moleculeType, List<MasterTorsionAngleType> consideredAngles) {
    return of(moleculeType, (Iterable<? extends MasterTorsionAngleType>) consideredAngles);
  }

  /**
   * Construct a new immutable {@code AverageTorsionAngleType} instance.
   * @param moleculeType The value for the {@code moleculeType} attribute
   * @param consideredAngles The value for the {@code consideredAngles} attribute
   * @return An immutable AverageTorsionAngleType instance
   */
  public static ImmutableAverageTorsionAngleType of(MoleculeType moleculeType, Iterable<? extends MasterTorsionAngleType> consideredAngles) {
    return new ImmutableAverageTorsionAngleType(moleculeType, consideredAngles);
  }

  /**
   * Creates an immutable copy of a {@link AverageTorsionAngleType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AverageTorsionAngleType instance
   */
  public static ImmutableAverageTorsionAngleType copyOf(AverageTorsionAngleType instance) {
    if (instance instanceof ImmutableAverageTorsionAngleType) {
      return (ImmutableAverageTorsionAngleType) instance;
    }
    return ImmutableAverageTorsionAngleType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAverageTorsionAngleType ImmutableAverageTorsionAngleType}.
   * <pre>
   * ImmutableAverageTorsionAngleType.builder()
   *    .moleculeType(pl.poznan.put.pdb.analysis.MoleculeType) // required {@link AverageTorsionAngleType#moleculeType() moleculeType}
   *    .addConsideredAngles|addAllConsideredAngles(pl.poznan.put.torsion.MasterTorsionAngleType) // {@link AverageTorsionAngleType#consideredAngles() consideredAngles} elements
   *    .build();
   * </pre>
   * @return A new ImmutableAverageTorsionAngleType builder
   */
  public static ImmutableAverageTorsionAngleType.Builder builder() {
    return new ImmutableAverageTorsionAngleType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAverageTorsionAngleType ImmutableAverageTorsionAngleType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AverageTorsionAngleType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MOLECULE_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable MoleculeType moleculeType;
    private List<MasterTorsionAngleType> consideredAngles = new ArrayList<MasterTorsionAngleType>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.torsion.AverageTorsionAngleType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AverageTorsionAngleType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code pl.poznan.put.torsion.TorsionAngleType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TorsionAngleType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof AverageTorsionAngleType) {
        AverageTorsionAngleType instance = (AverageTorsionAngleType) object;
        if ((bits & 0x1L) == 0) {
          moleculeType(instance.moleculeType());
          bits |= 0x1L;
        }
        addAllConsideredAngles(instance.consideredAngles());
      }
      if (object instanceof TorsionAngleType) {
        TorsionAngleType instance = (TorsionAngleType) object;
        if ((bits & 0x1L) == 0) {
          moleculeType(instance.moleculeType());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AverageTorsionAngleType#moleculeType() moleculeType} attribute.
     * @param moleculeType The value for moleculeType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder moleculeType(MoleculeType moleculeType) {
      this.moleculeType = Objects.requireNonNull(moleculeType, "moleculeType");
      initBits &= ~INIT_BIT_MOLECULE_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link AverageTorsionAngleType#consideredAngles() consideredAngles} list.
     * @param element A consideredAngles element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addConsideredAngles(MasterTorsionAngleType element) {
      this.consideredAngles.add(Objects.requireNonNull(element, "consideredAngles element"));
      return this;
    }

    /**
     * Adds elements to {@link AverageTorsionAngleType#consideredAngles() consideredAngles} list.
     * @param elements An array of consideredAngles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addConsideredAngles(MasterTorsionAngleType... elements) {
      for (MasterTorsionAngleType element : elements) {
        this.consideredAngles.add(Objects.requireNonNull(element, "consideredAngles element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AverageTorsionAngleType#consideredAngles() consideredAngles} list.
     * @param elements An iterable of consideredAngles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder consideredAngles(Iterable<? extends MasterTorsionAngleType> elements) {
      this.consideredAngles.clear();
      return addAllConsideredAngles(elements);
    }

    /**
     * Adds elements to {@link AverageTorsionAngleType#consideredAngles() consideredAngles} list.
     * @param elements An iterable of consideredAngles elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllConsideredAngles(Iterable<? extends MasterTorsionAngleType> elements) {
      for (MasterTorsionAngleType element : elements) {
        this.consideredAngles.add(Objects.requireNonNull(element, "consideredAngles element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableAverageTorsionAngleType ImmutableAverageTorsionAngleType}.
     * @return An immutable instance of AverageTorsionAngleType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAverageTorsionAngleType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAverageTorsionAngleType(null, moleculeType, createUnmodifiableList(true, consideredAngles));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MOLECULE_TYPE) != 0) attributes.add("moleculeType");
      return "Cannot build AverageTorsionAngleType, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
