package pl.poznan.put.torsion;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pl.poznan.put.atom.BondLength;
import pl.poznan.put.pdb.PdbAtomLine;

/**
 * Immutable implementation of {@link AtomPair}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAtomPair.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAtomPair.of()}.
 */
@Generated(from = "AtomPair", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAtomPair extends AtomPair {
  private final PdbAtomLine leftAtom;
  private final PdbAtomLine rightAtom;

  private ImmutableAtomPair(PdbAtomLine leftAtom, PdbAtomLine rightAtom) {
    this.leftAtom = Objects.requireNonNull(leftAtom, "leftAtom");
    this.rightAtom = Objects.requireNonNull(rightAtom, "rightAtom");
  }

  private ImmutableAtomPair(
      ImmutableAtomPair original,
      PdbAtomLine leftAtom,
      PdbAtomLine rightAtom) {
    this.leftAtom = leftAtom;
    this.rightAtom = rightAtom;
  }

  /**
   *@return The first atom. 
   */
  @Override
  PdbAtomLine leftAtom() {
    return leftAtom;
  }

  /**
   *@return The second atom. 
   */
  @Override
  PdbAtomLine rightAtom() {
    return rightAtom;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AtomPair#leftAtom() leftAtom} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for leftAtom
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAtomPair withLeftAtom(PdbAtomLine value) {
    if (this.leftAtom == value) return this;
    PdbAtomLine newValue = Objects.requireNonNull(value, "leftAtom");
    return new ImmutableAtomPair(this, newValue, this.rightAtom);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AtomPair#rightAtom() rightAtom} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rightAtom
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAtomPair withRightAtom(PdbAtomLine value) {
    if (this.rightAtom == value) return this;
    PdbAtomLine newValue = Objects.requireNonNull(value, "rightAtom");
    return new ImmutableAtomPair(this, this.leftAtom, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAtomPair} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAtomPair
        && equalTo((ImmutableAtomPair) another);
  }

  private boolean equalTo(ImmutableAtomPair another) {
    return leftAtom.equals(another.leftAtom)
        && rightAtom.equals(another.rightAtom);
  }

  /**
   * Computes a hash code from attributes: {@code leftAtom}, {@code rightAtom}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + leftAtom.hashCode();
    h += (h << 5) + rightAtom.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AtomPair} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AtomPair{"
        + "leftAtom=" + leftAtom
        + ", rightAtom=" + rightAtom
        + "}";
  }

  private transient volatile long lazyInitBitmap;

  private static final long DISTANCE_LAZY_INIT_BIT = 0x1L;

  private transient double distance;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AtomPair#distance() distance} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code distance} attribute
   */
  @Override
  protected double distance() {
    if ((lazyInitBitmap & DISTANCE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & DISTANCE_LAZY_INIT_BIT) == 0) {
          this.distance = super.distance();
          lazyInitBitmap |= DISTANCE_LAZY_INIT_BIT;
        }
      }
    }
    return distance;
  }

  private static final long BOND_LENGTH_LAZY_INIT_BIT = 0x2L;

  private transient BondLength bondLength;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link AtomPair#bondLength() bondLength} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code bondLength} attribute
   */
  @Override
  protected BondLength bondLength() {
    if ((lazyInitBitmap & BOND_LENGTH_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & BOND_LENGTH_LAZY_INIT_BIT) == 0) {
          this.bondLength = Objects.requireNonNull(super.bondLength(), "bondLength");
          lazyInitBitmap |= BOND_LENGTH_LAZY_INIT_BIT;
        }
      }
    }
    return bondLength;
  }

  /**
   * Construct a new immutable {@code AtomPair} instance.
   * @param leftAtom The value for the {@code leftAtom} attribute
   * @param rightAtom The value for the {@code rightAtom} attribute
   * @return An immutable AtomPair instance
   */
  public static ImmutableAtomPair of(PdbAtomLine leftAtom, PdbAtomLine rightAtom) {
    return new ImmutableAtomPair(leftAtom, rightAtom);
  }

  /**
   * Creates an immutable copy of a {@link AtomPair} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AtomPair instance
   */
  public static ImmutableAtomPair copyOf(AtomPair instance) {
    if (instance instanceof ImmutableAtomPair) {
      return (ImmutableAtomPair) instance;
    }
    return ImmutableAtomPair.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAtomPair ImmutableAtomPair}.
   * <pre>
   * ImmutableAtomPair.builder()
   *    .leftAtom(pl.poznan.put.pdb.PdbAtomLine) // required {@link AtomPair#leftAtom() leftAtom}
   *    .rightAtom(pl.poznan.put.pdb.PdbAtomLine) // required {@link AtomPair#rightAtom() rightAtom}
   *    .build();
   * </pre>
   * @return A new ImmutableAtomPair builder
   */
  public static ImmutableAtomPair.Builder builder() {
    return new ImmutableAtomPair.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAtomPair ImmutableAtomPair}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AtomPair", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LEFT_ATOM = 0x1L;
    private static final long INIT_BIT_RIGHT_ATOM = 0x2L;
    private long initBits = 0x3L;

    private @Nullable PdbAtomLine leftAtom;
    private @Nullable PdbAtomLine rightAtom;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AtomPair} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AtomPair instance) {
      Objects.requireNonNull(instance, "instance");
      leftAtom(instance.leftAtom());
      rightAtom(instance.rightAtom());
      return this;
    }

    /**
     * Initializes the value for the {@link AtomPair#leftAtom() leftAtom} attribute.
     * @param leftAtom The value for leftAtom 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder leftAtom(PdbAtomLine leftAtom) {
      this.leftAtom = Objects.requireNonNull(leftAtom, "leftAtom");
      initBits &= ~INIT_BIT_LEFT_ATOM;
      return this;
    }

    /**
     * Initializes the value for the {@link AtomPair#rightAtom() rightAtom} attribute.
     * @param rightAtom The value for rightAtom 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rightAtom(PdbAtomLine rightAtom) {
      this.rightAtom = Objects.requireNonNull(rightAtom, "rightAtom");
      initBits &= ~INIT_BIT_RIGHT_ATOM;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAtomPair ImmutableAtomPair}.
     * @return An immutable instance of AtomPair
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAtomPair build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAtomPair(null, leftAtom, rightAtom);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LEFT_ATOM) != 0) attributes.add("leftAtom");
      if ((initBits & INIT_BIT_RIGHT_ATOM) != 0) attributes.add("rightAtom");
      return "Cannot build AtomPair, some of required attributes are not set " + attributes;
    }
  }
}
